/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpRsaPrivateCrtKey;
import com.amazon.corretto.crypto.provider.EvpRsaPublicKey;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.Loader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

class RsaGen
extends KeyPairGeneratorSpi {
    private static final int MIN_KEY_SIZE = Loader.FIPS_BUILD ? 2048 : 512;
    private static final RSAKeyGenParameterSpec DEFAULT_KEYGEN_SPEC = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
    private final KeyFactory keyFactory;
    private final AmazonCorrettoCryptoProvider provider_;
    private RSAKeyGenParameterSpec kgSpec;

    RsaGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.keyFactory = this.provider_.getKeyFactory(EvpKeyType.RSA);
        this.kgSpec = DEFAULT_KEYGEN_SPEC;
    }

    private static native long generateEvpKey(int var0, boolean var1, byte[] var2);

    @Override
    public KeyPair generateKeyPair() {
        int n = this.kgSpec.getKeysize();
        byte[] byArray = this.kgSpec.getPublicExponent().toByteArray();
        EvpRsaPrivateCrtKey evpRsaPrivateCrtKey = new EvpRsaPrivateCrtKey(RsaGen.generateEvpKey(n, this.provider_.hasExtraCheck(ExtraCheck.KEY_PAIR_GENERATION_CONSISTENCY), byArray));
        EvpRsaPublicKey evpRsaPublicKey = evpRsaPrivateCrtKey.getPublicKey();
        return new KeyPair(evpRsaPublicKey, evpRsaPrivateCrtKey);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported AlgorithmParameterSpec: " + algorithmParameterSpec);
        }
        this.kgSpec = RsaGen.validateParameter((RSAKeyGenParameterSpec)algorithmParameterSpec);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            this.kgSpec = RsaGen.validateParameter(new RSAKeyGenParameterSpec(n, RSAKeyGenParameterSpec.F4));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private static RSAKeyGenParameterSpec validateParameter(RSAKeyGenParameterSpec rSAKeyGenParameterSpec) throws InvalidAlgorithmParameterException {
        if (Loader.FIPS_BUILD && !RSAKeyGenParameterSpec.F4.equals(rSAKeyGenParameterSpec.getPublicExponent())) {
            throw new InvalidAlgorithmParameterException("For FIPS builds, public exponent must be equal to F4");
        }
        if (rSAKeyGenParameterSpec.getKeysize() < MIN_KEY_SIZE) {
            throw new InvalidAlgorithmParameterException("Unsupported key size: " + rSAKeyGenParameterSpec.getKeysize());
        }
        return rSAKeyGenParameterSpec;
    }

    static {
        Loader.load();
    }
}

