package org.apache.cayenne.testdo.mt.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.mt.MtTable2;
import org.apache.cayenne.testdo.mt.MtTable3;

/**
 * Class _MtTable3 was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _MtTable3 extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<MtTable3> SELF = PropertyFactory.createSelf(MtTable3.class);

    public static final NumericIdProperty<Integer> TABLE3_ID_PK_PROPERTY = PropertyFactory.createNumericId("TABLE3_ID", "MtTable3", Integer.class);
    public static final String TABLE3_ID_PK_COLUMN = "TABLE3_ID";

    public static final BaseProperty<byte[]> BINARY_COLUMN = PropertyFactory.createBase("binaryColumn", byte[].class);
    public static final StringProperty<String> CHAR_COLUMN = PropertyFactory.createString("charColumn", String.class);
    public static final NumericProperty<Integer> INT_COLUMN = PropertyFactory.createNumeric("intColumn", Integer.class);
    public static final ListProperty<MtTable2> TABLE2ARRAY = PropertyFactory.createList("table2Array", MtTable2.class);

    protected byte[] binaryColumn;
    protected String charColumn;
    protected Integer intColumn;

    protected Object table2Array;

    public void setBinaryColumn(byte[] binaryColumn) {
        beforePropertyWrite("binaryColumn", this.binaryColumn, binaryColumn);
        this.binaryColumn = binaryColumn;
    }

    public byte[] getBinaryColumn() {
        beforePropertyRead("binaryColumn");
        return this.binaryColumn;
    }

    public void setCharColumn(String charColumn) {
        beforePropertyWrite("charColumn", this.charColumn, charColumn);
        this.charColumn = charColumn;
    }

    public String getCharColumn() {
        beforePropertyRead("charColumn");
        return this.charColumn;
    }

    public void setIntColumn(Integer intColumn) {
        beforePropertyWrite("intColumn", this.intColumn, intColumn);
        this.intColumn = intColumn;
    }

    public Integer getIntColumn() {
        beforePropertyRead("intColumn");
        return this.intColumn;
    }

    public void addToTable2Array(MtTable2 obj) {
        addToManyTarget("table2Array", obj, true);
    }

    public void removeFromTable2Array(MtTable2 obj) {
        removeToManyTarget("table2Array", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<MtTable2> getTable2Array() {
        return (List<MtTable2>)readProperty("table2Array");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "binaryColumn":
                return this.binaryColumn;
            case "charColumn":
                return this.charColumn;
            case "intColumn":
                return this.intColumn;
            case "table2Array":
                return this.table2Array;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "binaryColumn":
                this.binaryColumn = (byte[])val;
                break;
            case "charColumn":
                this.charColumn = (String)val;
                break;
            case "intColumn":
                this.intColumn = (Integer)val;
                break;
            case "table2Array":
                this.table2Array = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.binaryColumn);
        out.writeObject(this.charColumn);
        out.writeObject(this.intColumn);
        out.writeObject(this.table2Array);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.binaryColumn = (byte[])in.readObject();
        this.charColumn = (String)in.readObject();
        this.intColumn = (Integer)in.readObject();
        this.table2Array = in.readObject();
    }

}
