/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.monitor;

import com.google.common.annotations.VisibleForTesting;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.monitor.JVMQuake$;
import org.slf4j.Logger;
import scala.Function0;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0017.\u0001qB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\")A\f\u0001C\u0001;\"9!\r\u0001b\u0001\n\u0003\u0019\u0007B\u00023\u0001A\u0003%\u0011\u000bC\u0004f\u0001\u0001\u0007I\u0011\u00014\t\u000f)\u0004\u0001\u0019!C\u0001W\"1\u0011\u000f\u0001Q!\n\u001dDaA\u001d\u0001!\u0002\u00139\u0007BB:\u0001A\u0003%A\u000f\u0003\u0004x\u0001\u0001\u0006I\u0001\u001f\u0005\u0007w\u0002\u0001\u000b\u0011\u0002;\t\rq\u0004\u0001\u0015!\u0003u\u0011\u0019i\b\u0001)A\u0005O\"1a\u0010\u0001Q\u0001\nECqa \u0001!\u0002\u0013\t\t\u0001C\u0004\u0002\b\u0001\u0001\u000b\u0015\u0002;\t\u000f\u0005%\u0001\u0001)Q\u0005i\"9\u00111\u0002\u0001!B\u0013!\bbCA\u0007\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001fAq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002(\u0001!\t!!\n\t\u000f\u0005%\u0002\u0001\"\u0003\u0002&!1\u00111\u0006\u0001\u0005\u0002\u0019Da!!\f\u0001\t\u0003\u0019\u0007BBA$\u0001\u0011\u00051\rC\u0004\u0002L\u0001!I!!\u0014\t\u0013\u0005m\u0003!%A\u0005\n\u0005usaBA:[!\u0005\u0011Q\u000f\u0004\u0007Y5B\t!a\u001e\t\rqsB\u0011AA=\u0011)\tYH\ba\u0001\u0002\u0003\u0006KA\u0018\u0005\b\u0003{rB\u0011AA@\u0011\u001d\t)I\bC\u0001\u0003\u000fCq!!#\u001f\t\u0003\tY\t\u0003\u0006\u0002\u0010zA)\u0019)C\u0005\u0003#C!\"!*\u001f\u0011\u000b\u0007K\u0011BAT\u0011)\tyK\bECB\u0013%\u0011q\u0015\u0005\u000b\u0003cs\u0002R1Q\u0005\n\u0005\u001d\u0006BCAZ=!\u0015\r\u0015\"\u0003\u0002(\"9\u0011Q\u0017\u0010\u0005\n\u0005]\u0006bBA]=\u0011%\u0011q\u0017\u0005\n\u0003ws\u0012\u0013!C\u0001\u0003{\u0013\u0001B\u0013,N#V\f7.\u001a\u0006\u0003]=\nq!\\8oSR|'O\u0003\u00021c\u00051qo\u001c:lKJT!AM\u001a\u0002\r\u0011,\u0007\u000f\\8z\u0015\t!T'A\u0004tKJ4\u0018nY3\u000b\u0005Y:\u0014\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005aJ\u0014AB1qC\u000eDWMC\u0001;\u0003\ry'oZ\u0002\u0001'\r\u0001Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005!+\u0014AB2p[6|g.\u0003\u0002K\u000b\n9Aj\\4hS:<\u0017\u0001B2p]\u001a\u0004\"!\u0014(\u000e\u0003\u001dK!aT$\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\u0002\u0011Ut\u0017.];f\u0013\u0012\u0004\"AU-\u000f\u0005M;\u0006C\u0001+@\u001b\u0005)&B\u0001,<\u0003\u0019a$o\\8u}%\u0011\u0001lP\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Y\u007f\u00051A(\u001b8jiz\"2A\u00181b!\ty\u0006!D\u0001.\u0011\u0015Y5\u00011\u0001M\u0011\u001d\u00016\u0001%AA\u0002E\u000b\u0001\u0002Z;na\u001aKG.Z\u000b\u0002#\u0006IA-^7q\r&dW\rI\u0001\u000bQ\u0016\f\u0007\u000fR;na\u0016$W#A4\u0011\u0005yB\u0017BA5@\u0005\u001d\u0011un\u001c7fC:\fa\u0002[3ba\u0012+X\u000e]3e?\u0012*\u0017\u000f\u0006\u0002m_B\u0011a(\\\u0005\u0003]~\u0012A!\u00168ji\"9\u0001oBA\u0001\u0002\u00049\u0017a\u0001=%c\u0005Y\u0001.Z1q\tVl\u0007/\u001a3!\u0003\u001d)g.\u00192mK\u0012\fQb\u00195fG.Le\u000e^3sm\u0006d\u0007C\u0001 v\u0013\t1xH\u0001\u0003M_:<\u0017!\u0004:v]RLW.Z,fS\u001eDG\u000f\u0005\u0002?s&\u0011!p\u0010\u0002\u0007\t>,(\r\\3\u0002\u001b\u0011,X\u000e\u001d+ie\u0016\u001c\bn\u001c7e\u00035Y\u0017\u000e\u001c7UQJ,7\u000f[8mI\u0006YA-^7q\u000b:\f'\r\\3e\u0003!!W/\u001c9QCRD\u0017\u0001C3ySR\u001cu\u000eZ3\u0011\u0007y\n\u0019!C\u0002\u0002\u0006}\u00121!\u00138u\u00031a\u0017m\u001d;Fq&$H+[7f\u0003)a\u0017m\u001d;H\u0007RKW.Z\u0001\u0007EV\u001c7.\u001a;\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003BA\t\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\r\u00037\tA!\u001e;jY*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\"\u0005M!\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006)1\u000f^1siR\tA.\u0001\u0003ti>\u0004\u0018a\u0001:v]\u0006q1\u000f[8vY\u0012DU-\u00199Ek6\u0004\u0018aE4fi\"+\u0017\r\u001d#v[B\u001c\u0016M^3QCRD\u0007fA\r\u00022A!\u00111GA\"\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012aC1o]>$\u0018\r^5p]NT1\u0001SA\u001e\u0015\u0011\ti$a\u0010\u0002\r\u001d|wn\u001a7f\u0015\t\t\t%A\u0002d_6LA!!\u0012\u00026\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002'\u001d,G\u000fS3ba\u0012+X\u000e\u001d'j].\u0004\u0016\r\u001e5)\u0007i\t\t$\u0001\u0005iK\u0006\u0004H)^7q)\u001da\u0017qJA*\u0003/Ba!!\u0015\u001c\u0001\u0004\t\u0016\u0001C:bm\u0016\u0004\u0016\r\u001e5\t\r\u0005U3\u00041\u0001R\u0003!a\u0017N\\6QCRD\u0007\u0002CA-7A\u0005\t\u0019A4\u0002\t1Lg/Z\u0001\u0013Q\u0016\f\u0007\u000fR;na\u0012\"WMZ1vYR$3'\u0006\u0002\u0002`)\u001aq-!\u0019,\u0005\u0005\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001c@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\n9GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001B\u0013,N#V\f7.\u001a\t\u0003?z\u0019\"AH\u001f\u0015\u0005\u0005U\u0014!B9vC.,\u0017AB2sK\u0006$X\rF\u0003_\u0003\u0003\u000b\u0019\tC\u0003LC\u0001\u0007A\nC\u0003QC\u0001\u0007\u0011+A\u0002hKR,\u0012AX\u0001\u0004g\u0016$Hc\u00017\u0002\u000e\"1\u00111P\u0012A\u0002y\u000b1\"\\8oSR|'/\u001a3W[V\u0011\u00111\u0013\t\u0005\u0003+\u000b\t+\u0004\u0002\u0002\u0018*\u0019a&!'\u000b\t\u0005m\u0015QT\u0001\bUZl7\u000f^1u\u0015\t\ty*A\u0002tk:LA!a)\u0002\u0018\nYQj\u001c8ji>\u0014X\r\u001a,n\u0003IIxmY#ySR$\u0016.\\3N_:LGo\u001c:\u0016\u0005\u0005%\u0006\u0003BAK\u0003WKA!!,\u0002\u0018\n9Qj\u001c8ji>\u0014\u0018A\u00054hG\u0016C\u0018\u000e\u001e+j[\u0016luN\\5u_J\fa\"_4d)&lW-T8oSR|'/\u0001\bgO\u000e$\u0016.\\3N_:LGo\u001c:\u0002\u001f\u001d,G\u000fT1ti\u0016C\u0018\u000e\u001e+j[\u0016,\u0012\u0001^\u0001\u000eO\u0016$H*Y:u\u000f\u000e#\u0016.\\3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyLK\u0002R\u0003C\u0002")
public class JVMQuake
implements Logging {
    private final String dumpFile;
    private boolean heapDumped;
    private final boolean enabled;
    private final long checkInterval;
    private final double runtimeWeight;
    private final long dumpThreshold;
    private final long killThreshold;
    private final boolean dumpEnabled;
    private final String dumpPath;
    private final int exitCode;
    private long lastExitTime;
    private long lastGCTime;
    private long bucket;
    private ScheduledExecutorService scheduler;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static String $lessinit$greater$default$2() {
        return JVMQuake$.MODULE$.$lessinit$greater$default$2();
    }

    public static void set(JVMQuake jVMQuake) {
        JVMQuake$.MODULE$.set(jVMQuake);
    }

    public static JVMQuake get() {
        return JVMQuake$.MODULE$.get();
    }

    public static JVMQuake create(CelebornConf celebornConf, String string) {
        return JVMQuake$.MODULE$.create(celebornConf, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        JVMQuake jVMQuake = this;
        synchronized (jVMQuake) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String dumpFile() {
        return this.dumpFile;
    }

    public boolean heapDumped() {
        return this.heapDumped;
    }

    public void heapDumped_$eq(boolean x$1) {
        this.heapDumped = x$1;
    }

    public void start() {
        block0: {
            if (!this.enabled) break block0;
            this.lastExitTime = JVMQuake$.MODULE$.org$apache$celeborn$service$deploy$worker$monitor$JVMQuake$$getLastExitTime();
            this.lastGCTime = JVMQuake$.MODULE$.org$apache$celeborn$service$deploy$worker$monitor$JVMQuake$$getLastGCTime();
            this.scheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("worker-jvm-quake-scheduler");
            this.scheduler.scheduleWithFixedDelay(new Runnable(this){
                private final /* synthetic */ JVMQuake $outer;

                public void run() {
                    this.$outer.org$apache$celeborn$service$deploy$worker$monitor$JVMQuake$$run();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, 0L, this.checkInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        block0: {
            if (!this.enabled) break block0;
            this.scheduler.shutdown();
        }
    }

    public void org$apache$celeborn$service$deploy$worker$monitor$JVMQuake$$run() {
        long currentExitTime = JVMQuake$.MODULE$.org$apache$celeborn$service$deploy$worker$monitor$JVMQuake$$getLastExitTime();
        long currentGCTime = JVMQuake$.MODULE$.org$apache$celeborn$service$deploy$worker$monitor$JVMQuake$$getLastGCTime();
        long gcTime = currentGCTime - this.lastGCTime;
        long runTime = currentExitTime - this.lastExitTime - gcTime;
        this.bucket = Math.max(0L, this.bucket + gcTime - package$.MODULE$.BigDecimal().apply((double)runTime * this.runtimeWeight).toLong());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Time: (gc time: ").append(Utils$.MODULE$.msDurationToString(gcTime)).append(", execution time: ").append(Utils$.MODULE$.msDurationToString(runTime)).append(")").toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Capacity: (bucket: ").append($this.bucket).append(", dump threshold: ").append($this.dumpThreshold).append(", kill threshold: ").append($this.killThreshold).append(")").toString());
        if (this.bucket > this.dumpThreshold) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("JVM GC has reached the threshold: bucket: ").append($this.bucket).append(", dumpThreshold: ").append($this.dumpThreshold).append(".").toString());
            if (this.shouldHeapDump()) {
                String savePath = this.getHeapDumpSavePath();
                String linkPath = this.getHeapDumpLinkPath();
                this.heapDump(savePath, linkPath, this.heapDump$default$3());
            } else if (this.bucket > this.killThreshold) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Exit JVM with ").append($this.exitCode).append(". JVM GC has reached the threshold: bucket: ").append($this.bucket).append(", killThreshold: ").append($this.killThreshold).append(".").toString());
                System.exit(this.exitCode);
            }
        }
        this.lastExitTime = currentExitTime;
        this.lastGCTime = currentGCTime;
    }

    public boolean shouldHeapDump() {
        return this.dumpEnabled && !this.heapDumped();
    }

    @VisibleForTesting
    public String getHeapDumpSavePath() {
        return this.dumpPath;
    }

    @VisibleForTesting
    public String getHeapDumpLinkPath() {
        return new StringBuilder(6).append(new File(this.dumpPath).getParent()).append("/link/").append(Utils$.MODULE$.getProcessId()).toString();
    }

    private void heapDump(String savePath, String linkPath, boolean live) {
        Object object;
        File saveDir = new File(savePath);
        Object object2 = !saveDir.exists() ? BoxesRunTime.boxToBoolean((boolean)saveDir.mkdirs()) : BoxedUnit.UNIT;
        File heapDump = new File(saveDir, this.dumpFile());
        if (heapDump.exists()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Skip because heap dump of worker already exists: ").append(heapDump).append(".").toString());
            this.heapDumped_$eq(true);
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Starting heap dump: ").append(heapDump).append(".").toString());
        ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class).dumpHeap(heapDump.getAbsolutePath(), live);
        File linkDir = new File(linkPath);
        if (linkDir.exists()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Skip because symbolic link of heap dump exists: ").append(linkPath).append(".").toString());
            object = BoxedUnit.UNIT;
        } else {
            object = !linkDir.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)linkDir.getParentFile().mkdirs()) : BoxedUnit.UNIT;
        }
        try {
            try {
                Files.createSymbolicLink(linkDir.toPath(), saveDir.toPath(), new FileAttribute[0]);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Created symbolic link: ").append(linkPath).append(".").toString());
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Create symbolic link failed.", e);
            }
        }
        finally {
            this.heapDumped_$eq(true);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Finished heap dump: ").append(this.dumpFile()).append(".").toString());
        }
    }

    private boolean heapDump$default$3() {
        return false;
    }

    public JVMQuake(CelebornConf conf, String uniqueId) {
        Logging.$init$((Logging)this);
        this.dumpFile = new StringBuilder(28).append("worker-quake-heapdump-").append(uniqueId).append(".hprof").toString();
        this.heapDumped = false;
        this.enabled = conf.workerJvmQuakeEnabled();
        this.checkInterval = conf.workerJvmQuakeCheckInterval();
        this.runtimeWeight = conf.workerJvmQuakeRuntimeWeight();
        this.dumpThreshold = conf.workerJvmQuakeDumpThreshold().toNanos();
        this.killThreshold = conf.workerJvmQuakeKillThreshold().toNanos();
        this.dumpEnabled = conf.workerJvmQuakeDumpEnabled();
        this.dumpPath = conf.workerJvmQuakeDumpPath();
        this.exitCode = conf.workerJvmQuakeExitCode();
        this.lastExitTime = 0L;
        this.lastGCTime = 0L;
        this.bucket = 0L;
    }
}

