/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.RemoteShuffleInputGateDelegation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.metrics.groups.ShuffleIOMetricGroup;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.SupplierWithException;

public abstract class AbstractRemoteShuffleInputGate
extends IndexedInputGate {
    public final RemoteShuffleInputGateDelegation inputGateDelegation;

    public AbstractRemoteShuffleInputGate(CelebornConf celebornConf, ShuffleIOOwnerContext ownerContext, int gateIndex, InputGateDeploymentDescriptor gateDescriptor, SupplierWithException<BufferPool, IOException> bufferPoolFactory, BufferDecompressor bufferDecompressor, int numConcurrentReading, Map<Integer, ShuffleIOMetricGroup> shuffleIOMetricGroups) {
        Tuple2<Integer, Integer> indexRange = this.getConsumedSubpartitionIndexRange(gateDescriptor);
        this.inputGateDelegation = new RemoteShuffleInputGateDelegation(celebornConf, ownerContext, gateIndex, gateDescriptor, bufferPoolFactory, bufferDecompressor, numConcurrentReading, this.availabilityHelper, (Integer)indexRange.f0, (Integer)indexRange.f1, shuffleIOMetricGroups);
    }

    public void setup() throws IOException {
        this.inputGateDelegation.setup();
    }

    public int getGateIndex() {
        return this.inputGateDelegation.getGateIndex();
    }

    public int getNumberOfInputChannels() {
        return this.inputGateDelegation.getBufferReaders().size();
    }

    public boolean isFinished() {
        return this.inputGateDelegation.isFinished();
    }

    public Optional<BufferOrEvent> getNext() {
        throw new UnsupportedOperationException("Not implemented (DataSet API is not supported).");
    }

    public Optional<BufferOrEvent> pollNext() throws IOException {
        return this.inputGateDelegation.pollNext();
    }

    public void close() throws Exception {
        this.inputGateDelegation.close();
    }

    public List<InputChannelInfo> getChannelInfos() {
        return this.inputGateDelegation.getChannelsInfo();
    }

    public void requestPartitions() {
    }

    public void checkpointStarted(CheckpointBarrier barrier) {
    }

    public void checkpointStopped(long cancelledCheckpointId) {
    }

    public void triggerDebloating() {
    }

    public List<InputChannelInfo> getUnfinishedChannels() {
        return Collections.emptyList();
    }

    public PullingAsyncDataInput.EndOfDataStatus hasReceivedEndOfData() {
        if (this.inputGateDelegation.getPendingEndOfDataEvents() > 0L) {
            return PullingAsyncDataInput.EndOfDataStatus.NOT_END_OF_DATA;
        }
        return PullingAsyncDataInput.EndOfDataStatus.DRAINED;
    }

    public void finishReadRecoveredState() {
    }

    public abstract InputChannel getChannel(int var1);

    public void sendTaskEvent(TaskEvent event) {
        throw new FlinkRuntimeException("Method should not be called.");
    }

    public void resumeGateConsumption() throws IOException {
        throw new FlinkRuntimeException("Method should not be called.");
    }

    public void resumeConsumption(InputChannelInfo channelInfo) {
        throw new FlinkRuntimeException("Method should not be called.");
    }

    public void acknowledgeAllRecordsProcessed(InputChannelInfo inputChannelInfo) {
    }

    public CompletableFuture<Void> getStateConsumedFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return String.format("ReadGate [owning task: %s, gate index: %d, descriptor: %s]", this.inputGateDelegation.getTaskName(), this.inputGateDelegation.getGateIndex(), this.inputGateDelegation.getGateDescriptor().toString());
    }

    public abstract Tuple2<Integer, Integer> getConsumedSubpartitionIndexRange(InputGateDeploymentDescriptor var1);
}

