/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;

public class NettyManagedBuffer
extends ManagedBuffer {
    public static NettyManagedBuffer EmptyBuffer = new NettyManagedBuffer(Unpooled.buffer((int)0, (int)0));
    private final ByteBuf buf;

    public NettyManagedBuffer(ByteBuf buf) {
        this.buf = buf;
    }

    public NettyManagedBuffer(ByteBuffer buffer) {
        this.buf = Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    public ByteBuf getBuf() {
        return this.buf.duplicate();
    }

    @Override
    public long size() {
        return this.buf.readableBytes();
    }

    @Override
    public ByteBuffer nioByteBuffer() throws IOException {
        return this.buf.nioBuffer();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new ByteBufInputStream(this.buf);
    }

    @Override
    public ManagedBuffer retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public ManagedBuffer release() {
        this.buf.release();
        return this;
    }

    @Override
    public Object convertToNetty() throws IOException {
        return this.buf.duplicate().retain();
    }

    @Override
    public Object convertToNettyForSsl() throws IOException {
        return this.buf.duplicate().retain();
    }

    public String toString() {
        return "NettyManagedBuffer[buf=" + this.buf + "]";
    }
}

