/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.io.netty.handler.codec.mqtt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.celeborn.shaded.io.netty.handler.codec.mqtt.MqttQoS;
import org.apache.celeborn.shaded.io.netty.handler.codec.mqtt.MqttReasonCodes;
import org.apache.celeborn.shaded.io.netty.util.internal.ObjectUtil;
import org.apache.celeborn.shaded.io.netty.util.internal.StringUtil;

public class MqttSubAckPayload {
    private final List<MqttReasonCodes.SubAck> reasonCodes;

    public MqttSubAckPayload(int ... reasonCodes) {
        ObjectUtil.checkNotNull(reasonCodes, "reasonCodes");
        ArrayList<MqttReasonCodes.SubAck> list = new ArrayList<MqttReasonCodes.SubAck>(reasonCodes.length);
        for (int v : reasonCodes) {
            list.add(MqttReasonCodes.SubAck.valueOf((byte)(v & 0xFF)));
        }
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public MqttSubAckPayload(MqttReasonCodes.SubAck ... reasonCodes) {
        ObjectUtil.checkNotNull(reasonCodes, "reasonCodes");
        ArrayList<MqttReasonCodes.SubAck> list = new ArrayList<MqttReasonCodes.SubAck>(reasonCodes.length);
        list.addAll(Arrays.asList(reasonCodes));
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public MqttSubAckPayload(Iterable<Integer> reasonCodes) {
        ObjectUtil.checkNotNull(reasonCodes, "reasonCodes");
        ArrayList<MqttReasonCodes.SubAck> list = new ArrayList<MqttReasonCodes.SubAck>();
        for (Integer v : reasonCodes) {
            if (v == null) break;
            list.add(MqttReasonCodes.SubAck.valueOf(v.byteValue()));
        }
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public List<Integer> grantedQoSLevels() {
        ArrayList<Integer> qosLevels = new ArrayList<Integer>(this.reasonCodes.size());
        for (MqttReasonCodes.SubAck code : this.reasonCodes) {
            if ((code.byteValue() & 0xFF) > MqttQoS.EXACTLY_ONCE.value()) {
                qosLevels.add(MqttQoS.FAILURE.value());
                continue;
            }
            qosLevels.add(code.byteValue() & 0xFF);
        }
        return qosLevels;
    }

    public List<Integer> reasonCodes() {
        return this.typedReasonCodesToOrdinal();
    }

    private List<Integer> typedReasonCodesToOrdinal() {
        ArrayList<Integer> intCodes = new ArrayList<Integer>(this.reasonCodes.size());
        for (MqttReasonCodes.SubAck code : this.reasonCodes) {
            intCodes.add(code.byteValue() & 0xFF);
        }
        return intCodes;
    }

    public List<MqttReasonCodes.SubAck> typedReasonCodes() {
        return this.reasonCodes;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '[' + "reasonCodes=" + this.reasonCodes + ']';
    }
}

