/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.shuffledb;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.celeborn.service.deploy.worker.shuffledb.DBIterator;
import org.rocksdb.RocksIterator;

public class RocksDBIterator
implements DBIterator {
    private final RocksIterator it;
    private boolean checkedNext;
    private boolean closed;
    private Map.Entry<byte[], byte[]> next;

    public RocksDBIterator(RocksIterator it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        if (!this.checkedNext && !this.closed) {
            this.next = this.loadNext();
            this.checkedNext = true;
        }
        if (!this.closed && this.next == null) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw Throwables.propagate((Throwable)ioe);
            }
        }
        return this.next != null;
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checkedNext = false;
        Map.Entry<byte[], byte[]> ret = this.next;
        this.next = null;
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.it.close();
            this.closed = true;
            this.next = null;
        }
    }

    @Override
    public void seek(byte[] key) {
        this.it.seek(key);
    }

    private Map.Entry<byte[], byte[]> loadNext() {
        if (this.it.isValid()) {
            AbstractMap.SimpleEntry<byte[], byte[]> nextEntry = new AbstractMap.SimpleEntry<byte[], byte[]>(this.it.key(), this.it.value());
            this.it.next();
            return nextEntry;
        }
        return null;
    }
}

