/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.client.read.checkpoint.PartitionReaderCheckpointMetadata;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsPartitionReader
implements PartitionReader {
    private static Logger logger = LoggerFactory.getLogger(DfsPartitionReader.class);
    private CelebornConf conf;
    PartitionLocation location;
    private final long shuffleChunkSize;
    private final int fetchMaxReqsInFlight;
    private final LinkedBlockingQueue<Pair<Integer, ByteBuf>> results;
    private final AtomicReference<Exception> exception = new AtomicReference();
    private volatile boolean closed = false;
    private ExecutorService fetchThread;
    private boolean fetchThreadStarted;
    private FSDataInputStream dfsInputStream;
    private int numChunks = 0;
    private int lastReturnedChunkId = -1;
    private int returnedChunks = 0;
    private int currentChunkIndex = 0;
    private int startChunkIndex;
    private int endChunkIndex;
    private final List<Long> chunkOffsets = new ArrayList<Long>();
    private TransportClient client;
    private PbStreamHandler streamHandler;
    private MetricsCallback metricsCallback;
    private long partitionReaderWaitLogThreshold;
    private FileSystem hadoopFs;
    private Path dataFilePath;
    private Optional<PartitionReaderCheckpointMetadata> partitionReaderCheckpointMetadata;

    public DfsPartitionReader(CelebornConf conf, String shuffleKey, PartitionLocation location, PbStreamHandler pbStreamHandler, TransportClientFactory clientFactory, int startMapIndex, int endMapIndex, MetricsCallback metricsCallback, int startChunkIndex, int endChunkIndex, Optional<PartitionReaderCheckpointMetadata> checkpointMetadata) throws IOException {
        this.conf = conf;
        this.shuffleChunkSize = conf.dfsReadChunkSize();
        this.fetchMaxReqsInFlight = conf.clientFetchMaxReqsInFlight();
        this.results = new LinkedBlockingQueue();
        this.metricsCallback = metricsCallback;
        this.partitionReaderWaitLogThreshold = conf.clientPartitionReaderWaitLogThreshold();
        this.location = location;
        this.hadoopFs = location.getStorageInfo() != null && location.getStorageInfo().getType() == StorageInfo.Type.S3 ? ShuffleClient.getHadoopFs(conf).get((Object)StorageInfo.Type.S3) : (location.getStorageInfo() != null && location.getStorageInfo().getType() == StorageInfo.Type.OSS ? ShuffleClient.getHadoopFs(conf).get((Object)StorageInfo.Type.OSS) : ShuffleClient.getHadoopFs(conf).get((Object)StorageInfo.Type.HDFS));
        long fetchTimeoutMs = conf.clientFetchTimeoutMs();
        try {
            this.client = clientFactory.createClient(location.getHost(), location.getFetchPort());
            if (pbStreamHandler == null) {
                TransportMessage openStream = new TransportMessage(MessageType.OPEN_STREAM, PbOpenStream.newBuilder().setShuffleKey(shuffleKey).setFileName(location.getFileName()).setStartIndex(startMapIndex).setEndIndex(endMapIndex).build().toByteArray());
                ByteBuffer response = this.client.sendRpcSync(openStream.toByteBuffer(), fetchTimeoutMs);
                this.streamHandler = (PbStreamHandler)TransportMessage.fromByteBuffer(response).getParsedPayload();
            } else {
                this.streamHandler = pbStreamHandler;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("read shuffle file from DFS failed, filePath: " + location.getStorageInfo().getFilePath(), e);
        }
        if (endMapIndex != Integer.MAX_VALUE && endMapIndex != -1) {
            this.dataFilePath = new Path(Utils.getSortedFilePath(location.getStorageInfo().getFilePath()));
            this.dfsInputStream = this.hadoopFs.open(this.dataFilePath);
            this.chunkOffsets.addAll(this.getChunkOffsetsFromSortedIndex(conf, location, startMapIndex, endMapIndex));
        } else {
            this.dataFilePath = new Path(location.getStorageInfo().getFilePath());
            this.dfsInputStream = this.hadoopFs.open(this.dataFilePath);
            this.chunkOffsets.addAll(this.getChunkOffsetsFromUnsortedIndex(location));
        }
        this.startChunkIndex = startChunkIndex == -1 ? 0 : startChunkIndex;
        this.endChunkIndex = endChunkIndex == -1 ? this.chunkOffsets.size() - 2 : Math.min(this.chunkOffsets.size() - 2, endChunkIndex);
        this.currentChunkIndex = this.startChunkIndex;
        this.numChunks = this.endChunkIndex - this.startChunkIndex + 1;
        if (checkpointMetadata.isPresent()) {
            this.partitionReaderCheckpointMetadata = checkpointMetadata;
            this.returnedChunks = checkpointMetadata.get().getReturnedChunks().size();
        } else {
            this.partitionReaderCheckpointMetadata = conf.isPartitionReaderCheckpointEnabled() ? Optional.of(new PartitionReaderCheckpointMetadata()) : Optional.empty();
        }
        logger.debug("DFS {} total offset count:{} chunk count: {} start chunk index:{} end chunk index:{} offsets:{}", new Object[]{location.getStorageInfo().getFilePath(), this.chunkOffsets.size(), this.numChunks, this.startChunkIndex, this.endChunkIndex, this.chunkOffsets});
        if (this.numChunks > 0) {
            this.fetchThread = ThreadUtils.newDaemonSingleThreadExecutor("celeborn-client-dfs-partition-fetcher" + location.getStorageInfo().getFilePath());
            logger.debug("Start dfs read on location {}", (Object)location);
            ShuffleClient.incrementTotalReadCounter();
        }
    }

    private List<Long> getChunkOffsetsFromUnsortedIndex(PartitionLocation location) throws IOException {
        ArrayList<Long> offsets;
        String indexPath = Utils.getIndexFilePath(location.getStorageInfo().getFilePath());
        try (FSDataInputStream indexInputStream = this.hadoopFs.open(new Path(indexPath));){
            long indexSize = this.hadoopFs.getFileStatus(new Path(indexPath)).getLen();
            byte[] indexBuffer = new byte[(int)indexSize];
            indexInputStream.readFully(0L, indexBuffer);
            ByteBuffer buffer = ByteBuffer.wrap(indexBuffer);
            int offsetSize = buffer.getInt();
            offsets = new ArrayList<Long>(offsetSize);
            for (int i = 0; i < offsetSize; ++i) {
                offsets.add(buffer.getLong());
            }
        }
        return offsets;
    }

    private List<Long> getChunkOffsetsFromSortedIndex(CelebornConf conf, PartitionLocation location, int startMapIndex, int endMapIndex) throws IOException {
        ArrayList<Long> offsets;
        String indexPath = Utils.getIndexFilePath(location.getStorageInfo().getFilePath());
        try (FSDataInputStream indexInputStream = this.hadoopFs.open(new Path(indexPath));){
            logger.debug("read sorted index {}", (Object)indexPath);
            long indexSize = this.hadoopFs.getFileStatus(new Path(indexPath)).getLen();
            byte[] indexBuffer = new byte[(int)indexSize];
            indexInputStream.readFully(0L, indexBuffer);
            offsets = new ArrayList<Long>(ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos(startMapIndex, endMapIndex, this.shuffleChunkSize, ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer(indexBuffer), false));
        }
        return offsets;
    }

    @Override
    public boolean hasNext() {
        logger.debug("check has next current index: {} chunks {}", (Object)this.returnedChunks, (Object)this.numChunks);
        return this.returnedChunks < this.numChunks;
    }

    private void checkpoint() {
        if (this.lastReturnedChunkId != -1) {
            this.partitionReaderCheckpointMetadata.ifPresent(readerCheckpointMetadata -> readerCheckpointMetadata.checkpoint(this.lastReturnedChunkId));
        }
    }

    @Override
    public ByteBuf next() throws Exception {
        Pair<Integer, ByteBuf> chunk = null;
        this.checkpoint();
        if (!this.fetchThreadStarted) {
            this.fetchThreadStarted = true;
            this.fetchThread.submit(() -> {
                try {
                    while (!this.closed && this.currentChunkIndex <= this.endChunkIndex) {
                        if (this.partitionReaderCheckpointMetadata.isPresent() && this.partitionReaderCheckpointMetadata.get().isCheckpointed(this.currentChunkIndex)) {
                            logger.info("Skipping chunk {} as it has already been returned, likely by a previous reader for the same partition.", (Object)this.currentChunkIndex);
                            ++this.currentChunkIndex;
                            continue;
                        }
                        while (this.results.size() >= this.fetchMaxReqsInFlight) {
                            Thread.sleep(50L);
                        }
                        long offset = this.chunkOffsets.get(this.currentChunkIndex);
                        long length = this.chunkOffsets.get(this.currentChunkIndex + 1) - offset;
                        logger.debug("read {} offset {} length {}", new Object[]{this.currentChunkIndex, offset, length});
                        byte[] buffer = new byte[(int)length];
                        try {
                            this.dfsInputStream.readFully(offset, buffer);
                        }
                        catch (IOException e) {
                            logger.warn("read DFS {} failed will retry, error detail {}", (Object)this.dataFilePath, (Object)e);
                            try {
                                this.dfsInputStream.close();
                                this.dfsInputStream = this.hadoopFs.open(this.dataFilePath);
                                this.dfsInputStream.readFully(offset, buffer);
                            }
                            catch (IOException ex) {
                                logger.warn("retry read DFS {} failed, error detail {} ", (Object)this.location.getStorageInfo().getFilePath(), (Object)e);
                                this.exception.set(ex);
                                break;
                            }
                        }
                        this.results.put(Pair.of(this.currentChunkIndex, Unpooled.wrappedBuffer(buffer)));
                        logger.debug("add index {} to results", (Object)this.currentChunkIndex++);
                    }
                }
                catch (Exception e) {
                    logger.warn("Fetch thread is cancelled.", (Throwable)e);
                    this.exception.set(e);
                }
                logger.debug("fetch {} is done.", (Object)this.location.getStorageInfo().getFilePath());
            });
        }
        try {
            long totalWaitTimeMs = 0L;
            long lastLogTimeMs = 0L;
            while (chunk == null) {
                this.checkException();
                Long startFetchWait = System.nanoTime();
                chunk = this.results.poll(500L, TimeUnit.MILLISECONDS);
                long waitTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait);
                this.metricsCallback.incReadTime(waitTimeMs);
                if (chunk == null && (totalWaitTimeMs += waitTimeMs) >= lastLogTimeMs + this.partitionReaderWaitLogThreshold) {
                    lastLogTimeMs = totalWaitTimeMs;
                    logger.info("Waiting for data from partition {}/{} for {}ms", new Object[]{this.location.getFileName(), this.location.hostAndPorts(), totalWaitTimeMs});
                }
                logger.debug("poll result with result size: {}", (Object)this.results.size());
            }
            if (totalWaitTimeMs >= this.partitionReaderWaitLogThreshold) {
                logger.info("Finished waiting for data from partition {}/{} after {}ms", new Object[]{this.location.getFileName(), this.location.hostAndPorts(), totalWaitTimeMs});
            }
        }
        catch (Exception e) {
            logger.error("PartitionReader thread interrupted while fetching data.");
            throw e;
        }
        ++this.returnedChunks;
        this.lastReturnedChunkId = chunk.getLeft();
        return chunk.getRight();
    }

    private void checkException() throws Exception {
        Exception e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.fetchThread != null) {
            this.fetchThread.shutdownNow();
        }
        try {
            this.dfsInputStream.close();
        }
        catch (IOException e) {
            logger.warn("close DFS input stream failed.", (Throwable)e);
        }
        if (this.results.size() > 0) {
            this.results.forEach((Consumer<Pair<Integer, ByteBuf>>)((Consumer<Pair>)chunk -> ((ByteBuf)chunk.getRight()).release()));
        }
        this.results.clear();
        this.closeStream();
    }

    private void closeStream() {
        if (this.client != null && this.client.isActive()) {
            TransportMessage bufferStreamEnd = new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamType(StreamType.ChunkStream).setStreamId(this.streamHandler.getStreamId()).build().toByteArray());
            this.client.sendRpc(bufferStreamEnd.toByteBuffer());
        }
    }

    @Override
    public PartitionLocation getLocation() {
        return this.location;
    }

    @Override
    public Optional<PartitionReaderCheckpointMetadata> getPartitionReaderCheckpointMetadata() {
        return this.partitionReaderCheckpointMetadata;
    }
}

