/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.shaded.org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.celeborn.shaded.org.roaringbitmap.ArrayBatchIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.ArrayContainerCharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.ArraysShim;
import org.apache.celeborn.shaded.org.roaringbitmap.BitmapContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.CharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.Container;
import org.apache.celeborn.shaded.org.roaringbitmap.ContainerBatchIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.IntConsumer;
import org.apache.celeborn.shaded.org.roaringbitmap.PeekableCharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.PeekableCharRankIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.RelativeRangeConsumer;
import org.apache.celeborn.shaded.org.roaringbitmap.ReverseArrayContainerCharIterator;
import org.apache.celeborn.shaded.org.roaringbitmap.RunContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.Util;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;
import org.apache.celeborn.shaded.org.roaringbitmap.buffer.MappeableContainer;

public final class ArrayContainer
extends Container
implements Cloneable {
    private static final int DEFAULT_INIT_SIZE = 4;
    private static final int ARRAY_LAZY_LOWERBOUND = 1024;
    static final int DEFAULT_MAX_SIZE = 4096;
    private static final long serialVersionUID = 1L;
    protected int cardinality = 0;
    char[] content;

    protected static int serializedSizeInBytes(int cardinality) {
        return cardinality * 2 + 2;
    }

    public ArrayContainer() {
        this(4);
    }

    public static ArrayContainer empty() {
        return new ArrayContainer();
    }

    public ArrayContainer(int capacity) {
        this.content = new char[capacity];
    }

    public ArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun;
        this.content = new char[valuesInRange];
        for (int i = 0; i < valuesInRange; ++i) {
            this.content[i] = (char)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    public ArrayContainer(int newCard, char[] newContent) {
        this.cardinality = newCard;
        this.content = Arrays.copyOf(newContent, newCard);
    }

    public ArrayContainer(MappeableArrayContainer bc) {
        this.cardinality = bc.getCardinality();
        this.content = bc.toShortArray();
    }

    public ArrayContainer(char[] newContent) {
        this.cardinality = newContent.length;
        this.content = newContent;
    }

    @Override
    public Container add(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, indexstart, this.cardinality, (char)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            BitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        ArrayContainer answer = new ArrayContainer(newcardinality, this.content);
        System.arraycopy(this.content, indexend, answer.content, indexstart + rangelength, this.cardinality - indexend);
        for (int k = 0; k < rangelength; ++k) {
            answer.content[k + indexstart] = (char)(begin + k);
        }
        answer.cardinality = newcardinality;
        return answer;
    }

    @Override
    public Container add(char x) {
        if (this.cardinality == 0 || this.cardinality > 0 && x > this.content[this.cardinality - 1]) {
            if (this.cardinality >= 4096) {
                return this.toBitmapContainer().add(x);
            }
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            this.content[this.cardinality++] = x;
        } else {
            int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
            if (loc < 0) {
                if (this.cardinality >= 4096) {
                    return this.toBitmapContainer().add(x);
                }
                if (this.cardinality >= this.content.length) {
                    this.increaseCapacity();
                }
                System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
                this.content[-loc - 1] = x;
                ++this.cardinality;
            }
        }
        return this;
    }

    private int advance(CharIterator it) {
        if (it.hasNext()) {
            return it.next();
        }
        return -1;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container and(BitmapContainer x) {
        return x.and(this);
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public int andCardinality(ArrayContainer value2) {
        return Util.unsignedLocalIntersect2by2Cardinality(this.content, this.cardinality, value2.content, value2.getCardinality());
    }

    @Override
    public int andCardinality(BitmapContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public int andCardinality(RunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public ArrayContainer andNot(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public ArrayContainer andNot(BitmapContainer value2) {
        ArrayContainer answer = new ArrayContainer(this.content.length);
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            char val;
            answer.content[pos] = val = this.content[k];
            pos += 1 - value2.bitValue(val);
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public ArrayContainer andNot(RunContainer x) {
        if (x.numberOfRuns() == 0) {
            return this.clone();
        }
        if (x.isFull()) {
            return ArrayContainer.empty();
        }
        int write2 = 0;
        int read2 = 0;
        ArrayContainer answer = new ArrayContainer(this.cardinality);
        for (int i = 0; i < x.numberOfRuns() && read2 < this.cardinality; ++i) {
            char runStart = x.getValue(i);
            int runEnd = runStart + x.getLength(i);
            if (this.content[read2] > runEnd) continue;
            int firstInRun = Util.iterateUntil(this.content, read2, this.cardinality, runStart);
            int toWrite = firstInRun - read2;
            System.arraycopy(this.content, read2, answer.content, write2, toWrite);
            write2 += toWrite;
            read2 = Util.iterateUntil(this.content, firstInRun, this.cardinality, runEnd + 1);
        }
        System.arraycopy(this.content, read2, answer.content, write2, this.cardinality - read2);
        answer.cardinality = write2 += this.cardinality - read2;
        return answer;
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public ArrayContainer clone() {
        return new ArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean contains(char x) {
        return Util.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    @Override
    public boolean contains(int minimum, int supremum) {
        int maximum = supremum - 1;
        int start2 = Util.advanceUntil(this.content, -1, this.cardinality, (char)minimum);
        int end = Util.advanceUntil(this.content, start2 - 1, this.cardinality, (char)maximum);
        return start2 < this.cardinality && end < this.cardinality && end - start2 == maximum - minimum && this.content[start2] == (char)minimum && this.content[end] == (char)maximum;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        if (runContainer.getCardinality() > this.cardinality) {
            return false;
        }
        for (int i = 0; i < runContainer.numberOfRuns(); ++i) {
            char length;
            char start2 = runContainer.getValue(i);
            if (this.contains(start2, start2 + (length = runContainer.getLength(i)))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        if (this.cardinality < arrayContainer.cardinality) {
            return false;
        }
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.cardinality && i2 < arrayContainer.cardinality) {
            if (this.content[i1] == arrayContainer.content[i2]) {
                ++i1;
                ++i2;
                continue;
            }
            if (this.content[i1] < arrayContainer.content[i2]) {
                ++i1;
                continue;
            }
            return false;
        }
        return i2 == arrayContainer.cardinality;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        return false;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.cardinality = 0xFFFF & Character.reverseBytes(in.readChar());
        if (this.content.length < this.cardinality) {
            this.content = new char[this.cardinality];
        }
        for (int k = 0; k < this.cardinality; ++k) {
            this.content[k] = Character.reverseBytes(in.readChar());
        }
    }

    private void emit(char val) {
        if (this.cardinality == this.content.length) {
            this.increaseCapacity(true);
        }
        this.content[this.cardinality++] = val;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayContainer) {
            ArrayContainer srb = (ArrayContainer)o;
            return ArraysShim.equals(this.content, 0, this.cardinality, srb.content, 0, srb.cardinality);
        }
        if (o instanceof RunContainer) {
            return o.equals(this);
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        for (int k = 0; k < this.cardinality; ++k) {
            x[k + i] = this.content[k] | mask;
        }
    }

    @Override
    public Container flip(char x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4096) {
                BitmapContainer a = this.toBitmapContainer();
                a.add(x);
                return a;
            }
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
            this.content[-loc - 1] = x;
            ++this.cardinality;
        } else {
            System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    @Override
    public int getArraySizeInBytes() {
        return this.cardinality * 2;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public PeekableCharIterator getReverseCharIterator() {
        return new ReverseArrayContainerCharIterator(this);
    }

    @Override
    public PeekableCharIterator getCharIterator() {
        return new ArrayContainerCharIterator(this);
    }

    @Override
    public PeekableCharRankIterator getCharRankIterator() {
        return new ArrayContainerCharIterator(this);
    }

    @Override
    public ContainerBatchIterator getBatchIterator() {
        return new ArrayBatchIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2 + 4;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * hash + this.content[k];
        }
        return hash;
    }

    @Override
    public Container iadd(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, indexstart, this.cardinality, (char)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            BitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        if (newcardinality >= this.content.length) {
            char[] destination = new char[this.calculateCapacity(newcardinality)];
            System.arraycopy(this.content, 0, destination, 0, indexstart);
            for (int k = 0; k < rangelength; ++k) {
                destination[k + indexstart] = (char)(begin + k);
            }
            System.arraycopy(this.content, indexend, destination, indexstart + rangelength, this.cardinality - indexend);
            this.content = destination;
        } else {
            System.arraycopy(this.content, indexend, this.content, indexstart + rangelength, this.cardinality - indexend);
            for (int k = 0; k < rangelength; ++k) {
                this.content[k + indexstart] = (char)(begin + k);
            }
        }
        this.cardinality = newcardinality;
        return this;
    }

    @Override
    public ArrayContainer iand(ArrayContainer value2) {
        ArrayContainer value1 = this;
        value1.cardinality = Util.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content);
        return this;
    }

    @Override
    public Container iand(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            char v;
            this.content[pos] = v = this.content[k];
            pos += value2.bitValue(v);
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public Container iand(RunContainer x) {
        PeekableCharIterator it = x.getCharIterator();
        int removed = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            it.advanceIfNeeded(this.content[i]);
            if (it.peekNext() == this.content[i]) {
                this.content[i - removed] = this.content[i];
                continue;
            }
            ++removed;
        }
        this.cardinality -= removed;
        return this;
    }

    @Override
    public ArrayContainer iandNot(ArrayContainer value2) {
        this.cardinality = Util.unsignedDifference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content);
        return this;
    }

    @Override
    public ArrayContainer iandNot(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            char v;
            this.content[pos] = v = this.content[k];
            pos += 1 - value2.bitValue(v);
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public Container iandNot(RunContainer x) {
        PeekableCharIterator it = x.getCharIterator();
        int removed = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            it.advanceIfNeeded(this.content[i]);
            if (it.peekNext() != this.content[i]) {
                this.content[i - removed] = this.content[i];
                continue;
            }
            ++removed;
        }
        this.cardinality -= removed;
        return this;
    }

    private void increaseCapacity() {
        this.increaseCapacity(false);
    }

    private void increaseCapacity(boolean allowIllegalSize) {
        int newCapacity = this.computeCapacity(this.content.length);
        if (newCapacity > 4096 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        this.content = Arrays.copyOf(this.content, newCapacity);
    }

    private int computeCapacity(int oldCapacity) {
        return oldCapacity == 0 ? 4 : (oldCapacity < 64 ? oldCapacity * 2 : (oldCapacity < 1024 ? oldCapacity * 3 / 2 : oldCapacity * 5 / 4));
    }

    private int calculateCapacity(int min) {
        int newCapacity = this.computeCapacity(this.content.length);
        if (newCapacity < min) {
            newCapacity = min;
        }
        if (newCapacity > 4096) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840) {
            newCapacity = 4096;
        }
        return newCapacity;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsignedBinarySearch(this.content, startIndex, this.cardinality, (char)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        char[] buffer = new char[newValuesInRange];
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.length) {
                if (newCardinality > 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                this.content = Arrays.copyOf(this.content, newCardinality);
            }
            System.arraycopy(this.content, lastIndex + 1, this.content, lastIndex + 1 + cardinalityChange, this.cardinality - 1 - lastIndex);
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                System.arraycopy(this.content, startIndex + newValuesInRange - cardinalityChange, this.content, startIndex + newValuesInRange, newCardinality - (startIndex + newValuesInRange));
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public boolean intersects(ArrayContainer value2) {
        ArrayContainer value1 = this;
        return Util.unsignedIntersects(value1.content, value1.getCardinality(), value2.content, value2.getCardinality());
    }

    @Override
    public boolean intersects(BitmapContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(RunContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        int pos = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)minimum);
        int index = pos >= 0 ? pos : -pos - 1;
        return index < this.cardinality && this.content[index] < supremum;
    }

    @Override
    public Container ior(ArrayContainer value2) {
        int totalCardinality = this.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            return this.toBitmapContainer().lazyIOR(value2).repairAfterLazy();
        }
        if (totalCardinality >= this.content.length) {
            int newCapacity = this.calculateCapacity(totalCardinality);
            char[] destination = new char[newCapacity];
            this.cardinality = Util.unsignedUnion2by2(this.content, 0, this.cardinality, value2.content, 0, value2.cardinality, destination);
            this.content = destination;
        } else {
            System.arraycopy(this.content, 0, this.content, value2.cardinality, this.cardinality);
            this.cardinality = Util.unsignedUnion2by2(this.content, value2.cardinality, this.cardinality, value2.content, 0, value2.cardinality, this.content);
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Container ior(RunContainer x) {
        return x.or(this);
    }

    @Override
    public Container iremove(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, indexstart, this.cardinality, (char)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        System.arraycopy(this.content, indexstart + rangelength, this.content, indexstart, this.cardinality - indexstart - rangelength);
        this.cardinality -= rangelength;
        return this;
    }

    @Override
    public Iterator<Character> iterator() {
        return new Iterator<Character>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            @Override
            public Character next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return Character.valueOf(ArrayContainer.this.content[s]);
            }

            @Override
            public void remove() {
                ArrayContainer.this.removeAtIndex(this.pos - 1);
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container ixor(RunContainer x) {
        return x.xor(this);
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality < this.getCardinality()) {
            return new ArrayContainer(maxcardinality, this.content);
        }
        return this.clone();
    }

    void loadData(BitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        Util.fillArray(bitmapContainer.bitmap, this.content);
    }

    private void negateRange(char[] buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange < lastRange && inPos <= lastIndex; ++valInRange) {
            if ((char)valInRange != this.content[inPos]) {
                buffer[outPos++] = (char)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastRange) {
            buffer[outPos++] = (char)valInRange;
            ++valInRange;
        }
        if (outPos != buffer.length) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.length);
        }
        int i = startIndex;
        for (char item : buffer) {
            this.content[i++] = item;
        }
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange >= lastOfRange) {
            return this.clone();
        }
        int startIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsignedBinarySearch(this.content, startIndex, this.cardinality, (char)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) > 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        ArrayContainer answer = new ArrayContainer(newCardinality);
        System.arraycopy(this.content, 0, answer.content, 0, startIndex);
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange < lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((char)valInRange != this.content[inPos]) {
                answer.content[outPos++] = (char)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastOfRange) {
            answer.content[outPos++] = (char)valInRange;
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content[outPos++] = this.content[i];
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    int numberOfRuns() {
        if (this.cardinality == 0) {
            return 0;
        }
        int numRuns = 1;
        char oldv = this.content[0];
        for (int i = 1; i < this.cardinality; ++i) {
            char newv = this.content[i];
            if (oldv + '\u0001' != newv) {
                ++numRuns;
            }
            oldv = newv;
        }
        return numRuns;
    }

    @Override
    public Container or(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            return this.toBitmapContainer().lazyIOR(value2).repairAfterLazy();
        }
        ArrayContainer answer = new ArrayContainer(totalCardinality);
        answer.cardinality = Util.unsignedUnion2by2(value1.content, 0, value1.getCardinality(), value2.content, 0, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    protected Container or(CharIterator it) {
        return this.or(it, false);
    }

    private Container or(CharIterator it, boolean exclusive) {
        ArrayContainer ac = new ArrayContainer();
        int myItPos = 0;
        ac.cardinality = 0;
        int myHead = myItPos == this.cardinality ? -1 : this.content[myItPos++];
        int hisHead = this.advance(it);
        while (myHead != -1 && hisHead != -1) {
            if (myHead < hisHead) {
                ac.emit((char)myHead);
                myHead = myItPos == this.cardinality ? -1 : this.content[myItPos++];
                continue;
            }
            if (myHead > hisHead) {
                ac.emit((char)hisHead);
                hisHead = this.advance(it);
                continue;
            }
            if (!exclusive) {
                ac.emit((char)hisHead);
            }
            hisHead = this.advance(it);
            myHead = myItPos == this.cardinality ? -1 : this.content[myItPos++];
        }
        while (myHead != -1) {
            ac.emit((char)myHead);
            myHead = myItPos == this.cardinality ? -1 : this.content[myItPos++];
        }
        while (hisHead != -1) {
            ac.emit((char)hisHead);
            hisHead = this.advance(it);
        }
        if (ac.cardinality > 4096) {
            return ac.toBitmapContainer();
        }
        return ac;
    }

    @Override
    public int rank(char lowbits) {
        int answer = Util.unsignedBinarySearch(this.content, 0, this.cardinality, lowbits);
        if (answer >= 0) {
            return answer + 1;
        }
        return -answer - 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    @Override
    public Container remove(int begin, int end) {
        int indexend;
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, indexstart, this.cardinality, (char)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        ArrayContainer answer = this.clone();
        System.arraycopy(this.content, indexstart + rangelength, answer.content, indexstart, this.cardinality - indexstart - rangelength);
        answer.cardinality = this.cardinality - rangelength;
        return answer;
    }

    void removeAtIndex(int loc) {
        System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
        --this.cardinality;
    }

    @Override
    public Container remove(char x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            this.removeAtIndex(loc);
        }
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        return this;
    }

    @Override
    public Container runOptimize() {
        int numRuns = this.numberOfRuns();
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(numRuns);
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public char select(int j) {
        return this.content[j];
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        out.writeShort(Character.reverseBytes((char)this.cardinality));
        for (int k = 0; k < this.cardinality; ++k) {
            out.writeShort(Character.reverseBytes(this.content[k]));
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return ArrayContainer.serializedSizeInBytes(this.cardinality);
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.loadData(this);
        return bc;
    }

    @Override
    public void copyBitmapTo(long[] dest, int position) {
        for (int k = 0; k < this.cardinality; ++k) {
            char x = this.content[k];
            int n = position + x / 64;
            dest[n] = dest[n] | 1L << x;
        }
    }

    @Override
    public int nextValue(char fromValue) {
        int index = Util.advanceUntil(this.content, -1, this.cardinality, fromValue);
        if (index == this.cardinality) {
            return fromValue == this.content[this.cardinality - 1] ? fromValue : (char)'\uffffffff';
        }
        return this.content[index];
    }

    @Override
    public int previousValue(char fromValue) {
        int index = Util.advanceUntil(this.content, -1, this.cardinality, fromValue);
        if (index != this.cardinality && this.content[index] == fromValue) {
            return this.content[index];
        }
        return index == 0 ? -1 : this.content[index - 1];
    }

    @Override
    public int nextAbsentValue(char fromValue) {
        int index = Util.advanceUntil(this.content, -1, this.cardinality, (char)fromValue);
        if (index >= this.cardinality) {
            return fromValue;
        }
        if (index == this.cardinality - 1) {
            return fromValue == this.content[this.cardinality - 1] ? fromValue + '\u0001' : fromValue;
        }
        if (this.content[index] != fromValue) {
            return fromValue;
        }
        if (this.content[index + 1] > fromValue + 1) {
            return fromValue + 1;
        }
        int low = index;
        int high = this.cardinality;
        while (low + 1 < high) {
            int mid = high + low >>> 1;
            if (mid - index < this.content[mid] - fromValue) {
                high = mid;
                continue;
            }
            low = mid;
        }
        if (low == this.cardinality - 1) {
            return this.content[this.cardinality - 1] + '\u0001';
        }
        assert (this.content[low] + '\u0001' < this.content[high]);
        assert (this.content[low] == fromValue + (low - index));
        return this.content[low] + '\u0001';
    }

    @Override
    public int previousAbsentValue(char fromValue) {
        int index = Util.advanceUntil(this.content, -1, this.cardinality, (char)fromValue);
        if (index >= this.cardinality) {
            return fromValue;
        }
        if (index == 0) {
            return fromValue == this.content[0] ? fromValue - '\u0001' : fromValue;
        }
        if (this.content[index] != fromValue) {
            return fromValue;
        }
        if (this.content[index - 1] < fromValue - 1) {
            return fromValue - 1;
        }
        int low = -1;
        int high = index;
        while (low + 1 < high) {
            int mid = high + low >>> 1;
            if (index - mid < fromValue - this.content[mid]) {
                low = mid;
                continue;
            }
            high = mid;
        }
        if (high == 0) {
            return this.content[0] - '\u0001';
        }
        assert (this.content[low] + '\u0001' < this.content[high]);
        assert (this.content[high] == fromValue - (index - high));
        return this.content[high] - '\u0001';
    }

    @Override
    public int first() {
        this.assertNonEmpty(this.cardinality == 0);
        return this.content[0];
    }

    @Override
    public int last() {
        this.assertNonEmpty(this.cardinality == 0);
        return this.content[this.cardinality - 1];
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableArrayContainer(this);
    }

    public CharBuffer toCharBuffer() {
        CharBuffer cb = CharBuffer.allocate(this.cardinality);
        cb.put(this.content, 0, this.cardinality);
        return cb;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{}".length() + "-123456789,".length() * this.cardinality);
        sb.append('{');
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append((int)this.content[i]);
            sb.append(',');
        }
        sb.append((int)this.content[this.cardinality - 1]);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.content.length == this.cardinality) {
            return;
        }
        this.content = Arrays.copyOf(this.content, this.cardinality);
    }

    @Override
    public void writeArray(DataOutput out) throws IOException {
        for (int k = 0; k < this.cardinality; ++k) {
            char v = this.content[k];
            out.writeChar(Character.reverseBytes(v));
        }
    }

    @Override
    public void writeArray(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        CharBuffer buf = buffer.asCharBuffer();
        buf.put(this.content, 0, this.cardinality);
        int bytesWritten = 2 * this.cardinality;
        buffer.position(buffer.position() + bytesWritten);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            return this.toBitmapContainer().ixor(value2);
        }
        ArrayContainer answer = new ArrayContainer(totalCardinality);
        answer.cardinality = Util.unsignedExclusiveUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    protected Container xor(CharIterator it) {
        return this.or(it, true);
    }

    @Override
    public void forEach(char msb, IntConsumer ic) {
        int high = msb << 16;
        for (int k = 0; k < this.cardinality; ++k) {
            ic.accept(this.content[k] | high);
        }
    }

    @Override
    public void forAll(int offset, RelativeRangeConsumer rrc) {
        int next = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            int value = this.content[k];
            if (next < value) {
                rrc.acceptAllAbsent(offset + next, offset + value);
            }
            rrc.acceptPresent(offset + value);
            next = value + '\u0001';
        }
        if (next <= 65535) {
            rrc.acceptAllAbsent(offset + next, offset + 65535 + 1);
        }
    }

    @Override
    public void forAllFrom(char startValue, RelativeRangeConsumer rrc) {
        int startOffset = startValue;
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)startValue);
        int startIndex = loc >= 0 ? loc : -loc - 1;
        int next = startValue;
        for (int k = startIndex; k < this.cardinality; ++k) {
            char value = this.content[k];
            if (next < value) {
                rrc.acceptAllAbsent(next - startOffset, value - startOffset);
            }
            rrc.acceptPresent(value - startOffset);
            next = value + '\u0001';
        }
        if (next <= 65535) {
            rrc.acceptAllAbsent(next - startOffset, 65536 - startOffset);
        }
    }

    @Override
    public void forAllUntil(int offset, char endValue, RelativeRangeConsumer rrc) {
        int next = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            char value = this.content[k];
            if (endValue <= value) {
                if (next < endValue) {
                    rrc.acceptAllAbsent(offset + next, offset + endValue);
                }
                return;
            }
            if (next < value) {
                rrc.acceptAllAbsent(offset + next, offset + value);
            }
            rrc.acceptPresent(offset + value);
            next = value + '\u0001';
        }
        if (next < endValue) {
            rrc.acceptAllAbsent(offset + next, offset + endValue);
        }
    }

    @Override
    public void forAllInRange(char startValue, char endValue, RelativeRangeConsumer rrc) {
        if (endValue <= startValue) {
            throw new IllegalArgumentException("startValue (" + (char)startValue + ") must be less than endValue (" + endValue + ")");
        }
        int startOffset = startValue;
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (char)startValue);
        int startIndex = loc >= 0 ? loc : -loc - 1;
        int next = startValue;
        for (int k = startIndex; k < this.cardinality; ++k) {
            char value = this.content[k];
            if (endValue <= value) {
                if (next < endValue) {
                    rrc.acceptAllAbsent(next - startOffset, endValue - startOffset);
                }
                return;
            }
            if (next < value) {
                rrc.acceptAllAbsent(next - startOffset, value - startOffset);
            }
            rrc.acceptPresent(value - startOffset);
            next = value + '\u0001';
        }
        if (next < endValue) {
            rrc.acceptAllAbsent(next - startOffset, endValue - startOffset);
        }
    }

    protected Container lazyor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 1024) {
            return this.toBitmapContainer().lazyIOR(value2);
        }
        ArrayContainer answer = new ArrayContainer(totalCardinality);
        answer.cardinality = Util.unsignedUnion2by2(value1.content, 0, value1.getCardinality(), value2.content, 0, value2.getCardinality(), answer.content);
        return answer;
    }
}

