/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;

public class FlinkNettyManagedBuffer
extends ManagedBuffer {
    private final ByteBuf buf;

    public FlinkNettyManagedBuffer(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public long size() {
        return this.buf.readableBytes();
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        return this.buf.nioBuffer();
    }

    @Override
    public InputStream createInputStream() {
        return new ByteBufInputStream(this.buf);
    }

    @Override
    public ManagedBuffer retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public ManagedBuffer release() {
        this.buf.release();
        return this;
    }

    @Override
    public Object convertToNetty() {
        return this.buf.duplicate().retain();
    }

    @Override
    public Object convertToNettyForSsl() throws IOException {
        return this.buf.duplicate().retain();
    }
}

