/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import java.util.Date;
import junit.framework.TestSuite;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.core.Customer;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestNewTag
extends BaseJellyTest {
    public TestNewTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestNewTag.class);
    }

    public void testSimpleNew() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.simpleNew", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertNull((Object)customer.getName());
    }

    public void testNewThenOverwrite() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newThenOverwrite", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Date));
    }

    public void testNewWithLiteralArg() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newWithLiteralArg", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertNotNull((Object)customer.getName());
        TestNewTag.assertEquals((String)"Jane Doe", (String)customer.getName());
    }

    public void testNewWithTwoArgs() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newWithTwoArgs", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertNotNull((Object)customer.getName());
        TestNewTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestNewTag.assertNotNull((Object)customer.getCity());
        TestNewTag.assertEquals((String)"Chicago", (String)customer.getCity());
    }

    public void testNewWithExpressionArg() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newWithExpressionArg", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertNotNull((Object)customer.getName());
        TestNewTag.assertEquals((String)"Jane Doe", (String)customer.getName());
    }

    public void testNewWithNullArg() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newWithNullArg", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertNull((Object)customer.getName());
    }

    public void testNewWithNewArg() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newWithNewArg", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertNotNull((Object)customer.getName());
        TestNewTag.assertEquals((String)"", (String)customer.getName());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("bar"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("bar") instanceof Customer));
        customer = (Customer)this.getJellyContext().getVariable("bar");
        TestNewTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestNewTag.assertEquals((String)"Chicago", (String)customer.getCity());
        TestNewTag.assertNotNull((Object)customer.getOrders());
        TestNewTag.assertEquals((int)1, (int)customer.getOrders().size());
        TestNewTag.assertNotNull(customer.getOrders().get(0));
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("qux"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("qux") instanceof Customer));
        customer = (Customer)this.getJellyContext().getVariable("qux");
        TestNewTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestNewTag.assertEquals((String)"Chicago", (String)customer.getCity());
        TestNewTag.assertNotNull((Object)customer.getOrders());
        TestNewTag.assertEquals((int)1, (int)customer.getOrders().size());
        TestNewTag.assertNotNull(customer.getOrders().get(0));
    }

    public void testNewWithUseBeanArg() throws Exception {
        this.setUpScript("testNewTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("test.newWithUseBeanArg", (Object)Boolean.TRUE);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestNewTag.assertNotNull((Object)this.getJellyContext().getVariable("foo"));
        TestNewTag.assertTrue((boolean)(this.getJellyContext().getVariable("foo") instanceof Customer));
        Customer customer = (Customer)this.getJellyContext().getVariable("foo");
        TestNewTag.assertEquals((String)"Jane Doe", (String)customer.getName());
        TestNewTag.assertEquals((String)"Chicago", (String)customer.getCity());
        TestNewTag.assertEquals((String)"Location", (String)customer.getLocation());
    }
}

