/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.validator.routines.RegexValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RegexValidatorTest {
    private static final String REGEX = "^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$";
    private static final String COMPONENT_1 = "([abc]{3})";
    private static final String COMPONENT_2 = "([DEF]{3})";
    private static final String COMPONENT_3 = "([123]{3})";
    private static final String SEPARATOR_1 = "(?:\\-)";
    private static final String SEPARATOR_2 = "(?:\\s)";
    private static final String REGEX_1 = "^([abc]{3})(?:\\-)([DEF]{3})(?:\\-)([123]{3})$";
    private static final String REGEX_2 = "^([abc]{3})(?:\\s)([DEF]{3})(?:\\s)([123]{3})$";
    private static final String REGEX_3 = "^([abc]{3})([DEF]{3})([123]{3})$";
    private static final String[] MULTIPLE_REGEX = new String[]{"^([abc]{3})(?:\\-)([DEF]{3})(?:\\-)([123]{3})$", "^([abc]{3})(?:\\s)([DEF]{3})(?:\\s)([123]{3})$", "^([abc]{3})([DEF]{3})([123]{3})$"};

    RegexValidatorTest() {
    }

    private void checkArray(String label, String[] expect, String[] result) {
        if (expect == null || result == null) {
            if (expect == null && result == null) {
                return;
            }
            Assertions.fail((String)(label + " Null expect=" + expect + " result=" + result));
            return;
        }
        if (expect.length != result.length) {
            Assertions.fail((String)(label + " Length expect=" + expect.length + " result=" + result.length));
        }
        for (int i = 0; i < expect.length; ++i) {
            Assertions.assertEquals((Object)expect[i], (Object)result[i], (String)(label + " value[" + i + "]"));
        }
    }

    @Test
    void testExceptions() {
        Assertions.assertThrows(PatternSyntaxException.class, () -> new RegexValidator("^([abCD12]*$"));
    }

    @Test
    void testGetPatterns() {
        RegexValidator regexValidator = new RegexValidator(MULTIPLE_REGEX);
        Assertions.assertNotSame((Object)regexValidator.getPatterns(), (Object)regexValidator.getPatterns());
        Pattern[] patterns = regexValidator.getPatterns();
        Assertions.assertEquals((Object)REGEX_1, (Object)patterns[0].pattern());
        Assertions.assertEquals((Object)REGEX_2, (Object)patterns[1].pattern());
        Assertions.assertEquals((Object)REGEX_3, (Object)patterns[2].pattern());
    }

    @Test
    void testMissingRegex() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new RegexValidator((String)null), (String)"Single Null");
        Assertions.assertEquals((Object)"Regular expression[0] is missing", (Object)e.getMessage(), (String)"Single Null");
        e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new RegexValidator(""), (String)"Single Zero Length");
        Assertions.assertEquals((Object)"Regular expression[0] is missing", (Object)e.getMessage(), (String)"Single Zero Length");
        e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new RegexValidator((String[])null), (String)"Null Array");
        Assertions.assertEquals((Object)"Regular expressions are missing", (Object)e.getMessage(), (String)"Null Array");
        e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new RegexValidator(new String[0]), (String)"Zero Length Array");
        Assertions.assertEquals((Object)"Regular expressions are missing", (Object)e.getMessage(), (String)"Zero Length Array");
        e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new RegexValidator(new String[]{"ABC", null}), (String)"Array has Null");
        Assertions.assertEquals((Object)"Regular expression[1] is missing", (Object)e.getMessage(), (String)"Array has Null");
        e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new RegexValidator(new String[]{"", "ABC"}), (String)"Array has Zero Length");
        Assertions.assertEquals((Object)"Regular expression[0] is missing", (Object)e.getMessage(), (String)"Array has Zero Length");
    }

    @Test
    void testMultipleInsensitive() {
        RegexValidator multiple = new RegexValidator(MULTIPLE_REGEX, false);
        RegexValidator single1 = new RegexValidator(REGEX_1, false);
        RegexValidator single2 = new RegexValidator(REGEX_2, false);
        RegexValidator single3 = new RegexValidator(REGEX_3, false);
        String value = "AAC FDE 321";
        String expect = "AACFDE321";
        String[] array = new String[]{"AAC", "FDE", "321"};
        Assertions.assertTrue((boolean)multiple.isValid(value), (String)"isValid() Multiple");
        Assertions.assertFalse((boolean)single1.isValid(value), (String)"isValid() 1st");
        Assertions.assertTrue((boolean)single2.isValid(value), (String)"isValid() 2nd");
        Assertions.assertFalse((boolean)single3.isValid(value), (String)"isValid() 3rd");
        Assertions.assertEquals((Object)"AACFDE321", (Object)multiple.validate(value), (String)"validate() Multiple");
        Assertions.assertNull((Object)single1.validate(value), (String)"validate() 1st");
        Assertions.assertEquals((Object)"AACFDE321", (Object)single2.validate(value), (String)"validate() 2nd");
        Assertions.assertNull((Object)single3.validate(value), (String)"validate() 3rd");
        this.checkArray("match() Multiple", array, multiple.match(value));
        this.checkArray("match() 1st", null, single1.match(value));
        this.checkArray("match() 2nd", array, single2.match(value));
        this.checkArray("match() 3rd", null, single3.match(value));
        value = "AAC*FDE*321";
        Assertions.assertFalse((boolean)multiple.isValid(value), (String)"isValid() Invalid");
        Assertions.assertNull((Object)multiple.validate(value), (String)"validate() Invalid");
        Assertions.assertNull((Object)multiple.match(value), (String)"match() Multiple");
    }

    @Test
    void testMultipleSensitive() {
        RegexValidator multiple = new RegexValidator(MULTIPLE_REGEX);
        RegexValidator single1 = new RegexValidator(REGEX_1);
        RegexValidator single2 = new RegexValidator(REGEX_2);
        RegexValidator single3 = new RegexValidator(REGEX_3);
        String value = "aac FDE 321";
        String expect = "aacFDE321";
        String[] array = new String[]{"aac", "FDE", "321"};
        Assertions.assertTrue((boolean)multiple.isValid(value), (String)"Sensitive isValid() Multiple");
        Assertions.assertFalse((boolean)single1.isValid(value), (String)"Sensitive isValid() 1st");
        Assertions.assertTrue((boolean)single2.isValid(value), (String)"Sensitive isValid() 2nd");
        Assertions.assertFalse((boolean)single3.isValid(value), (String)"Sensitive isValid() 3rd");
        Assertions.assertEquals((Object)"aacFDE321", (Object)multiple.validate(value), (String)"Sensitive validate() Multiple");
        Assertions.assertNull((Object)single1.validate(value), (String)"Sensitive validate() 1st");
        Assertions.assertEquals((Object)"aacFDE321", (Object)single2.validate(value), (String)"Sensitive validate() 2nd");
        Assertions.assertNull((Object)single3.validate(value), (String)"Sensitive validate() 3rd");
        this.checkArray("Sensitive match() Multiple", array, multiple.match(value));
        this.checkArray("Sensitive match() 1st", null, single1.match(value));
        this.checkArray("Sensitive match() 2nd", array, single2.match(value));
        this.checkArray("Sensitive match() 3rd", null, single3.match(value));
        value = "AAC*FDE*321";
        Assertions.assertFalse((boolean)multiple.isValid(value), (String)"isValid() Invalid");
        Assertions.assertNull((Object)multiple.validate(value), (String)"validate() Invalid");
        Assertions.assertNull((Object)multiple.match(value), (String)"match() Multiple");
    }

    @Test
    void testNullValue() {
        RegexValidator validator = new RegexValidator(REGEX);
        Assertions.assertFalse((boolean)validator.isValid(null), (String)"Instance isValid()");
        Assertions.assertNull((Object)validator.validate(null), (String)"Instance validate()");
        Assertions.assertNull((Object)validator.match(null), (String)"Instance match()");
    }

    @Test
    void testSingle() {
        RegexValidator sensitive = new RegexValidator(REGEX);
        RegexValidator insensitive = new RegexValidator(REGEX, false);
        Assertions.assertTrue((boolean)sensitive.isValid("ac-DE-1"), (String)"Sensitive isValid() valid");
        Assertions.assertFalse((boolean)sensitive.isValid("AB-de-1"), (String)"Sensitive isValid() invalid");
        Assertions.assertTrue((boolean)insensitive.isValid("AB-de-1"), (String)"Insensitive isValid() valid");
        Assertions.assertFalse((boolean)insensitive.isValid("ABd-de-1"), (String)"Insensitive isValid() invalid");
        Assertions.assertEquals((Object)"acDE1", (Object)sensitive.validate("ac-DE-1"), (String)"Sensitive validate() valid");
        Assertions.assertNull((Object)sensitive.validate("AB-de-1"), (String)"Sensitive validate() invalid");
        Assertions.assertEquals((Object)"ABde1", (Object)insensitive.validate("AB-de-1"), (String)"Insensitive validate() valid");
        Assertions.assertNull((Object)insensitive.validate("ABd-de-1"), (String)"Insensitive validate() invalid");
        this.checkArray("Sensitive match() valid", new String[]{"ac", "DE", "1"}, sensitive.match("ac-DE-1"));
        this.checkArray("Sensitive match() invalid", null, sensitive.match("AB-de-1"));
        this.checkArray("Insensitive match() valid", new String[]{"AB", "de", "1"}, insensitive.match("AB-de-1"));
        this.checkArray("Insensitive match() invalid", null, insensitive.match("ABd-de-1"));
        Assertions.assertEquals((Object)"ABC", (Object)new RegexValidator("^([A-Z]*)$").validate("ABC"), (String)"validate one");
        this.checkArray("match one", new String[]{"ABC"}, new RegexValidator("^([A-Z]*)$").match("ABC"));
    }

    @Test
    void testToString() {
        RegexValidator single = new RegexValidator(REGEX);
        Assertions.assertEquals((Object)"RegexValidator{^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$}", (Object)single.toString(), (String)"Single");
        RegexValidator multiple = new RegexValidator(new String[]{REGEX, REGEX});
        Assertions.assertEquals((Object)"RegexValidator{^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$,^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$}", (Object)multiple.toString(), (String)"Multiple");
    }
}

