/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.commandline;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.commandline.Arg;
import org.apache.rat.utils.DefaultLog;

public class ArgumentContext {
    private final ReportConfiguration configuration;
    private final CommandLine commandLine;

    public ArgumentContext(ReportConfiguration configuration, CommandLine commandLine) {
        this.commandLine = commandLine;
        this.configuration = configuration;
    }

    public void processArgs() {
        Arg.processArgs(this);
    }

    public ReportConfiguration getConfiguration() {
        return this.configuration;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void logParseException(ParseException exception, Option opt, Object defaultValue) {
        DefaultLog.getInstance().warn(String.format("Invalid %s specified: %s ", opt, this.commandLine.getOptionValue(opt)));
        DefaultLog.getInstance().warn(String.format("%s set to: %s", opt, defaultValue));
        DefaultLog.getInstance().debug(exception);
    }
}

