/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.FileProcessor;
import org.apache.rat.config.exclusion.fileProcessors.BazaarIgnoreProcessor;
import org.apache.rat.config.exclusion.fileProcessors.CVSFileProcessor;
import org.apache.rat.config.exclusion.fileProcessors.GitFileProcessor;
import org.apache.rat.config.exclusion.fileProcessors.HgIgnoreProcessor;
import org.apache.rat.document.DocumentNameMatcherSupplier;
import org.apache.rat.document.TraceableDocumentNameMatcher;
import org.apache.rat.utils.ExtendedIterator;

public enum StandardCollection {
    ALL("All of the Standard Excludes combined.", null, null, null),
    ARCH("The files and directories created by an ARCH source code control based tool.", Collections.singletonList("**/.arch-ids/**"), null, null),
    BAZAAR("The files and directories created by a Bazaar source code control based tool.", Arrays.asList("**/.bzr/**", ".bzrignore"), null, new BazaarIgnoreProcessor()),
    BITKEEPER("The files and directories created by a Bitkeeper source code control based tool.", Arrays.asList("**/BitKeeper/**", "**/ChangeSet/**"), null, null),
    CVS("The files and directories created by a CVS source code control based tool.", Arrays.asList("**/.cvsignore", "**/RCS/**", "**/SCCS/**", "**/CVS/**", "**/CVS.adm/**", "**/RCSLOG/**", "**/cvslog.*", "**/tags/**", "**/TAGS/**", "**/.make.state", "**/.nse_depinfo", "**/*~", "**/#*", "**/.#*", "**/,*", "**/_$*", "**/*$", "**/*.old", "**/*.bak", "**/*.BAK", "**/*.orig", "**/*.rej", "**/.del-*", "**/*.a", "**/*.old", "**/*.o", "**/*.obj", "**/*.so", "**/*.exe", "**/*.Z", "**/*.elc", "**/*.ln", "**/core"), null, new CVSFileProcessor()),
    DARCS("The files and directories created by a DARCS source code control based tool.", Arrays.asList("**/_darcs/**", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"), null, null),
    ECLIPSE("The files and directories created by an Eclipse IDE based tool.", Arrays.asList(".checkstyle", ".classpath", ".factorypath", ".project", ".settings/**"), null, null),
    GIT("The files and directories created by GIT source code control to support GIT, also processes files listed in '.gitignore'.", Arrays.asList("**/.git/**", "**/.gitignore"), null, new GitFileProcessor()),
    HIDDEN_DIR("The hidden directories. Directories with names that start with '.'", null, str -> TraceableDocumentNameMatcher.make(() -> "HIDDEN_DIR", documentName -> {
        File f = new File(documentName.getName());
        return f.isDirectory() && ExclusionUtils.isHidden(f);
    }), null),
    HIDDEN_FILE("The hidden files. Directories with names that start with '.'", null, str -> TraceableDocumentNameMatcher.make(() -> "HIDDEN_FILE", documentName -> {
        File f = new File(documentName.getName());
        return f.isFile() && ExclusionUtils.isHidden(f);
    }), null),
    IDEA("The files and directories created by an IDEA IDE based tool.", Arrays.asList("*.iml", "*.ipr", "*.iws", ".idea/**"), null, null),
    MAC("The .DS_Store files MAC computer.", Collections.singletonList("**/.DS_Store"), null, null),
    MAVEN("The files and directories created by Maven build system based project.", Arrays.asList("target/**", "cobertura.ser", "**/MANIFEST.MF", "release.properties", ".repository", "build.log", ".mvn/**", "pom.xml.releaseBackup"), null, null),
    MERCURIAL("The files and directories created by a Mercurial source code control based tool.", Arrays.asList("**/.hg/**", ".hgignore"), null, new HgIgnoreProcessor()),
    MISC("The set of miscellaneous files generally left by editors and the like.", Arrays.asList("**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*"), null, null),
    MKS("The files and directories created by an MKS source code control based tool.", Collections.singletonList("**/project.pj"), null, null),
    RCS("The files and directories created by a RCS source code control based tool.", Collections.singletonList("**/RCS/**"), null, null),
    SCCS("The files and directories created by a SCCS source code control based tool.", Collections.singletonList("**/SCCS/**"), null, null),
    SERENA_DIMENSIONS_10("The files and directories created by a Serena Dimensions V10 change control system based tool.", Collections.singletonList("**/.metadata/**"), null, null),
    STANDARD_PATTERNS("A standard collection of generally accepted patterns to ignore.", null, null, null),
    STANDARD_SCMS("A standard collection of SCMs", null, null, null),
    SUBVERSION("The files and directories created by a Subversion source code control based tool.", Collections.singletonList("**/.svn/**"), null, null),
    SURROUND_SCM("The files and directories created by a Surround SCM source code control based tool.", Collections.singletonList("**/.MySCMServerInfo"), null, null),
    VSS("The files and directories created by a Visual Source Safe source code control based tool.", Collections.singletonList("**/vssver.scc"), null, null);

    private final Collection<String> patterns;
    private final DocumentNameMatcherSupplier documentNameMatcherSupplier;
    private final FileProcessor fileProcessor;
    private final String desc;

    private StandardCollection(String desc, Collection<String> patterns, DocumentNameMatcherSupplier matcherSupplier, FileProcessor fileProcessor) {
        this.desc = desc;
        this.patterns = patterns == null ? Collections.emptyList() : new HashSet<String>(patterns);
        this.documentNameMatcherSupplier = matcherSupplier;
        this.fileProcessor = fileProcessor;
    }

    public String desc() {
        return this.desc;
    }

    private Set<StandardCollection> getCollections() {
        HashSet<StandardCollection> result = new HashSet<StandardCollection>();
        switch (this) {
            case ALL: {
                for (StandardCollection sc : StandardCollection.values()) {
                    if (sc == ALL) continue;
                    result.add(sc);
                }
                break;
            }
            case STANDARD_PATTERNS: {
                result.addAll(Arrays.asList(MISC, CVS, RCS, SCCS, VSS, MKS, SUBVERSION, ARCH, BAZAAR, SURROUND_SCM, MAC, SERENA_DIMENSIONS_10, MERCURIAL, GIT, BITKEEPER, DARCS));
                break;
            }
            case STANDARD_SCMS: {
                result.addAll(Arrays.asList(SUBVERSION, GIT, BAZAAR, MERCURIAL, CVS));
                break;
            }
            default: {
                result.add(this);
            }
        }
        return result;
    }

    public Collection<String> patterns() {
        HashSet<String> result = new HashSet<String>();
        this.getCollections().forEach(sc -> result.addAll(sc.patterns));
        return result;
    }

    public ExtendedIterator<FileProcessor> fileProcessor() {
        ArrayList<FileProcessor> lst = new ArrayList<FileProcessor>();
        for (StandardCollection sc : this.getCollections()) {
            if (sc.fileProcessor == null) continue;
            lst.add(sc.fileProcessor);
        }
        return ExtendedIterator.create(lst.iterator());
    }

    public DocumentNameMatcherSupplier documentNameMatcherSupplier() {
        ArrayList<DocumentNameMatcherSupplier> lst = new ArrayList<DocumentNameMatcherSupplier>();
        for (StandardCollection sc : this.getCollections()) {
            if (sc.documentNameMatcherSupplier == null) continue;
            lst.add(sc.documentNameMatcherSupplier);
        }
        if (lst.isEmpty()) {
            return null;
        }
        if (lst.size() == 1) {
            return (DocumentNameMatcherSupplier)lst.get(0);
        }
        Supplier<String> nameSupplier = () -> String.join((CharSequence)", ", ExtendedIterator.create(this.getCollections().iterator()).map(Enum::name).addTo(new ArrayList()));
        return dirName -> TraceableDocumentNameMatcher.make(nameSupplier, documentName -> {
            for (DocumentNameMatcherSupplier supplier : lst) {
                if (!supplier.get(dirName).matches(documentName)) continue;
                return true;
            }
            return false;
        });
    }

    public boolean hasDocumentNameMatchSupplier() {
        for (StandardCollection sc : this.getCollections()) {
            if (sc.documentNameMatcherSupplier == null) continue;
            return true;
        }
        return false;
    }
}

