/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.text.WordUtils;
import org.apache.rat.commandline.Arg;
import org.apache.rat.tools.AbstractOption;
import org.apache.rat.tools.MavenGenerator;

public class MavenOption
extends AbstractOption {
    private static final Map<Arg, String> DEFAULT_VALUES = new HashMap<Arg, String>();

    MavenOption(Option option) {
        super(option, MavenGenerator.createName(option));
    }

    @Override
    protected String cleanupName(Option option) {
        return String.format("<%s>", MavenGenerator.createName(option));
    }

    @Override
    public String getDefaultValue() {
        Arg arg = Arg.findArg(this.option);
        String result = DEFAULT_VALUES.get((Object)arg);
        if (result == null) {
            result = arg.defaultValue();
        }
        return result;
    }

    public String getPropertyAnnotation(String fname) {
        String defaultValue;
        StringBuilder sb = new StringBuilder("@Parameter");
        String property = this.option.hasArgs() ? null : String.format("property = \"rat.%s\"", fname);
        String string = defaultValue = this.option.isDeprecated() ? null : this.getDefaultValue();
        if (property != null || defaultValue != null) {
            sb.append("(");
            if (property != null) {
                sb.append(property).append(defaultValue != null ? ", " : "");
            }
            if (defaultValue != null) {
                sb.append(String.format("defaultValue = \"%s\"", defaultValue));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getMethodSignature(String indent, boolean multiple) {
        String args;
        StringBuilder sb = new StringBuilder();
        if (this.isDeprecated()) {
            sb.append(String.format("%s@Deprecated%n", indent));
        }
        String fname = WordUtils.capitalize(this.name);
        String string = args = this.option.hasArg() ? "String" : "boolean";
        if (multiple) {
            if (!(fname.endsWith("s") || fname.endsWith("Approved") || fname.endsWith("Denied"))) {
                fname = fname + "s";
            }
            args = args + "[]";
        }
        return sb.append(String.format("%1$s%5$s%n%1$spublic void set%3$s(%4$s %2$s)", indent, this.name, fname, args, this.getPropertyAnnotation(fname))).toString();
    }

    static {
        DEFAULT_VALUES.put(Arg.OUTPUT_FILE, "${project.build.directory}/rat.txt");
    }
}

