/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdateStatisticsTest
extends BaseJDBCTestCase {
    public UpdateStatisticsTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(UpdateStatisticsTest.class);
        Test statsDisabled = DatabasePropertyTestSetup.singleProperty(test, "derby.storage.indexStats.auto", "false", true);
        return statsDisabled;
    }

    public void testIndexAndColumnNamedStatistics() throws SQLException {
        String tbl = "T1";
        IndexStatsUtil stats = new IndexStatsUtil(this.openDefaultConnection());
        Statement s = this.createStatement();
        int initialStatsCount = stats.getStats().length;
        s.executeUpdate("CREATE TABLE t1 (c11 int, statistics int not null)");
        s.executeUpdate("CREATE INDEX statistIcs ON t1(c11)");
        s.executeUpdate("INSERT INTO t1 VALUES(1,1)");
        stats.assertNoStatsTable(tbl);
        s.executeUpdate("ALTER TABLE t1 DROP statistics");
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','STATISTICS')");
        stats.assertTableStats(tbl, 1);
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','STATISTICS')");
        stats.assertNoStatsTable(tbl);
        s.executeUpdate("ALTER TABLE t1 ADD COLUMN statistics int");
        stats.assertNoStatsTable(tbl);
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','STATISTICS')");
        stats.assertNoStatsTable(tbl);
        s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','STATISTICS')");
        stats.assertTableStats(tbl, 1);
        s.executeUpdate("DROP TABLE t1");
        UpdateStatisticsTest.assertEquals((int)initialStatsCount, (int)stats.getStats().length);
    }

    public void testStatisticsProcsWithEmptyParamsDerby5750() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table DERBY5750_t1 (c11 int)");
        s.executeUpdate("CREATE INDEX DERBY5750_I1 ON DERBY5750_t1(c11)");
        UpdateStatisticsTest.assertStatementError("42Y07", s, "call syscs_util.SYSCS_UPDATE_STATISTICS('','DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42Y07", s, "call syscs_util.SYSCS_DROP_STATISTICS('','DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42Y07", s, "call syscs_util.SYSCS_UPDATE_STATISTICS('','','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42Y07", s, "call syscs_util.SYSCS_DROP_STATISTICS('','','DERBY5750_I1')");
        s.execute("call syscs_util.SYSCS_UPDATE_STATISTICS(null,'DERBY5750_T1','DERBY5750_I1')");
        s.execute("call syscs_util.SYSCS_DROP_STATISTICS(null,'DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_UPDATE_STATISTICS(null,'','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_DROP_STATISTICS(null,'','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_UPDATE_STATISTICS('APP','','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_DROP_STATISTICS('APP','','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_UPDATE_STATISTICS(null,null,'DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_DROP_STATISTICS(null,null,'DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_UPDATE_STATISTICS('APP',null,'DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", s, "call syscs_util.SYSCS_DROP_STATISTICS('APP',null,'DERBY5750_I1')");
        s.execute("call syscs_util.SYSCS_UPDATE_STATISTICS('APP','DERBY5750_T1','DERBY5750_I1')");
        s.execute("call syscs_util.SYSCS_DROP_STATISTICS('APP','DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X65", s, "call syscs_util.SYSCS_UPDATE_STATISTICS('APP','DERBY5750_T1','')");
        UpdateStatisticsTest.assertStatementError("42X65", s, "call syscs_util.SYSCS_DROP_STATISTICS('APP','DERBY5750_T1','')");
        s.execute("drop table DERBY5750_t1");
    }

    public void testUpdateAndDropStatistics() throws SQLException {
        String tbl1 = "T1";
        IndexStatsUtil stats = new IndexStatsUtil(this.openDefaultConnection());
        Statement s = this.createStatement();
        this.dropTable("T1");
        UpdateStatisticsTest.assertStatementError("42Y55", s, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1',null)");
        UpdateStatisticsTest.assertStatementError("42Y55", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        s.executeUpdate("CREATE TABLE t1 (c11 int, c12 varchar(128))");
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1',null)");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        UpdateStatisticsTest.assertStatementError("42X65", s, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I1')");
        UpdateStatisticsTest.assertStatementError("42X65", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        s.executeUpdate("CREATE INDEX i1 on t1(c12)");
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I1')");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        stats.assertNoStatsTable(tbl1);
        s.executeUpdate("INSERT INTO T1 VALUES(1,'a'),(2,'b'),(3,'c'),(4,'d')");
        s.executeUpdate("CREATE INDEX i2 ON t1(c11)");
        stats.assertTableStats(tbl1, 1);
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I2')");
        stats.assertNoStatsTable(tbl1);
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I2')");
        stats.assertTableStats(tbl1, 1);
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        stats.assertTableStats(tbl1, 2);
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I1')");
        stats.assertTableStats(tbl1, 1);
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        stats.assertTableStats(tbl1, 2);
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1',null)");
        stats.assertNoStatsTable(tbl1);
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        stats.assertTableStats(tbl1, 2);
        s.executeUpdate("DROP INDEX I1");
        stats.assertTableStats(tbl1, 1);
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 ALL UPDATE STATISTICS");
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 UPDATE STATISTICS I1");
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 ALL DROP STATISTICS");
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 STATISTICS DROP I1");
        s.executeUpdate("DROP TABLE t1");
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        s.executeUpdate("insert into session.t1 values(11, 1)");
        UpdateStatisticsTest.assertStatementError("42995", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('SESSION','T1',null)");
        UpdateStatisticsTest.assertStatementError("42995", s, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('SESSION','T1',null)");
        s.executeUpdate("CREATE TABLE t2(c21 int, c22 char(14), c23 char(200))");
        s.executeUpdate("CREATE INDEX t2i1 ON t2(c21)");
        s.executeUpdate("CREATE INDEX t2i2 ON t2(c22)");
        stats.assertNoStatsTable("T2");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T2 VALUES(?,?,?)");
        for (int i = 0; i < 1000; ++i) {
            ps.setInt(1, i % 2);
            ps.setString(2, "Tuple " + i);
            ps.setString(3, "any value");
            ps.addBatch();
        }
        ps.executeBatch();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ps = this.prepareStatement("SELECT * FROM t2 WHERE c21=? AND c22=?");
        ps.setInt(1, 0);
        ps.setString(2, "Tuple 4");
        JDBC.assertDrainResults(ps.executeQuery());
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I1"));
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2','T2I2')");
        stats.assertIndexStats("T2I2", 1);
        JDBC.assertDrainResults(ps.executeQuery());
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I2"));
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T2','T2I2')");
        stats.assertIndexStats("T2I2", 0);
        JDBC.assertDrainResults(ps.executeQuery());
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I1"));
        s.executeUpdate("DROP TABLE t2");
        stats.release();
    }

    public void testNoExclusiveLockOnTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t (x char(1))");
        s.execute("create index ti on t(x)");
        s.execute("insert into t values 'a','b','c','d'");
        this.setAutoCommit(false);
        s.execute("lock table t in share mode");
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        s2.execute("call syscs_util.syscs_update_statistics('APP', 'T', null)");
        s2.close();
        c2.close();
        s.execute("drop table t");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelCompilationAndUpdate() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table derby5153(a int, b int, c int, d int)");
        s.execute("create index idx on derby5153(a,b,c,d)");
        PreparedStatement ins = this.prepareStatement("insert into derby5153 values (1,2,3,4)");
        for (int i = 0; i < 100; ++i) {
            ins.execute();
        }
        this.commit();
        Connection updateConn = this.openDefaultConnection();
        IndexUpdateThread t = new IndexUpdateThread(updateConn, "APP", "DERBY5153", "IDX");
        t.start();
        try {
            for (int i = 0; i < 100; ++i) {
                ResultSet rs = s.executeQuery("select * from derby5153 t1, derby5153 t2 where t1.a = t2.a");
                rs.close();
            }
        }
        finally {
            t.done = true;
        }
        t.join();
        if (t.exception != null) {
            throw t.exception;
        }
        updateConn.close();
        this.dropTable("derby5153");
        this.commit();
    }

    public void testDERBY5681() throws Exception {
        IndexStatsUtil stats = new IndexStatsUtil(this.openDefaultConnection());
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE TEST_TAB_1 (c11 int not null,c12 int not null, c13 int)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("INSERT INTO TEST_TAB_1 VALUES(1,1,1),(2,2,2)");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_1', null)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_1', null)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_UNQ_1 UNIQUE (c12)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_UNQ_1");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("CREATE INDEX TEST_TAB_1_NUNQ_1 ON TEST_TAB_1(c12)");
        stats.assertTableStats("TEST_TAB_1", 1);
        s.executeUpdate("DROP INDEX TEST_TAB_1_NUNQ_1");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_UNQ_2 UNIQUE (c12, c13)");
        stats.assertTableStats("TEST_TAB_1", 2);
        s.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_UNQ_2");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("CREATE TABLE TEST_TAB_3 (c31 int not null)");
        s.executeUpdate("INSERT INTO TEST_TAB_3 VALUES(1),(2)");
        s.executeUpdate("ALTER TABLE TEST_TAB_3 ADD CONSTRAINT TEST_TAB_3_FK_1 FOREIGN KEY(c31) REFERENCES TEST_TAB_1(c11)");
        stats.assertTableStats("TEST_TAB_3", 1);
        s.executeUpdate("ALTER TABLE TEST_TAB_3 DROP CONSTRAINT TEST_TAB_3_FK_1");
        stats.assertNoStatsTable("TEST_TAB_3");
        s.executeUpdate("CREATE TABLE TEST_TAB_2 (c21 int not null)");
        s.executeUpdate("INSERT INTO TEST_TAB_2 VALUES(1),(2)");
        s.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_PK_1 PRIMARY KEY (c21)");
        stats.assertNoStatsTable("TEST_TAB_2");
        s.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_FK_1 FOREIGN KEY(c21) REFERENCES TEST_TAB_1(c11)");
        stats.assertNoStatsTable("TEST_TAB_2");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
        stats.assertTableStats("TEST_TAB_2", 1);
        stats.assertNoStatsTable("TEST_TAB_1");
        s.executeUpdate("ALTER TABLE TEST_TAB_2 DROP CONSTRAINT TEST_TAB_2_FK_1");
        stats.assertNoStatsTable("TEST_TAB_2");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
        stats.assertNoStatsTable("TEST_TAB_2");
        s.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
        stats.assertNoStatsTable("TEST_TAB_2");
        s.execute("drop table TEST_TAB_2");
        s.execute("drop table TEST_TAB_1");
        stats.release();
    }

    public void testDisposableStatsEagerness() throws SQLException {
        int i;
        this.setAutoCommit(false);
        String tbl = "DISPOSABLE_STATS_EAGERNESS";
        String tbl_fk = tbl + "_FK";
        String nuIdx = "NU_" + tbl;
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table " + tbl_fk + "(pk1 int generated always as identity)");
        PreparedStatement ps = this.prepareStatement("insert into " + tbl_fk + " values (DEFAULT)");
        for (i = 1; i <= 1000; ++i) {
            ps.executeUpdate();
        }
        stmt.executeUpdate("create table " + tbl + "(pk1 int generated always as identity,pk2 int not null,mynonunique int, fk int not null)");
        ps = this.prepareStatement("insert into " + tbl + " values (DEFAULT, ?, ?, ?)");
        for (i = 1; i <= 1000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i % 35);
            ps.setInt(3, i);
            ps.executeUpdate();
        }
        stmt.executeUpdate("alter table " + tbl_fk + " add constraint PK_" + tbl_fk + " primary key (pk1)");
        stmt.executeUpdate("alter table " + tbl + " add constraint PK_" + tbl + " primary key (pk1, pk2)");
        stmt.executeUpdate("alter table " + tbl + " add constraint FK_" + tbl + " foreign key (fk) references " + tbl_fk + "(pk1)");
        stmt.executeUpdate("create index " + nuIdx + " on " + tbl + "(mynonunique)");
        this.commit();
        this.setAutoCommit(true);
        IndexStatsUtil stats = new IndexStatsUtil(this.getConnection());
        stats.assertNoStatsTable(tbl_fk);
        stats.assertTableStats(tbl, 4);
        IndexStatsUtil.IdxStats[] tbl_stats_0 = stats.getStatsTable(tbl);
        UpdateStatisticsTest.sleepAtLeastOneTick();
        ps = this.prepareStatement("call syscs_util.syscs_update_statistics('APP', ?, ?)");
        ps.setNull(2, 12);
        ps.setString(1, tbl);
        ps.execute();
        ps.setString(1, tbl_fk);
        ps.execute();
        stats.assertNoStatsTable(tbl_fk);
        stats.assertTableStats(tbl, 4);
        IndexStatsUtil.IdxStats[] tbl_stats_1 = stats.getStatsTable(tbl);
        UpdateStatisticsTest.assertEquals((int)tbl_stats_0.length, (int)tbl_stats_1.length);
        for (int i2 = 0; i2 < tbl_stats_1.length; ++i2) {
            UpdateStatisticsTest.assertTrue((boolean)tbl_stats_1[i2].after(tbl_stats_0[i2]));
        }
        UpdateStatisticsTest.sleepAtLeastOneTick();
        ps.setString(1, tbl);
        ps.setString(2, nuIdx);
        ps.execute();
        IndexStatsUtil.IdxStats nonUniqueIdx = stats.getStatsIndex(nuIdx)[0];
        UpdateStatisticsTest.assertTrue((boolean)nonUniqueIdx.after(tbl_stats_1[0]));
        stats.assertNoStatsTable(tbl_fk);
        stats.assertTableStats(tbl, 4);
        this.dropTable(tbl);
        this.dropTable(tbl_fk);
    }

    private static class IndexUpdateThread
    extends Thread {
        private final CallableStatement updateStats;
        private volatile boolean done;
        private Exception exception;

        private IndexUpdateThread(Connection c, String schema, String table, String index) throws SQLException {
            this.updateStats = c.prepareCall("call syscs_util.syscs_update_statistics(?,?,?)");
            this.updateStats.setString(1, schema);
            this.updateStats.setString(2, table);
            this.updateStats.setString(3, index);
        }

        @Override
        public void run() {
            try {
                while (!this.done) {
                    this.updateStats.execute();
                }
                this.updateStats.close();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

