/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.sysinfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.sysinfo.ZipInfoProperties;

public final class Main {
    private static final String MESSAGE_FILE = "org.apache.derby.loc.sysinfoMessages";
    private static final LocalizedResource LOCALIZED_RESOURCE = new LocalizedResource("org.apache.derby.loc.sysinfoMessages");
    private static boolean setPause = false;
    private static boolean setLicense = false;
    private static boolean cptester = false;
    private static final String sep = "------------------------------------------------------";
    private static final String javaSep = Main.getTextMessage("SIF01.L", new Object[0]);
    private static final String jbmsSep = Main.getTextMessage("SIF01.M", new Object[0]);
    private static final String licSep = Main.getTextMessage("SIF01.N", new Object[0]);
    private static final String locSep = Main.getTextMessage("SIF01.P", new Object[0]);
    private static final String curLoc = Main.getTextMessage("SIF01.T", new Object[0]);
    private static final String EMBEDDED = "embedded";
    private static final String TOOLS = "tools";
    private static final String NET = "server";
    private static final String CLIENT = "client";
    private static final String MAINUSAGESTRING = "java org.apache.derby.tools.sysinfo -cp";
    private static final String USAGESTRINGPARTA = "java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [";
    private static final String USAGESTRINGPARTB = ".class ] ]";
    private static final String[] infoNames = new String[]{"org/apache/derby/info/DBMS.properties", "org/apache/derby/info/tools.properties", "org/apache/derby/info/net.properties", "org/apache/derby/info/dnc.properties", "org/apache/derby/optional/optionaltools.properties"};
    private static final String[] jarNames = new String[]{"derby.jar", "derbyclient.jar", "derbynet.jar", "derbyoptionaltools.jar", "derbyrun.jar", "derbyshared.jar", "derbyTesting.jar", "derbytools.jar", "derbyLocale_cs.jar", "derbyLocale_de_DE.jar", "derbyLocale_es.jar", "derbyLocale_ja_JP.jar", "derbyLocale_ko_KR.jar", "derbyLocale_pl.jar", "derbyLocale_pt_BR.jar", "derbyLocale_ru.jar", "derbyLocale_fr.jar", "derbyLocale_zh_CN.jar", "derbyLocale_hu.jar", "derbyLocale_zh_TW.jar", "derbyLocale_it.jar"};

    public static void main(String[] args) {
        LocalizedResource.getInstance().init();
        LocalizedOutput out = LocalizedResource.OutputWriter();
        Main.parseArgs(args);
        if (cptester) {
            Main.getClasspathInfo(args, out);
        } else {
            Main.getMainInfo(out, setPause);
        }
    }

    public static void getMainInfo(PrintWriter aw, boolean pause) {
        aw.println(javaSep);
        Main.reportJavaInfo(aw);
        aw.println(jbmsSep);
        Main.reportDerby(aw);
        aw.println(sep);
        try {
            Main.reportLocales(aw);
        }
        catch (Exception e) {
            aw.println(Main.getTextMessage("SIF01.Q", new Object[0]));
            aw.println(Main.getTextMessage("SIF01.B", new Object[0]));
        }
        try {
            Main.reportTesting(aw);
        }
        catch (Exception e) {
            aw.println("Exception in reporting version of derbyTesting.jar");
            e.printStackTrace();
        }
        if (pause) {
            Main.pause();
        }
    }

    private static void parseArgs(String[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-pause")) {
                setPause = true;
            }
            if (!args[i].equals("-cp")) continue;
            cptester = true;
        }
    }

    private static void pause() {
        try {
            System.out.print(Main.getTextMessage("SIF01.C", new Object[0]));
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            br.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void reportDerby(PrintWriter localAW) {
        String classpath = null;
        try {
            classpath = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.class.path");
                }
            });
        }
        catch (SecurityException se) {
            localAW.println(Main.getTextMessage("SIF01.U", se.getMessage()));
            classpath = null;
        }
        ZipInfoProperties[] zip = Main.getAllInfo(classpath);
        if (zip != null) {
            for (int i = 0; i < zip.length; ++i) {
                String thisInfo = "[" + zip[i].getLocation() + "] " + zip[i].getVersionBuildInfo();
                localAW.println(thisInfo);
            }
        } else {
            localAW.println(Main.getTextMessage("SIF01.D", new Object[0]));
        }
    }

    private static void reportJavaInfo(PrintWriter localAW) {
        localAW.println(Main.getTextMessage("SIF02.A", Main.getJavaProperty("java.version")));
        localAW.println(Main.getTextMessage("SIF02.B", Main.getJavaProperty("java.vendor")));
        localAW.println(Main.getTextMessage("SIF02.C", Main.getJavaProperty("java.home")));
        localAW.println(Main.getTextMessage("SIF02.D", Main.getJavaProperty("java.class.path")));
        localAW.println(Main.getTextMessage("SIF02.E", Main.getJavaProperty("os.name")));
        localAW.println(Main.getTextMessage("SIF02.F", Main.getJavaProperty("os.arch")));
        localAW.println(Main.getTextMessage("SIF02.G", Main.getJavaProperty("os.version")));
        localAW.println(Main.getTextMessage("SIF02.H", Main.getJavaProperty("user.name")));
        localAW.println(Main.getTextMessage("SIF02.I", Main.getJavaProperty("user.home")));
        localAW.println(Main.getTextMessage("SIF02.J", Main.getJavaProperty("user.dir")));
        localAW.println("java.specification.name: " + Main.getJavaProperty("java.specification.name"));
        localAW.println("java.specification.version: " + Main.getJavaProperty("java.specification.version"));
        Main.printPropertyIfNotNull(localAW, "java.runtime.version");
        Main.printPropertyIfNotNull(localAW, "java.fullversion");
    }

    private static void printPropertyIfNotNull(PrintWriter localAW, String property) {
        String propertyValue = Main.getJavaProperty(property, true);
        if (propertyValue != null) {
            localAW.println(property + ": " + propertyValue);
        }
    }

    private static String getJavaProperty(String whichProperty) {
        return Main.getJavaProperty(whichProperty, false);
    }

    private static String getJavaProperty(final String whichProperty, boolean nullUnavailable) {
        final String unavailable = nullUnavailable ? null : Main.getTextMessage("SIF01.H", new Object[0]);
        try {
            String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(whichProperty, unavailable);
                }
            });
            return property;
        }
        catch (SecurityException se) {
            return Main.getTextMessage("SIF01.I", se);
        }
    }

    private static String getCanonicalPath(final File f) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return f.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        catch (SecurityException se) {
            return Main.getTextMessage("SIF01.I", se);
        }
    }

    private static void getClasspathInfo(String[] args, PrintWriter aw) {
        Main.useMe(args, aw);
    }

    private static void reportLocales(PrintWriter localAW) {
        boolean cur_loc = true;
        localAW.println(locSep);
        Locale[] supportedLocales = Locale.getAvailableLocales();
        Object[] stringLocales = new String[supportedLocales.length];
        for (int i = 0; i < supportedLocales.length; ++i) {
            stringLocales[i] = supportedLocales[i].toString();
        }
        Arrays.sort(stringLocales);
        Properties p = new Properties();
        for (int i = 0; i < stringLocales.length; ++i) {
            String localeResource = "/org/apache/derby/info/locale_" + (String)stringLocales[i] + ".properties";
            final Properties finalp = p;
            final String finalLocaleResource = localeResource;
            try {
                InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        InputStream locis = finalp.getClass().getResourceAsStream(finalLocaleResource);
                        return locis;
                    }
                });
                if (is == null) continue;
                try {
                    p.clear();
                    p.load(is);
                    if (cur_loc) {
                        Locale loc = null;
                        loc = Locale.getDefault();
                        localAW.println(Main.getTextMessage("SIF01.T", new Object[0]) + "  [" + loc.getDisplayLanguage() + "/" + loc.getDisplayCountry() + " [" + loc + "]]");
                        cur_loc = false;
                    }
                    String localeName = p.getProperty("derby.locale.external.name");
                    localeName = localeName.substring(localeName.indexOf("[") + 1);
                    localeName = localeName.substring(0, localeName.indexOf("]"));
                    localAW.println(Main.getTextMessage("SIF01.R", localeName));
                    int major = Integer.parseInt(p.getProperty("derby.locale.version.major"));
                    int minor = Integer.parseInt(p.getProperty("derby.locale.version.minor"));
                    int maint = Integer.parseInt(p.getProperty("derby.locale.version.maint"));
                    String build = p.getProperty("derby.locale.build.number");
                    String lv = ProductVersionHolder.fullVersionString(major, minor, maint, false, build);
                    localAW.println(Main.getTextMessage("SIF01.S", lv));
                }
                catch (IOException ioe) {
                    localAW.println("Could not get locale properties from : " + is);
                }
                continue;
            }
            catch (Throwable t) {
                localAW.println("Could not load resource: " + localeResource);
                localAW.println("Exception: " + t);
            }
        }
        localAW.println(sep);
    }

    private static void reportTesting(PrintWriter localAW) {
        String hdr = "org.apache.derbyTesting.*:";
        Properties p = new Properties();
        String tstingResource = "/org/apache/derby/info/tsting.properties";
        final Properties finalp = p;
        final String finalTstingResource = tstingResource;
        try {
            InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    InputStream is = finalp.getClass().getResourceAsStream(finalTstingResource);
                    return is;
                }
            });
            if (is != null) {
                try {
                    p.clear();
                    p.load(is);
                    StringBuffer successes = new StringBuffer(Main.getTextMessage(Main.crLf(), new Object[0]));
                    StringBuffer failures = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf());
                    Main.tryTstingClasspath(successes, failures);
                    String successString = successes.toString();
                    if (successString.isEmpty() || successString.length() <= 2) {
                        return;
                    }
                    localAW.println(hdr);
                    localAW.print("\t ");
                    localAW.print("[");
                    localAW.print(Main.formatURL(new URL(successString)));
                    localAW.println("]");
                    int major = Integer.parseInt(p.getProperty("derby.tsting.version.major"));
                    int minor = Integer.parseInt(p.getProperty("derby.tsting.version.minor"));
                    int maint = Integer.parseInt(p.getProperty("derby.tsting.version.maint"));
                    String build = p.getProperty("derby.tsting.build.number");
                    String lv = ProductVersionHolder.fullVersionString(major, minor, maint, false, build);
                    localAW.println(Main.getTextMessage("SIF01.S", lv));
                }
                catch (IOException ioe) {
                    localAW.println("Could not get testing properties from : " + is);
                }
            }
            localAW.println(sep);
        }
        catch (Throwable t) {
            localAW.println("Could not load resource: " + tstingResource);
            localAW.println("Exception: " + t);
        }
    }

    static void useMe(String[] args, PrintWriter pw) {
        int length;
        PrintWriter localPW = pw;
        if (localPW == null) {
            localPW = new PrintWriter(System.out);
        }
        if ((length = args.length) == 1) {
            try {
                Main.tryAllClasspaths(localPW);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                Main.trySomeClasspaths(args, localPW);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void tryAllClasspaths(PrintWriter localPW) throws Throwable {
        localPW.println(Main.getTextMessage("SIF08.B", new Object[0]));
        localPW.println(Main.getTextMessage("SIF08.C", "java org.apache.derby.tools.sysinfo -cp args"));
        StringBuffer successes = new StringBuffer(Main.getTextMessage("SIF08.D", new Object[0]) + Main.crLf());
        StringBuffer failures = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf());
        Main.tryCoreClasspath(successes, failures);
        Main.tryNetClasspath(successes, failures);
        Main.tryClientClasspath(successes, failures);
        Main.tryUtilsClasspath(successes, failures);
        localPW.println(successes.toString());
        if (!failures.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf())) {
            localPW.println(failures.toString());
        } else {
            localPW.println(Main.getTextMessage("SIF08.F", new Object[0]));
        }
        localPW.flush();
    }

    private static void trySomeClasspaths(String[] args, PrintWriter localPW) throws Throwable {
        String userclass;
        boolean seenArg = false;
        StringBuffer successes = new StringBuffer(Main.getTextMessage("SIF08.D", new Object[0]) + Main.crLf());
        StringBuffer failures = new StringBuffer(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf());
        if (Main.argumentsContain(args, EMBEDDED)) {
            Main.tryCoreClasspath(successes, failures);
            seenArg = true;
        }
        if (Main.argumentsContain(args, NET)) {
            Main.tryNetClasspath(successes, failures);
            seenArg = true;
        }
        if (Main.argumentsContain(args, CLIENT)) {
            Main.tryClientClasspath(successes, failures);
            seenArg = true;
        }
        if (Main.argumentsContain(args, TOOLS) || Main.argumentsContain(args, "utils")) {
            Main.tryUtilsClasspath(successes, failures);
            seenArg = true;
        }
        if (!(userclass = Main.argumentMatches(args, ".class")).equals("")) {
            Main.tryMyClasspath(Main.argumentMatches(args, ".class"), Main.getTextMessage("SIF08.H", userclass), successes, failures);
            seenArg = true;
        }
        if (seenArg) {
            localPW.println(successes.toString());
            if (!failures.toString().equals(Main.crLf() + Main.getTextMessage("SIF08.E", new Object[0]) + Main.crLf())) {
                localPW.println(failures.toString());
            } else {
                localPW.println(Main.getTextMessage("SIF08.F", new Object[0]));
            }
        } else {
            localPW.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
        }
        localPW.flush();
    }

    private static void tryCoreClasspath(StringBuffer successes, StringBuffer failures) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), successes, failures);
    }

    private static void tryNetClasspath(StringBuffer successes, StringBuffer failures) {
        Main.tryMyClasspath("org.apache.derby.database.Database", Main.getTextMessage("SIF08.J", "derby.jar"), successes, failures);
        Main.tryMyClasspath("org.apache.derby.drda.NetworkServerControl", Main.getTextMessage("SIF08.I", "derbynet.jar"), successes, failures);
    }

    private static void tryClientClasspath(StringBuffer successes, StringBuffer failures) {
        Main.tryMyClasspath("org.apache.derby.jdbc.ClientDriver", Main.getTextMessage("SIF08.L", "derbyclient.jar"), successes, failures);
    }

    private static void tryUtilsClasspath(StringBuffer successes, StringBuffer failures) {
        Main.tryMyClasspath("org.apache.derby.tools.ij", Main.getTextMessage("SIF08.Q", "derbytools.jar"), successes, failures);
    }

    private static void tryTstingClasspath(StringBuffer successes, StringBuffer failures) {
        Main.tryMyClasspath("org.apache.derbyTesting.junit.XATestUtil", "", successes, failures);
    }

    private static void tryMyClasspath(String cn, String library, StringBuffer successes, StringBuffer failures) {
        try {
            Class<?> c = Class.forName(cn);
            String loc = Main.getFileWhichLoadedClass(c);
            successes.append(Main.found(cn, library, loc));
        }
        catch (Throwable t) {
            failures.append(Main.notFound(cn, library));
        }
    }

    private static void tryAsResource(String cn, String library, StringBuffer successes, StringBuffer failures) {
        try {
            InputStream in = cn.getClass().getResourceAsStream(cn);
            in.close();
            String loc = Main.getFileWhichLoadedClass(cn.getClass());
            successes.append(Main.found(cn, library, loc));
        }
        catch (Throwable t) {
            failures.append(Main.notFound(cn, library));
        }
    }

    private static String found(String cn, String library, String loc) {
        StringBuffer temp = new StringBuffer(Main.crLf());
        temp.append("   " + library);
        temp.append(Main.crLf());
        if (loc != null) {
            temp.append("   ").append(loc).append(Main.crLf());
        }
        temp.append(Main.crLf());
        return temp.toString();
    }

    private static String notFound(String cn, String library) {
        StringBuffer temp = new StringBuffer(Main.crLf());
        temp.append("   " + library);
        temp.append(Main.crLf());
        temp.append("    " + Main.getTextMessage("SIF08.U", cn));
        temp.append(Main.crLf());
        temp.append(Main.crLf());
        return temp.toString();
    }

    private static String crLf() {
        return System.getProperty("line.separator");
    }

    private static String lookForMainArg(String[] args, PrintWriter localPW) {
        int length = args.length;
        String[] legalargs = new String[]{EMBEDDED};
        int argsfound = 0;
        String whichargument = "";
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < legalargs.length; ++j) {
                if (!args[i].toUpperCase(Locale.ENGLISH).equals(legalargs[j].toUpperCase(Locale.ENGLISH))) continue;
                ++argsfound;
                whichargument = legalargs[j];
            }
        }
        if (argsfound > 1 || argsfound < 1) {
            localPW.println(Main.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
            return "";
        }
        return whichargument;
    }

    private static boolean argumentsContain(String[] args, String s) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private static String argumentMatches(String[] args, String ss) {
        String userclass = "";
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            if (!args[i].endsWith(ss)) continue;
            userclass = args[i].substring(0, args[i].length() - 6);
        }
        return userclass;
    }

    public static ZipInfoProperties[] getAllInfo(String classpath) {
        ZipInfoProperties[] zips = Main.loadZipFromResource();
        if (zips == null) {
            zips = new ZipInfoProperties[1];
            ZipInfoProperties zip = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(TOOLS));
            zip.setLocation(Main.getFileWhichLoadedClass(new Main().getClass()));
            zips[0] = zip;
        }
        try {
            if (classpath != null) {
                String[] cp = Main.parseClasspath(classpath);
                List<String> jarNamesList = Arrays.asList(jarNames);
                Vector<ZipInfoProperties> v = new Vector<ZipInfoProperties>();
                for (int i = 0; i < cp.length; ++i) {
                    boolean matches = false;
                    String candidate = cp[i];
                    for (String jarName : jarNames) {
                        if (!candidate.endsWith(jarName)) continue;
                        matches = true;
                        break;
                    }
                    if (!matches) continue;
                    ZipInfoProperties zip = null;
                    try {
                        zip = Main.checkForInfo(cp[i]);
                    }
                    catch (SecurityException se) {
                        zip = new ZipInfoProperties(null);
                        zip.setLocation(Main.getTextMessage("SIF03.C", se.getMessage()));
                    }
                    if (zip == null) continue;
                    v.addElement(zip);
                }
                if (v.size() > 0) {
                    Object[] cpzips = new ZipInfoProperties[v.size()];
                    v.copyInto(cpzips);
                    return Main.mergeZips(zips, (ZipInfoProperties[])cpzips);
                }
            }
            return Main.mergeZips(zips, null);
        }
        catch (SecurityException se) {
            ZipInfoProperties[] zip = new ZipInfoProperties[]{new ZipInfoProperties(null)};
            zip[0].setLocation(Main.getTextMessage("SIF03.C", se.getMessage()));
            return zip;
        }
    }

    private static ZipInfoProperties[] loadZipFromResource() {
        ArrayList<ZipInfoProperties> al = new ArrayList<ZipInfoProperties>();
        for (int i = 0; i < infoNames.length; ++i) {
            final String resource = "/".concat(infoNames[i]);
            InputStream is = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    InputStream locis = new Main().getClass().getResourceAsStream(resource);
                    return locis;
                }
            });
            if (is == null) continue;
            ZipInfoProperties ze = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(is));
            URL locUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    URL realUrl = new Main().getClass().getResource(resource);
                    return realUrl;
                }
            });
            ze.setLocation(Main.formatURL(locUrl));
            al.add(ze);
        }
        if (al.size() == 0) {
            return null;
        }
        ZipInfoProperties[] zip = new ZipInfoProperties[al.size()];
        al.toArray(zip);
        return zip;
    }

    private static String[] parseClasspath(String cp) {
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
        int count = st.countTokens();
        if (count == 0) {
            return null;
        }
        String[] vals = new String[count];
        for (int i = 0; i < count; ++i) {
            vals[i] = st.nextToken();
        }
        return vals;
    }

    private static ZipInfoProperties checkForInfo(final String cpEntry) {
        return AccessController.doPrivileged(new PrivilegedAction<ZipInfoProperties>(){

            @Override
            public ZipInfoProperties run() {
                File f = new File(cpEntry);
                if (!f.exists()) {
                    return null;
                }
                if (f.isDirectory()) {
                    ZipInfoProperties zip = Main.checkDirectory(cpEntry);
                    return zip;
                }
                if (f.isFile()) {
                    ZipInfoProperties zip = Main.checkFile(cpEntry);
                    return zip;
                }
                return null;
            }
        });
    }

    private static ZipInfoProperties checkDirectory(String dirname) {
        boolean foundOne = false;
        File f = null;
        for (int i = 0; i < infoNames.length; ++i) {
            String localSysinfo = infoNames[i].replace('/', File.separatorChar);
            f = new File(dirname, localSysinfo);
            if (!f.exists()) continue;
            foundOne = true;
            break;
        }
        if (!foundOne || f == null) {
            return null;
        }
        try {
            FileInputStream bis = new FileInputStream(f);
            ZipInfoProperties zip = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(bis));
            zip.setLocation(Main.getCanonicalPath(new File(dirname)).replace('/', File.separatorChar));
            return zip;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static ZipInfoProperties checkFile(String filename) {
        try {
            ZipFile zf = new ZipFile(filename);
            ZipEntry thisEntry = null;
            for (int i = 0; i < infoNames.length && (thisEntry = zf.getEntry(infoNames[i])) == null; ++i) {
            }
            if (thisEntry == null) {
                return null;
            }
            InputStream bis = zf.getInputStream(thisEntry);
            if (bis == null) {
                return null;
            }
            ZipInfoProperties zip = new ZipInfoProperties(ProductVersionHolder.getProductVersionHolderFromMyEnv(bis));
            zip.setLocation(Main.getCanonicalPath(new File(filename)).replace('/', File.separatorChar));
            return zip;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static String getTextMessage(String msgId, Object ... arguments) {
        return LOCALIZED_RESOURCE.getTextMessage(msgId, arguments);
    }

    private static String getFileWhichLoadedClass(final Class cls) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                CodeSource cs = null;
                try {
                    cs = cls.getProtectionDomain().getCodeSource();
                }
                catch (SecurityException se) {
                    return Main.getTextMessage("SIF01.V", cls.getName(), se.getMessage());
                }
                if (cs == null) {
                    return null;
                }
                URL result = cs.getLocation();
                try {
                    return URLDecoder.decode(result.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return e.getMessage();
                }
            }
        });
    }

    private static ZipInfoProperties[] mergeZips(ZipInfoProperties[] zip1, ZipInfoProperties[] zip2) {
        Vector<ZipInfoProperties> v = new Vector<ZipInfoProperties>();
        boolean foundDup = false;
        for (int i = 0; i < zip1.length; ++i) {
            if (zip1[i] != null && zip1.length > 1) {
                for (int j = i + 1; j < zip1.length; ++j) {
                    if (!zip1[i].getLocation().equals(zip1[j].getLocation())) continue;
                    zip1[j] = null;
                }
            }
            if (zip1[i] == null) continue;
            v.addElement(zip1[i]);
        }
        if (zip2 != null) {
            for (int j = 0; j < zip2.length; ++j) {
                for (int k = 0; k < v.size(); ++k) {
                    ZipInfoProperties z = (ZipInfoProperties)v.get(k);
                    if (!zip2[j].getLocation().equals(z.getLocation())) continue;
                    foundDup = true;
                }
                if (!foundDup) {
                    v.addElement(zip2[j]);
                }
                foundDup = false;
            }
        }
        Object[] merged = new ZipInfoProperties[v.size()];
        v.copyInto(merged);
        return merged;
    }

    private static String formatURL(URL loc) {
        String filename;
        try {
            filename = URLDecoder.decode(loc.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        if (filename.startsWith("jar:")) {
            filename = filename.substring(4);
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring(5);
        }
        if (filename.indexOf("!") > -1) {
            filename = filename.substring(0, filename.indexOf("!"));
        }
        if (filename.indexOf("/org/apache/derby") > -1) {
            filename = filename.substring(0, filename.indexOf("/org/apache/derby"));
        }
        if (filename.charAt(0) == '/' && Character.isLetter(filename.charAt(1)) && filename.charAt(2) == ':' && filename.charAt(2) == '/') {
            filename = filename.substring(1);
        }
        String result = "";
        try {
            result = Main.getCanonicalPath(new File(filename)).replace('/', File.separatorChar);
        }
        catch (IOException e) {
            result = e.getMessage();
        }
        return result;
    }
}

