/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Alias {
    private static final char AGGREGATE_TYPE = 'G';
    private static final char UDT_TYPE = 'A';
    private static final char PROCEDURE_TYPE = 'P';
    private static final char FUNCTION_TYPE = 'F';

    public static void doPFAU(Connection conn, boolean at10_6) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE=?");
        if (at10_6) {
            DB_Alias.generateDDL(ps, 'A');
        }
        DB_Alias.generateDDL(ps, 'P');
        DB_Alias.generateDDL(ps, 'F');
        DB_Alias.generateDDL(ps, 'G');
        ps.close();
    }

    private static void generateDDL(PreparedStatement ps, char aliasType) throws SQLException {
        ps.setString(1, new String(new char[]{aliasType}));
        ResultSet rs = ps.executeQuery();
        DB_Alias.generateDDL(rs, aliasType);
        rs.close();
    }

    private static void generateDDL(ResultSet rs, char aliasType) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String procSchema;
            if (rs.getBoolean(6) || dblook.isIgnorableSchema(procSchema = dblook.lookupSchemaId(rs.getString(4)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                switch (aliasType) {
                    case 'A': {
                        Logs.reportMessage("DBLOOK_UDTHeader");
                        break;
                    }
                    case 'P': {
                        Logs.reportMessage("DBLOOK_StoredProcHeader");
                        break;
                    }
                    case 'F': {
                        Logs.reportMessage("DBLOOK_FunctionHeader");
                        break;
                    }
                    case 'G': {
                        Logs.reportMessage("DBLOOK_AggregateHeader");
                    }
                }
                Logs.reportString("----------------------------------------------\n");
            }
            String aliasName = rs.getString(1);
            String fullName = dblook.addQuotes(dblook.expandDoubleQuotes(aliasName));
            fullName = procSchema + "." + fullName;
            String creationString = DB_Alias.createPFAUString(fullName, rs, aliasType);
            Logs.writeToNewDDL(creationString);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String createPFAUString(String aliasName, ResultSet aliasInfo, char aliasType) throws SQLException {
        StringBuffer alias = new StringBuffer("CREATE ");
        switch (aliasType) {
            case 'A': {
                alias.append("TYPE ");
                break;
            }
            case 'P': {
                alias.append("PROCEDURE ");
                break;
            }
            case 'F': {
                alias.append("FUNCTION ");
                break;
            }
            case 'G': {
                alias.append("DERBY AGGREGATE ");
            }
        }
        alias.append(aliasName);
        alias.append(" ");
        String params = aliasInfo.getString(2);
        if (aliasType == 'G') {
            alias.append(params);
            alias.append(" ");
        } else if (aliasType != 'A') {
            alias.append(params.substring(params.indexOf("("), params.length()));
            alias.append(" ");
        }
        alias.append("EXTERNAL NAME '");
        alias.append(aliasInfo.getString(5));
        if (aliasType == 'A') {
            alias.append("' ");
            alias.append(params);
        } else if (aliasType == 'G') {
            alias.append("' ");
        } else if (aliasType != 'G') {
            alias.append(".");
            alias.append(params.substring(0, params.indexOf("(")));
            alias.append("' ");
        }
        return alias.toString();
    }

    public static void doSynonyms(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ALIAS, SCHEMAID, ALIASINFO, SYSTEMALIAS FROM SYS.SYSALIASES A WHERE ALIASTYPE='S'");
        boolean firstTime = true;
        while (rs.next()) {
            String aliasSchema;
            if (rs.getBoolean(4) || dblook.isIgnorableSchema(aliasSchema = dblook.lookupSchemaId(rs.getString(2)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SynonymHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String aliasName = rs.getString(1);
            String aliasFullName = dblook.addQuotes(dblook.expandDoubleQuotes(aliasName));
            aliasFullName = aliasSchema + "." + aliasFullName;
            Logs.writeToNewDDL("CREATE SYNONYM " + aliasFullName + " FOR " + rs.getString(3));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }
}

