/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.ErrorStringBuilder;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ExceptionFactory;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class Util {
    private static int logSeverityLevel = PropertyUtil.getSystemInt("derby.stream.error.logSeverityLevel", 0);

    public static void logAndThrowSQLException(SQLException se) throws SQLException {
        if (se.getErrorCode() >= logSeverityLevel) {
            Util.logSQLException(se);
        }
        throw se;
    }

    public static void logSQLException(SQLException se) {
        if (se == null) {
            return;
        }
        String message = se.getMessage();
        String sqlstate = se.getSQLState();
        if (sqlstate != null && sqlstate.equals("08004") && message != null && message.equals("Connection refused : java.lang.OutOfMemoryError")) {
            return;
        }
        Util.logError("\nERROR " + se.getSQLState() + ": " + se.getMessage() + "\n", se);
    }

    private static void logError(String errorMessage, Throwable t) {
        HeaderPrintWriter errorStream = Monitor.getStream();
        if (errorStream == null) {
            t.printStackTrace();
            return;
        }
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(errorStream.getHeader());
        errorStringBuilder.append(errorMessage);
        errorStringBuilder.stackTrace(t);
        errorStream.print(errorStringBuilder.get().toString());
        errorStream.flush();
        errorStringBuilder.reset();
    }

    public static void ASSERT(EmbedConnection conn, boolean mustBeTrue, String msg) throws SQLException {
        try {
            SanityManager.ASSERT(mustBeTrue, msg);
        }
        catch (Throwable t) {
            throw conn.handleException(t);
        }
    }

    public static void checkForSupportedDataType(int dataType) throws SQLException {
        if (!Util.isSupportedType(dataType)) {
            throw Util.generateCsSQLException("0A000.S.7", Util.typeName(dataType));
        }
    }

    public static void checkSupportedRaiseStandard(int dataType) throws StandardException {
        if (!Util.isSupportedType(dataType)) {
            throw StandardException.newException("0A000.S.7", Util.typeName(dataType));
        }
    }

    private static boolean isSupportedType(int dataType) {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 0: 
            case 70: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: 
            case 2012: {
                return false;
            }
        }
        return true;
    }

    public static SQLException generateCsSQLException(String error, Object ... args) {
        return Util.generateCsSQLException(error, null, args);
    }

    static SQLException generateCsSQLException(String error, Throwable t, Object ... args) {
        return ExceptionFactory.getInstance().getSQLException(error, (SQLException)null, t, args);
    }

    public static SQLException generateCsSQLException(StandardException se) {
        return ExceptionFactory.getInstance().getSQLException(se.getMessage(), se.getMessageId(), null, se.getSeverity(), se, se.getArguments());
    }

    public static SQLException noCurrentConnection() {
        return Util.generateCsSQLException("08003", new Object[0]);
    }

    static SQLException seeNextException(String messageId, SQLException next, Throwable cause, Object ... args) {
        return ExceptionFactory.getInstance().getSQLException(messageId, next, cause, args);
    }

    public static SQLException javaException(Throwable t) {
        SQLException result;
        String msg = t.getMessage();
        if (msg == null) {
            msg = "";
        }
        String name = t.getClass().getName();
        SQLException next = null;
        Throwable cause = t.getCause();
        if (cause != null) {
            next = cause instanceof SQLException ? (SQLException)cause : (cause instanceof StandardException ? Util.generateCsSQLException((StandardException)cause) : Util.javaException(cause));
        }
        if ((result = Util.seeNextException("XJ001.U", next, t, name, msg)).getErrorCode() >= logSeverityLevel) {
            Util.logSQLException(result);
        }
        return result;
    }

    public static SQLException policyNotReloaded(Throwable t) {
        return Util.generateCsSQLException("XK000.S", t, t.getMessage());
    }

    public static SQLException notImplemented() {
        return Util.notImplemented(MessageService.getTextMessage("J008", new Object[0]));
    }

    public static SQLException notImplemented(String feature) {
        return Util.generateCsSQLException("0A000.S", feature);
    }

    static SQLException setStreamFailure(IOException e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        return Util.generateCsSQLException("XJ022.S", e, msg);
    }

    static SQLException typeMisMatch(int targetSQLType) {
        return Util.generateCsSQLException("XJ020.S", Util.typeName(targetSQLType));
    }

    public static int[] squashLongs(long[] longs) {
        int count = longs == null ? 0 : longs.length;
        int[] ints = new int[count];
        for (int i = 0; i < count; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }

    static IOException newIOException(Throwable cause) {
        return new IOException(cause);
    }

    public static String typeName(int jdbcType) {
        switch (jdbcType) {
            case 2003: {
                return "ARRAY";
            }
            case -7: {
                return "CHAR () FOR BIT DATA";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 70: {
                return "DATALINK";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case 2006: {
                return "REF";
            }
            case 2012: {
                return "REF CURSOR";
            }
            case -8: {
                return "ROWID";
            }
            case 2002: {
                return "STRUCT";
            }
            case 456: {
                return "XML";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return String.valueOf(jdbcType);
    }
}

