/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derbyTesting.functionTests.tests.lang.ConstraintCharacteristicsTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClassLoadingTest
extends BaseJDBCTestCase {
    public ClassLoadingTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(ClassLoadingTest.class);
    }

    public void test_01_6654() throws Exception {
        ByteArray classBytes = new ByteArray(new byte[]{1});
        Connection conn = this.getConnection();
        LanguageConnectionContext lcc = ConstraintCharacteristicsTest.getLCC(conn);
        ClassFactory classFactory = lcc.getLanguageConnectionFactory().getClassFactory();
        String className1 = "BadClassName";
        String className2 = "bad.class.Name";
        this.vet6654(classFactory, className1, classBytes);
        this.vet6654(classFactory, className2, classBytes);
    }

    private void vet6654(ClassFactory classFactory, String className, ByteArray classBytes) throws Exception {
        try {
            classFactory.loadGeneratedClass(className, classBytes);
            ClassLoadingTest.fail((String)("Should not have been able to load class " + className));
        }
        catch (IllegalArgumentException iae) {
            ClassLoadingTest.println("Caught expected IllegalArgumentException");
        }
    }
}

