/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.run;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.system.oe.load.SimpleInsert;
import org.apache.derbyTesting.system.oe.util.HandleCheckError;
import org.apache.derbyTesting.system.oe.util.OEChecks;

public class DriverUtility {
    private Connection conn = null;
    private static short scale = 1;
    private static String dbUrl = "jdbc:derby:wombat;create=true";
    private static String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static boolean doChecks = true;

    public DriverUtility() {
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        DriverUtility.parseArgs(args);
        DriverUtility oe = new DriverUtility();
        oe.populate();
        if (doChecks) {
            oe.allChecks();
        }
        oe.cleanup();
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            System.out.println("dbUrl=" + dbUrl);
            this.conn = DriverManager.getConnection(dbUrl);
        }
        return this.conn;
    }

    public void populate() throws Exception {
        SimpleInsert loader = new SimpleInsert();
        loader.setupLoad(this.getConnection(), scale);
        long start = System.currentTimeMillis();
        loader.populateAllTables();
        long stop = System.currentTimeMillis();
        System.out.println("Time to load (ms)=" + (stop - start));
    }

    public void allChecks() throws Exception {
        OEChecks checks = new OEChecks();
        checks.initialize(new HandleCheckError(), this.getConnection(), scale);
        long start = System.currentTimeMillis();
        checks.checkAllRowCounts();
        long stop = System.currentTimeMillis();
        System.out.println("Time to do checks (ms)=" + (stop - start));
    }

    private static void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-scale")) {
                scale = Short.parseShort(args[++i]);
                continue;
            }
            if (arg.equals("-driver")) {
                driver = args[++i];
                continue;
            }
            if (arg.equals("-dbUrl")) {
                dbUrl = args[++i];
                continue;
            }
            if (arg.equals("-doChecks")) {
                doChecks = !args[++i].equals("false");
                continue;
            }
            if (arg.equals("-help")) {
                DriverUtility.printUsage();
                System.exit(0);
                continue;
            }
            System.err.println("Invalid option: " + args[i]);
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.derbyTesting.system.oe.run.DriverUtility options");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -scale warehouse scaling factor. Takes a short value. If not specified defaults to 1");
        System.out.println("  -doChecks  should consistency checks be run on the database. Takes a boolean value");
        System.out.println("  -driver  the class of the jdbc driver");
        System.out.println("  -dbUrl  the database connection url");
        System.out.println("  -help prints usage");
        System.out.println();
    }

    public void cleanup() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

