/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ShutDownDBWhenNSShutsDownTest
extends BaseJDBCTestCase {
    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ShutDownDBWhenNSShutsDownTest");
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new ShutDownDBWhenNSShutsDownTest("testEngineShutdownDoesNotTakeDownNSManualReload")));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new ShutDownDBWhenNSShutsDownTest("testDatabasesShutDownWhenNSShutdownAPI")));
        return baseTestSuite;
    }

    public ShutDownDBWhenNSShutsDownTest(String string) {
        super(string);
    }

    public void testEngineShutdownDoesNotTakeDownNSManualReload() throws Exception {
        this.scenarioEngineShutdownDoesNotTakeDownNS(true);
    }

    public void testEngineShutdownDoesNotTakeDownNSAutoReload() throws Exception {
        this.scenarioEngineShutdownDoesNotTakeDownNS(false);
    }

    private void scenarioEngineShutdownDoesNotTakeDownNS(boolean bl) throws Exception {
        int n;
        Connection[] connectionArray = new Connection[20];
        for (n = 0; n < connectionArray.length; ++n) {
            connectionArray[n] = this.openDefaultConnection();
        }
        for (n = 0; n < connectionArray.length; ++n) {
            connectionArray[n].close();
            connectionArray[n] = null;
        }
        Thread.sleep(500L);
        TestConfiguration.getCurrent().shutdownEngine();
        if (bl) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        for (int i = 0; i < 20; ++i) {
            this.openDefaultConnection().close();
        }
    }

    public void testDatabasesShutDownWhenNSShutdownAPI() throws Exception {
        this.shutdownServerCheckDBShutDown(false);
    }

    public void XXtestDatabasesShutDownWhenNSShutdown() throws Exception {
        this.shutdownServerCheckDBShutDown(true);
    }

    private void shutdownServerCheckDBShutDown(boolean bl) throws Exception {
        this.createDatabase();
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        networkServerControl.shutdown();
        String string = ShutDownDBWhenNSShutsDownTest.getSystemProperty("derby.system.home") + File.separator + TestConfiguration.getCurrent().getDefaultDatabaseName() + File.separator + "db.lck";
        File file = new File(string);
        boolean bl2 = false;
        int n = 0;
        do {
            Thread.sleep(500L);
        } while ((bl2 = !PrivilegedFileOpsForTests.exists(file)) != bl && ++n < 120);
        ShutDownDBWhenNSShutsDownTest.assertEquals((String)"Database is shut down", (boolean)bl, (boolean)bl2);
    }

    private void createDatabase() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE T1 (a int)");
        statement.execute("INSERT INTO T1 VALUES (1), (2), (3), (4), (5)");
        statement.execute("DROP TABLE T1");
        connection.commit();
        connection.close();
    }
}

