/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SystemPropertyTestSetup
extends TestSetup {
    protected Properties newValues;
    private Properties oldValues;
    private boolean staticProperties;

    public SystemPropertyTestSetup(Test test, Properties properties, boolean bl) {
        super(test);
        this.newValues = properties;
        this.staticProperties = bl;
    }

    public SystemPropertyTestSetup(Test test, Properties properties) {
        super(test);
        this.newValues = properties;
        this.staticProperties = false;
    }

    public static Test singleProperty(Test test, String string, String string2) {
        return SystemPropertyTestSetup.singleProperty(test, string, string2, false);
    }

    public static Test singleProperty(Test test, String string, String string2, boolean bl) {
        Properties properties = new Properties();
        properties.setProperty(string, string2);
        return new SystemPropertyTestSetup(test, properties, bl);
    }

    protected void setUp() throws Exception {
        this.oldValues = new Properties();
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownEngine(false);
        }
        this.setProperties(this.newValues);
    }

    protected void tearDown() throws Exception {
        try {
            if (this.staticProperties) {
                TestConfiguration.getCurrent().shutdownEngine();
            }
        }
        finally {
            this.restoreOldPropertyValues();
            this.oldValues = null;
        }
    }

    private void restoreOldPropertyValues() throws Exception {
        Enumeration<?> enumeration = this.newValues.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.oldValues.getProperty(string) != null) continue;
            BaseTestCase.removeSystemProperty(string);
        }
        this.setProperties(this.oldValues);
    }

    private void setProperties(Properties properties) throws PrivilegedActionException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = BaseTestCase.getSystemProperty(string);
            if (string3 != null) {
                boolean bl2 = bl = !string3.equals(string2);
                if (properties != this.oldValues) {
                    this.oldValues.setProperty(string, string3);
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            BaseTestCase.setSystemProperty(string, string2);
        }
    }
}

