/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DerbyNetNewServerTest
extends BaseJDBCTestCase {
    public DerbyNetNewServerTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3() && Derby.hasServer()) {
            return new BaseTestSuite(DerbyNetNewServerTest.class);
        }
        return new BaseTestSuite("DerbyNetNewServerTest.empty");
    }

    protected void setUp() throws Exception {
        NetworkServerTestSetup.waitForAvailablePort();
    }

    public void testStartWithPrintWriter() throws UnknownHostException, Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        NetworkServerControl networkServerControl = new NetworkServerControl(InetAddress.getByName(TestConfiguration.getCurrent().getHostName()), TestConfiguration.getCurrent().getPort());
        DerbyNetNewServerTest.assertEquals((String)"No log initially", (int)0, (int)byteArrayOutputStream.size());
        networkServerControl.start(printWriter);
        NetworkServerTestSetup.waitForServerStart(networkServerControl);
        int n = byteArrayOutputStream.size();
        DerbyNetNewServerTest.assertTrue((String)"Create log with start message", (0 < n ? 1 : 0) != 0);
        networkServerControl.shutdown();
        int n2 = byteArrayOutputStream.size();
        for (int i = 0; i < 60 && n2 == n; ++i) {
            Thread.sleep(500L);
            n2 = byteArrayOutputStream.size();
        }
        byteArrayOutputStream.close();
        byteArrayOutputStream = null;
        printWriter.close();
        DerbyNetNewServerTest.assertTrue((String)"Num of log item should add", (n2 > n ? 1 : 0) != 0);
    }

    public void testStartWithoutPrintWriter() throws UnknownHostException, Exception {
        NetworkServerControl networkServerControl = new NetworkServerControl(InetAddress.getByName(TestConfiguration.getCurrent().getHostName()), TestConfiguration.getCurrent().getPort());
        networkServerControl.start(null);
        NetworkServerTestSetup.waitForServerStart(networkServerControl);
        networkServerControl.shutdown();
        DerbyNetNewServerTest.assertTrue((boolean)true);
    }
}

