/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby3650Test
extends BaseJDBCTestCase {
    private static final boolean runDerby3749tests = false;

    public Derby3650Test(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    private void runQueryCasesClob(String string) throws SQLException, IOException {
        this.runQueryClob(string, true, false);
        this.runQueryClob(string, false, false);
    }

    private void runQueryClob(String string, boolean bl, boolean bl2) throws SQLException, IOException {
        int n;
        int n2;
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            n2 = resultSet.getInt(1);
            n = resultSet.getInt(2);
            Clob clob = resultSet.getClob(3);
            this.verifyClob(clob.getCharacterStream(), n, new LoopingAlphabetReader(n));
            if (bl) {
                clob.free();
            }
            if (!bl2) continue;
            this.commit();
        }
        resultSet.close();
        this.commit();
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            n2 = resultSet.getInt(1);
            n = resultSet.getInt(2);
            this.verifyClob(resultSet.getCharacterStream(3), n, new LoopingAlphabetReader(n));
            if (!bl2) continue;
            this.commit();
        }
        resultSet.close();
        this.commit();
        preparedStatement.close();
    }

    private void runQueryCasesBlob(String string) throws SQLException, IOException {
        this.runQueryBlob(string, true, false);
        this.runQueryBlob(string, false, false);
    }

    private void runQueryBlob(String string, boolean bl, boolean bl2) throws SQLException, IOException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob(3);
            this.verifyBlob(blob.getBinaryStream(), resultSet.getInt(2), resultSet.getInt(1));
            if (bl) {
                blob.free();
            }
            if (!bl2) continue;
            this.commit();
        }
        resultSet.close();
        this.rollback();
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = resultSet.getInt(2);
            InputStream inputStream = resultSet.getBinaryStream(3);
            this.verifyBlob(inputStream, n2, n);
            if (!bl2) continue;
            this.commit();
        }
        resultSet.close();
        this.commit();
        preparedStatement.close();
    }

    private void verifyClob(Reader reader, int n, Reader reader2) throws SQLException, IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = reader.read();
            int n4 = reader2.read();
            if (n2 == -1) continue;
            ++n3;
            if ((char)n2 == n4) continue;
            Derby3650Test.fail((String)("Unexpected Character " + (char)n2 + " expected " + (char)n4));
        } while (n2 != -1);
        if (n3 != n) {
            Derby3650Test.fail((String)("Unexpected character count " + n3 + "expected: " + n));
        }
    }

    private void verifyBlob(InputStream inputStream, int n, int n2) throws SQLException, IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = inputStream.read()) == -1) continue;
            ++n4;
            if ((byte)n3 == n2) continue;
            Derby3650Test.fail((String)("Unexpected byte value " + (byte)n3 + " expected: " + n2));
        } while (n3 != -1);
        if (n4 != n) {
            Derby3650Test.fail((String)("Unexpected byte count, got " + n4 + "  expected " + n));
        }
    }

    public void test1ToManyJoinClob() throws SQLException, IOException {
        this.runQueryCasesClob("select testClob.id, length, c from testClob join jointab on jointab.id = testClob.id");
    }

    public void test1ToManyJoinBlob() throws SQLException, IOException {
        this.runQueryCasesBlob("select testBlob.id, length, c from testBlob join jointab on jointab.id = testBlob.id");
    }

    public void test1ToManyHashJoinClob() throws SQLException, IOException {
        this.runQueryCasesClob("select testClob.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \ntestClob --DERBY-PROPERTIES joinStrategy=HASH \njoin jointab on jointab.id = testClob.id");
        this.runQueryCasesClob("select jointab.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \njointab --DERBY-PROPERTIES joinStrategy=HASH \njoin testClob on jointab.id = testClob.id");
    }

    public void test1ToManyHashJoinBlob() throws SQLException, IOException {
        this.runQueryCasesBlob("select testBlob.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \ntestBlob --DERBY-PROPERTIES joinStrategy=HASH \njoin jointab on jointab.id = testBlob.id");
        this.runQueryCasesBlob("select testBlob.id, length, c from --DERBY-PROPERTIES joinOrder=FIXED \njointab --DERBY-PROPERTIES joinStrategy=HASH \njoin testBlob on jointab.id = testBlob.id");
    }

    public void test1ToManyleftOuterJoinClob() throws SQLException, IOException {
        this.runQueryCasesClob("select testClob.id, length, c from testClob left outer join jointab on jointab.id = testClob.id");
        this.runQueryCasesClob("select jointab.id, length, c from jointab left outer join testClob on jointab.id = testClob.id");
    }

    public void test1ToManyleftOuterJoinBlob() throws SQLException, IOException {
        this.runQueryCasesBlob("select testBlob.id, length, c from testBlob left outer join jointab on jointab.id = testBlob.id");
        this.runQueryCasesBlob("select jointab.id, length, c from jointab left outer join testBlob on jointab.id = testBlob.id");
    }

    public void testClobSelect() throws SQLException, IOException {
        this.runQueryCasesClob("select id, length, c from testMultipleClob");
    }

    public void testBlobSelect() throws SQLException, IOException {
        this.runQueryCasesBlob("select id, length, c from testMultipleBlob");
    }

    private static void initializeClobTables(Statement statement) throws SQLException, IOException {
        statement.executeUpdate("CREATE TABLE testClob (id int, length int, c CLOB(2M))");
        Connection connection = statement.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TestClob VALUES(?,?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 40000);
        preparedStatement.setCharacterStream(3, new LoopingAlphabetReader(40000L));
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 40001);
        preparedStatement.setCharacterStream(3, new LoopingAlphabetReader(40001L));
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 40002);
        preparedStatement.setCharacterStream(3, new LoopingAlphabetReader(40002L));
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 40003);
        preparedStatement.setCharacterStream(3, new LoopingAlphabetReader(40003L));
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE testMultipleClob (id int, length int, c CLOB(2M))");
        preparedStatement = connection.prepareStatement("INSERT INTO testMultipleClob VALUES(?,?,?)");
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 40000 + i);
            preparedStatement.setCharacterStream(3, new LoopingAlphabetReader(40000 + i));
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
    }

    private static void initializeBlobTables(Statement statement) throws SQLException, IOException {
        statement.executeUpdate("CREATE TABLE testBlob (id int, length int, c BLOB(2M))");
        Connection connection = statement.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TestBlob VALUES(?,?,?)");
        byte[] byArray = new byte[40000];
        Arrays.fill(byArray, (byte)1);
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 40000);
        preparedStatement.setBytes(3, byArray);
        preparedStatement.executeUpdate();
        byArray = new byte[40001];
        Arrays.fill(byArray, (byte)1);
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 40001);
        preparedStatement.setBytes(3, byArray);
        preparedStatement.executeUpdate();
        byArray = new byte[40002];
        Arrays.fill(byArray, (byte)2);
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 40002);
        preparedStatement.setBytes(3, byArray);
        preparedStatement.executeUpdate();
        byArray = new byte[40003];
        Arrays.fill(byArray, (byte)2);
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, 40003);
        preparedStatement.setBytes(3, byArray);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE jointab (id int)");
        statement.executeUpdate("INSERT INTO jointab values(1)");
        statement.executeUpdate("INSERT INTO jointab values(1)");
        statement.executeUpdate("INSERT INTO jointab values(2)");
        statement.executeUpdate("INSERT INTO jointab values(2)");
        statement.executeUpdate("CREATE TABLE testMultipleBlob (id int, length int, c BLOB(2M))");
        preparedStatement = connection.prepareStatement("INSERT INTO testMultipleBlob VALUES(?,?,?)");
        for (int i = 0; i < 100; ++i) {
            byArray = new byte[40000 + i];
            Arrays.fill(byArray, (byte)i);
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 40000 + i);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby3650Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                try {
                    Derby3650Test.initializeClobTables(statement);
                    Derby3650Test.initializeBlobTables(statement);
                }
                catch (IOException iOException) {
                    1.fail((String)("Unexpected I/O exception during setup: " + String.valueOf(iOException)));
                }
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby3650Test");
        baseTestSuite.addTest(Derby3650Test.baseSuite("Derby3650Test:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(Derby3650Test.baseSuite("Derby3650Test:client")));
        return baseTestSuite;
    }
}

