/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class ReplicationRun_Local_3_p4
extends ReplicationRun {
    public ReplicationRun_Local_3_p4(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_3_p4 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_3_p4.class);
        return baseTestSuite;
    }

    public void testReplication_Local_3_p4_StateNegativeTests() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        replicationTest = null;
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb), "08004");
        this.assertException(this._internal_stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb), "XRE43");
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private SQLException _connectToSlave(String string, int n, String string2) throws Exception {
        ClientDataSourceInterface clientDataSourceInterface;
        this.util.DEBUG("_connectToSlave");
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setDatabaseName(string2);
        clientDataSourceInterface.setServerName(string);
        clientDataSourceInterface.setPortNumber(n);
        clientDataSourceInterface.setConnectionAttributes(this.useEncryption(false));
        try {
            Connection connection = clientDataSourceInterface.getConnection();
            connection.close();
            return null;
        }
        catch (SQLException sQLException) {
            this.util.DEBUG(sQLException.getErrorCode() + " " + sQLException.getSQLState() + " " + sQLException.getMessage());
            return sQLException;
        }
    }

    private SQLException _internal_stopSlave(String string, int n, String string2) throws Exception {
        ClientDataSourceInterface clientDataSourceInterface;
        this.util.DEBUG("_internal_stopSlave");
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setDatabaseName(string2);
        clientDataSourceInterface.setServerName(string);
        clientDataSourceInterface.setPortNumber(n);
        clientDataSourceInterface.setConnectionAttributes("internal_stopslave=true" + this.useEncryption(false));
        try {
            Connection connection = clientDataSourceInterface.getConnection();
            connection.close();
            return null;
        }
        catch (SQLException sQLException) {
            this.util.DEBUG(sQLException.getErrorCode() + " " + sQLException.getSQLState() + " " + sQLException.getMessage());
            return sQLException;
        }
    }
}

