/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils.placeholder;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.DateUtils;

public class BusinessTimeUtils {
    private BusinessTimeUtils() {
        throw new IllegalStateException("BusinessTimeUtils class");
    }

    public static Map<String, String> getBusinessTime(CommandType commandType, Date runTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        switch (commandType) {
            case COMPLEMENT_DATA: {
                if (runTime != null) break;
                return result;
            }
        }
        Date businessDate = org.apache.commons.lang.time.DateUtils.addDays((Date)new Date(), (int)-1);
        if (runTime != null) {
            businessDate = org.apache.commons.lang.time.DateUtils.addDays((Date)runTime, (int)-1);
        }
        Date businessCurrentDate = org.apache.commons.lang.time.DateUtils.addDays((Date)businessDate, (int)1);
        result.put("system.biz.curdate", DateUtils.format(businessCurrentDate, "yyyyMMdd"));
        result.put("system.biz.date", DateUtils.format(businessDate, "yyyyMMdd"));
        result.put("system.datetime", DateUtils.format(businessCurrentDate, "yyyyMMddHHmmss"));
        return result;
    }
}

