/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public final class AlertPluginManager {
    private static final Logger log = LoggerFactory.getLogger(AlertPluginManager.class);
    private final PluginDao pluginDao;
    private final Map<Integer, AlertChannel> channelKeyedById = new HashMap<Integer, AlertChannel>();

    public AlertPluginManager(PluginDao pluginDao) {
        this.pluginDao = pluginDao;
    }

    @EventListener
    public void installPlugin(ApplicationReadyEvent readyEvent) {
        HashSet names = new HashSet();
        ServiceLoader.load(AlertChannelFactory.class).forEach(factory -> {
            String name = factory.name();
            log.info("Registering alert plugin: {}", (Object)name);
            if (!names.add(name)) {
                throw new IllegalStateException(String.format("Duplicate alert plugins named '%s'", name));
            }
            AlertChannel alertChannel = factory.create();
            log.info("Registered alert plugin: {}", (Object)name);
            List params = factory.params();
            String paramsJson = PluginParamsTransfer.transferParamsToJson((List)params);
            PluginDefine pluginDefine = new PluginDefine(name, PluginType.ALERT.getDesc(), paramsJson);
            int id = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            this.channelKeyedById.put(id, alertChannel);
        });
    }

    public Optional<AlertChannel> getAlertChannel(int id) {
        return Optional.ofNullable(this.channelKeyedById.get(id));
    }

    public int size() {
        return this.channelKeyedById.size();
    }
}

