/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.alert.AlertPluginManager;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertInfo;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendResponseCommand;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class AlertSender {
    private static final Logger log = LoggerFactory.getLogger(AlertSender.class);
    private final AlertDao alertDao;
    private final AlertPluginManager alertPluginManager;

    public AlertSender(AlertDao alertDao, AlertPluginManager alertPluginManager) {
        this.alertDao = alertDao;
        this.alertPluginManager = alertPluginManager;
    }

    public void send(List<Alert> alerts) {
        for (Alert alert : alerts) {
            int alertGroupId = alert.getAlertGroupId();
            List alertInstanceList = this.alertDao.listInstanceByAlertGroupId(alertGroupId);
            if (CollectionUtils.isEmpty((Collection)alertInstanceList)) {
                log.error("send alert msg fail,no bind plugin instance.");
                this.alertDao.updateAlert(AlertStatus.EXECUTION_FAILURE, "no bind plugin instance", alert.getId());
                continue;
            }
            AlertData alertData = new AlertData();
            alertData.setId(alert.getId()).setContent(alert.getContent()).setLog(alert.getLog()).setTitle(alert.getTitle());
            for (AlertPluginInstance instance : alertInstanceList) {
                AlertResult alertResult = this.alertResultHandler(instance, alertData);
                AlertStatus alertStatus = Boolean.parseBoolean(String.valueOf(alertResult.getStatus())) ? AlertStatus.EXECUTION_SUCCESS : AlertStatus.EXECUTION_FAILURE;
                this.alertDao.updateAlert(alertStatus, alertResult.getMessage(), alert.getId());
            }
        }
    }

    public AlertSendResponseCommand syncHandler(int alertGroupId, String title, String content) {
        List alertInstanceList = this.alertDao.listInstanceByAlertGroupId(alertGroupId);
        AlertData alertData = new AlertData();
        alertData.setContent(content).setTitle(title);
        boolean sendResponseStatus = true;
        ArrayList<AlertSendResponseResult> sendResponseResults = new ArrayList<AlertSendResponseResult>();
        if (CollectionUtils.isEmpty((Collection)alertInstanceList)) {
            AlertSendResponseResult alertSendResponseResult = new AlertSendResponseResult();
            String message = String.format("Alert GroupId %s send error : not found alert instance", alertGroupId);
            alertSendResponseResult.setStatus(false);
            alertSendResponseResult.setMessage(message);
            sendResponseResults.add(alertSendResponseResult);
            log.error("Alert GroupId {} send error : not found alert instance", (Object)alertGroupId);
            return new AlertSendResponseCommand(false, sendResponseResults);
        }
        for (AlertPluginInstance instance : alertInstanceList) {
            AlertResult alertResult = this.alertResultHandler(instance, alertData);
            AlertSendResponseResult alertSendResponseResult = new AlertSendResponseResult(Boolean.parseBoolean(String.valueOf(alertResult.getStatus())), alertResult.getMessage());
            sendResponseStatus = sendResponseStatus && alertSendResponseResult.getStatus();
            sendResponseResults.add(alertSendResponseResult);
        }
        return new AlertSendResponseCommand(sendResponseStatus, sendResponseResults);
    }

    private AlertResult alertResultHandler(AlertPluginInstance instance, AlertData alertData) {
        AlertResult alertResult;
        Optional<AlertChannel> alertChannel = this.alertPluginManager.getAlertChannel(instance.getPluginDefineId());
        AlertResult alertResultExtend = new AlertResult();
        String pluginInstanceName = instance.getInstanceName();
        if (!alertChannel.isPresent()) {
            String message = String.format("Alert Plugin %s send error : return value is null", pluginInstanceName);
            alertResultExtend.setStatus(String.valueOf(false));
            alertResultExtend.setMessage(message);
            log.error("Alert Plugin {} send error : not found plugin {}", (Object)pluginInstanceName, (Object)instance.getPluginDefineId());
            return alertResultExtend;
        }
        AlertInfo alertInfo = new AlertInfo();
        alertInfo.setAlertData(alertData);
        Map paramsMap = JSONUtils.toMap((String)instance.getPluginInstanceParams());
        alertInfo.setAlertParams(paramsMap);
        try {
            alertResult = alertChannel.get().process(alertInfo);
        }
        catch (Exception e) {
            alertResult = new AlertResult("false", e.getMessage());
            log.error("send alert error alert data id :{},", (Object)alertData.getId(), (Object)e);
        }
        if (alertResult == null) {
            String message = String.format("Alert Plugin %s send error : return alertResult value is null", pluginInstanceName);
            alertResultExtend.setStatus(String.valueOf(false));
            alertResultExtend.setMessage(message);
            log.info("Alert Plugin {} send error : return alertResult value is null", (Object)pluginInstanceName);
        } else if (!Boolean.parseBoolean(String.valueOf(alertResult.getStatus()))) {
            alertResultExtend.setStatus(String.valueOf(false));
            alertResultExtend.setMessage(alertResult.getMessage());
            log.info("Alert Plugin {} send error : {}", (Object)pluginInstanceName, (Object)alertResult.getMessage());
        } else {
            String message = String.format("Alert Plugin %s send success", pluginInstanceName);
            alertResultExtend.setStatus(String.valueOf(true));
            alertResultExtend.setMessage(message);
            log.info("Alert Plugin {} send success", (Object)pluginInstanceName);
        }
        return alertResultExtend;
    }
}

