/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.DBTaskAckCommand;
import org.apache.dolphinscheduler.remote.command.DBTaskResponseCommand;
import org.apache.dolphinscheduler.remote.command.TaskKillAckCommand;
import org.apache.dolphinscheduler.remote.command.TaskRecallAckCommand;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResponsePersistThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TaskResponsePersistThread.class);
    private final ConcurrentLinkedQueue<TaskResponseEvent> events = new ConcurrentLinkedQueue();
    private final Integer processInstanceId;
    private ProcessService processService;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceMapper;

    public TaskResponsePersistThread(ProcessService processService, ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceMapper, Integer processInstanceId) {
        this.processService = processService;
        this.processInstanceMapper = processInstanceMapper;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void run() {
        while (!this.events.isEmpty()) {
            TaskResponseEvent event = this.events.peek();
            try {
                boolean result = this.persist(event);
                if (result) continue;
                logger.error("persist meta error, task id:{}, instance id:{}", (Object)event.getTaskInstanceId(), (Object)event.getProcessInstanceId());
            }
            catch (Exception e) {
                logger.error("persist error, task id:{}, instance id:{}, error: {}", new Object[]{event.getTaskInstanceId(), event.getProcessInstanceId(), e});
            }
            finally {
                this.events.remove(event);
            }
        }
    }

    private boolean persist(TaskResponseEvent taskResponseEvent) {
        WorkflowExecuteThread workflowExecuteThread;
        Event event = taskResponseEvent.getEvent();
        Channel channel = taskResponseEvent.getChannel();
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskResponseEvent.getTaskInstanceId()));
        boolean result = true;
        switch (event) {
            case ACK: {
                try {
                    if (taskInstance != null) {
                        ExecutionStatus status = taskInstance.getState().typeIsFinished() ? taskInstance.getState() : taskResponseEvent.getState();
                        this.processService.changeTaskState(taskInstance, status, taskResponseEvent.getStartTime(), taskResponseEvent.getWorkerAddress(), taskResponseEvent.getExecutePath(), taskResponseEvent.getLogPath(), taskResponseEvent.getTaskInstanceId());
                        logger.debug("changeTaskState in ACK , changed in meta:{} ,task instance state:{}, task response event state:{}, taskInstance id:{},taskInstance host:{}", new Object[]{result, taskInstance.getState(), taskResponseEvent.getState(), taskInstance.getId(), taskInstance.getHost()});
                    }
                    DBTaskAckCommand taskAckCommand = new DBTaskAckCommand(ExecutionStatus.SUCCESS.getCode(), taskResponseEvent.getTaskInstanceId());
                    channel.writeAndFlush((Object)taskAckCommand.convert2Command());
                    logger.debug("worker ack master success, taskInstance id:{},taskInstance host:{}", (Object)taskInstance.getId(), (Object)taskInstance.getHost());
                }
                catch (Exception e) {
                    result = false;
                    logger.error("worker ack master error", (Throwable)e);
                    DBTaskAckCommand taskAckCommand = new DBTaskAckCommand(ExecutionStatus.FAILURE.getCode(), taskInstance == null ? -1 : taskInstance.getId());
                    channel.writeAndFlush((Object)taskAckCommand.convert2Command());
                }
                break;
            }
            case RESULT: {
                try {
                    DBTaskResponseCommand taskResponseCommand;
                    if (taskInstance != null) {
                        result = this.processService.changeTaskState(taskInstance, taskResponseEvent.getState(), taskResponseEvent.getEndTime(), taskResponseEvent.getProcessId(), taskResponseEvent.getAppIds(), taskResponseEvent.getTaskInstanceId(), taskResponseEvent.getVarPool());
                        logger.debug("changeTaskState in RESULT , changed in meta:{} task instance state:{}, task response event state:{}, taskInstance id:{},taskInstance host:{}", new Object[]{result, taskInstance.getState(), taskResponseEvent.getState(), taskInstance.getId(), taskInstance.getHost()});
                    }
                    if (!result) {
                        taskResponseCommand = new DBTaskResponseCommand(ExecutionStatus.FAILURE.getCode(), taskResponseEvent.getTaskInstanceId());
                        channel.writeAndFlush((Object)taskResponseCommand.convert2Command());
                        logger.debug("worker response master failure, taskInstance id:{},taskInstance host:{}", (Object)taskInstance.getId(), (Object)taskInstance.getHost());
                        break;
                    }
                    taskResponseCommand = new DBTaskResponseCommand(ExecutionStatus.SUCCESS.getCode(), taskResponseEvent.getTaskInstanceId());
                    channel.writeAndFlush((Object)taskResponseCommand.convert2Command());
                    logger.debug("worker response master success, taskInstance id:{},taskInstance host:{}", (Object)taskInstance.getId(), (Object)taskInstance.getHost());
                }
                catch (Exception e) {
                    result = false;
                    logger.error("worker response master error", (Throwable)e);
                    DBTaskResponseCommand taskResponseCommand = new DBTaskResponseCommand(ExecutionStatus.FAILURE.getCode(), -1);
                    channel.writeAndFlush((Object)taskResponseCommand.convert2Command());
                }
                break;
            }
            case ACTION_STOP: {
                workflowExecuteThread = this.processInstanceMapper.get(taskResponseEvent.getProcessInstanceId());
                if (workflowExecuteThread != null) {
                    ITaskProcessor taskProcessor = workflowExecuteThread.getActiveTaskProcessorMaps().get(taskResponseEvent.getTaskInstanceId());
                    if (taskProcessor != null) {
                        taskProcessor.persist(TaskAction.STOP);
                        logger.debug("ACTION_STOP: task instance id:{}, process instance id:{}", (Object)taskResponseEvent.getTaskInstanceId(), (Object)taskResponseEvent.getProcessInstanceId());
                    }
                    workflowExecuteThread.getActiveTaskProcessorMaps().remove(taskResponseEvent.getTaskInstanceId());
                    if (workflowExecuteThread.activeTaskFinish()) {
                        this.processInstanceMapper.remove(taskResponseEvent.getProcessInstanceId());
                    }
                }
                if (channel == null) break;
                TaskKillAckCommand taskKillAckCommand = new TaskKillAckCommand(ExecutionStatus.SUCCESS.getCode(), taskResponseEvent.getTaskInstanceId());
                channel.writeAndFlush((Object)taskKillAckCommand.convert2Command());
                break;
            }
            case WORKER_REJECT: {
                try {
                    ITaskProcessor taskProcessor;
                    WorkflowExecuteThread executeThread = this.processInstanceMapper.get(taskResponseEvent.getProcessInstanceId());
                    if (executeThread != null && (taskProcessor = executeThread.getActiveTaskProcessorMaps().get(taskResponseEvent.getTaskInstanceId())) != null) {
                        taskProcessor.action(TaskAction.RESUBMIT);
                        logger.info("RESUBMIT: task instance id:{}, process instance id:{}", (Object)taskResponseEvent.getTaskInstanceId(), (Object)taskResponseEvent.getProcessInstanceId());
                    }
                    if (channel == null) break;
                    TaskRecallAckCommand taskRecallAckCommand = new TaskRecallAckCommand(ExecutionStatus.SUCCESS.getCode(), taskResponseEvent.getTaskInstanceId());
                    channel.writeAndFlush((Object)taskRecallAckCommand.convert2Command(taskResponseEvent.getOpaque()));
                    logger.info("taskRecallAckCommand send successfully, task instance id:{}, opaque:{}", (Object)taskResponseEvent.getTaskInstanceId(), (Object)taskResponseEvent.getOpaque());
                }
                catch (Exception e) {
                    result = false;
                    logger.error("worker reject error", (Throwable)e);
                    TaskRecallAckCommand taskRecallAckCommand = new TaskRecallAckCommand(ExecutionStatus.FAILURE.getCode(), taskResponseEvent.getTaskInstanceId());
                    channel.writeAndFlush((Object)taskRecallAckCommand.convert2Command(taskResponseEvent.getOpaque()));
                    logger.info("taskRecallAckCommand send successfully, task instance id:{}, opaque:{}", (Object)taskResponseEvent.getTaskInstanceId(), (Object)taskResponseEvent.getOpaque());
                }
                break;
            }
            case REALLOCATE: {
                logger.warn("Not yet supported");
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid event type : " + event);
            }
        }
        if ((workflowExecuteThread = this.processInstanceMapper.get(taskResponseEvent.getProcessInstanceId())) != null && taskResponseEvent.getState().typeIsFinished() && event != Event.ACTION_STOP && !workflowExecuteThread.getProcessInstance().getState().typeIsStop()) {
            StateEvent stateEvent = new StateEvent();
            stateEvent.setProcessInstanceId(taskResponseEvent.getProcessInstanceId());
            stateEvent.setTaskInstanceId(taskResponseEvent.getTaskInstanceId());
            stateEvent.setExecutionStatus(taskResponseEvent.getState());
            stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
            workflowExecuteThread.addStateEvent(stateEvent);
        }
        return result;
    }

    public boolean addEvent(TaskResponseEvent event) {
        if (event.getProcessInstanceId() != this.processInstanceId.intValue()) {
            logger.info("event would be abounded, task instance id:{}, process instance id:{}, this.processInstanceId:{}", new Object[]{event.getTaskInstanceId(), event.getProcessInstanceId(), this.processInstanceId});
            return false;
        }
        return this.events.add(event);
    }

    public int eventSize() {
        return this.events.size();
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public Integer getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getKey() {
        return String.valueOf(this.processInstanceId);
    }
}

