/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskRecallAckCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.cache.ResponceCache;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRecallAckProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskRecallAckProcessor.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_RECALL_ACK == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskRecallAckCommand taskRecallAckCommand = (TaskRecallAckCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskRecallAckCommand.class);
        this.logger.info("taskRecallAckCommand:{}, opaque:{}", (Object)taskRecallAckCommand, (Object)command.getOpaque());
        if (taskRecallAckCommand == null) {
            return;
        }
        if (taskRecallAckCommand.getStatus() == ExecutionStatus.SUCCESS.getCode()) {
            Command recallCommand = ResponceCache.get().getRecallCache().get(taskRecallAckCommand.getTaskInstanceId());
            if (recallCommand != null && command.getOpaque() == recallCommand.getOpaque()) {
                ResponceCache.get().removeRecallCache(taskRecallAckCommand.getTaskInstanceId());
                this.logger.info("removeRecallCache: task instance id:{}", (Object)taskRecallAckCommand.getTaskInstanceId());
            }
            if (command.getOpaque() == TaskCallbackService.getOpaque(taskRecallAckCommand.getTaskInstanceId())) {
                TaskCallbackService.remove(taskRecallAckCommand.getTaskInstanceId());
                this.logger.info("remove REMOTE_CHANNELS, task instance id:{}", (Object)taskRecallAckCommand.getTaskInstanceId());
            }
        }
    }
}

