/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datax;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceClientProvider;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DatasourceUtil;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.datax.DataxParameters;
import org.apache.dolphinscheduler.plugin.task.datax.DataxUtils;
import org.apache.dolphinscheduler.plugin.task.util.MapUtils;
import org.apache.dolphinscheduler.plugin.task.util.OSUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.enums.Flag;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.Property;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.DataxTaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class DataxTask
extends AbstractTaskExecutor {
    public static final String JVM_PARAM = " --jvm=\"-Xms%sG -Xmx%sG\" ";
    private static final String DATAX_PYTHON = "python2.7";
    private static final Pattern PYTHON_PATH_PATTERN = Pattern.compile("/bin/python[\\d.]*$");
    private static final String DATAX_PATH = "${DATAX_HOME}/bin/datax.py";
    private static final int DATAX_CHANNEL_COUNT = 1;
    private DataxParameters dataXParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskRequest taskExecutionContext;

    public DataxTask(TaskRequest taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((DataxTask)this).logHandle(arg_0), taskExecutionContext, this.logger);
    }

    public void init() {
        this.logger.info("datax task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.dataXParameters = (DataxParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), DataxParameters.class));
        if (!this.dataXParameters.checkParameters()) {
            throw new RuntimeException("datax task params is not valid");
        }
    }

    public void handle() throws Exception {
        try {
            HashMap<String, Property> paramsMap = ParamUtils.convert((TaskRequest)this.taskExecutionContext, (AbstractParameters)this.getParameters());
            if (MapUtils.isEmpty((Map)paramsMap)) {
                paramsMap = new HashMap<String, Property>();
            }
            if (MapUtils.isNotEmpty((Map)this.taskExecutionContext.getParamsMap())) {
                paramsMap.putAll(this.taskExecutionContext.getParamsMap());
            }
            String jsonFilePath = this.buildDataxJsonFile(paramsMap);
            String shellCommandFilePath = this.buildShellCommandFile(jsonFilePath, paramsMap);
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(shellCommandFilePath);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(commandExecuteResult.getAppIds());
            this.setProcessId(commandExecuteResult.getProcessId());
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            throw e;
        }
    }

    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.shellCommandExecutor.cancelApplication();
    }

    private String buildDataxJsonFile(Map<String, Property> paramsMap) throws Exception {
        String json;
        String fileName = String.format("%s/%s_job.json", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId());
        Path path = new File(fileName).toPath();
        if (Files.exists(path, new LinkOption[0])) {
            return fileName;
        }
        if (this.dataXParameters.getCustomConfig() == Flag.YES.ordinal()) {
            json = this.dataXParameters.getJson().replaceAll("\\r\\n", "\n");
        } else {
            ObjectNode job = JSONUtils.createObjectNode();
            job.putArray("content").addAll(this.buildDataxJobContentJson());
            job.set("setting", (JsonNode)this.buildDataxJobSettingJson());
            ObjectNode root = JSONUtils.createObjectNode();
            root.set("job", (JsonNode)job);
            root.set("core", (JsonNode)this.buildDataxCoreJson());
            json = root.toString();
        }
        json = ParameterUtils.convertParameterPlaceholders((String)json, (Map)ParamUtils.convert(paramsMap));
        this.logger.debug("datax job json : {}", (Object)json);
        FileUtils.writeStringToFile((File)new File(fileName), (String)json, (Charset)StandardCharsets.UTF_8);
        return fileName;
    }

    private List<ObjectNode> buildDataxJobContentJson() {
        DataxTaskExecutionContext dataxTaskExecutionContext = this.taskExecutionContext.getDataxTaskExecutionContext();
        BaseConnectionParam dataSourceCfg = (BaseConnectionParam)DatasourceUtil.buildConnectionParams((DbType)DbType.of((int)dataxTaskExecutionContext.getSourcetype()), (String)dataxTaskExecutionContext.getSourceConnectionParams());
        BaseConnectionParam dataTargetCfg = (BaseConnectionParam)DatasourceUtil.buildConnectionParams((DbType)DbType.of((int)dataxTaskExecutionContext.getTargetType()), (String)dataxTaskExecutionContext.getTargetConnectionParams());
        ArrayList<ObjectNode> readerConnArr = new ArrayList<ObjectNode>();
        ObjectNode readerConn = JSONUtils.createObjectNode();
        ArrayNode sqlArr = readerConn.putArray("querySql");
        for (String sql : new String[]{this.dataXParameters.getSql()}) {
            sqlArr.add(sql);
        }
        ArrayNode urlArr = readerConn.putArray("jdbcUrl");
        urlArr.add(DatasourceUtil.getJdbcUrl((DbType)DbType.valueOf((String)this.dataXParameters.getDsType()), (ConnectionParam)dataSourceCfg));
        readerConnArr.add(readerConn);
        ObjectNode readerParam = JSONUtils.createObjectNode();
        readerParam.put("username", dataSourceCfg.getUser());
        readerParam.put("password", PasswordUtils.decodePassword((String)dataSourceCfg.getPassword()));
        readerParam.putArray("connection").addAll(readerConnArr);
        ObjectNode reader = JSONUtils.createObjectNode();
        reader.put("name", DataxUtils.getReaderPluginName(DbType.of((int)dataxTaskExecutionContext.getSourcetype())));
        reader.set("parameter", (JsonNode)readerParam);
        ArrayList<ObjectNode> writerConnArr = new ArrayList<ObjectNode>();
        ObjectNode writerConn = JSONUtils.createObjectNode();
        ArrayNode tableArr = writerConn.putArray("table");
        tableArr.add(this.dataXParameters.getTargetTable());
        writerConn.put("jdbcUrl", DatasourceUtil.getJdbcUrl((DbType)DbType.valueOf((String)this.dataXParameters.getDtType()), (ConnectionParam)dataTargetCfg));
        writerConnArr.add(writerConn);
        ObjectNode writerParam = JSONUtils.createObjectNode();
        writerParam.put("username", dataTargetCfg.getUser());
        writerParam.put("password", PasswordUtils.decodePassword((String)dataTargetCfg.getPassword()));
        String[] columns = this.parsingSqlColumnNames(DbType.of((int)dataxTaskExecutionContext.getSourcetype()), DbType.of((int)dataxTaskExecutionContext.getTargetType()), dataSourceCfg, this.dataXParameters.getSql());
        ArrayNode columnArr = writerParam.putArray("column");
        for (String column : columns) {
            columnArr.add(column);
        }
        writerParam.putArray("connection").addAll(writerConnArr);
        if (CollectionUtils.isNotEmpty(this.dataXParameters.getPreStatements())) {
            ArrayNode preSqlArr = writerParam.putArray("preSql");
            for (String preSql : this.dataXParameters.getPreStatements()) {
                preSqlArr.add(preSql);
            }
        }
        if (CollectionUtils.isNotEmpty(this.dataXParameters.getPostStatements())) {
            ArrayNode postSqlArr = writerParam.putArray("postSql");
            for (String postSql : this.dataXParameters.getPostStatements()) {
                postSqlArr.add(postSql);
            }
        }
        ObjectNode writer = JSONUtils.createObjectNode();
        writer.put("name", DataxUtils.getWriterPluginName(DbType.of((int)dataxTaskExecutionContext.getTargetType())));
        writer.set("parameter", (JsonNode)writerParam);
        ArrayList<ObjectNode> contentList = new ArrayList<ObjectNode>();
        ObjectNode content = JSONUtils.createObjectNode();
        content.set("reader", (JsonNode)reader);
        content.set("writer", (JsonNode)writer);
        contentList.add(content);
        return contentList;
    }

    private ObjectNode buildDataxJobSettingJson() {
        ObjectNode speed = JSONUtils.createObjectNode();
        speed.put("channel", 1);
        if (this.dataXParameters.getJobSpeedByte() > 0) {
            speed.put("byte", this.dataXParameters.getJobSpeedByte());
        }
        if (this.dataXParameters.getJobSpeedRecord() > 0) {
            speed.put("record", this.dataXParameters.getJobSpeedRecord());
        }
        ObjectNode errorLimit = JSONUtils.createObjectNode();
        errorLimit.put("record", 0);
        errorLimit.put("percentage", 0);
        ObjectNode setting = JSONUtils.createObjectNode();
        setting.set("speed", (JsonNode)speed);
        setting.set("errorLimit", (JsonNode)errorLimit);
        return setting;
    }

    private ObjectNode buildDataxCoreJson() {
        ObjectNode speed = JSONUtils.createObjectNode();
        speed.put("channel", 1);
        if (this.dataXParameters.getJobSpeedByte() > 0) {
            speed.put("byte", this.dataXParameters.getJobSpeedByte());
        }
        if (this.dataXParameters.getJobSpeedRecord() > 0) {
            speed.put("record", this.dataXParameters.getJobSpeedRecord());
        }
        ObjectNode channel = JSONUtils.createObjectNode();
        channel.set("speed", (JsonNode)speed);
        ObjectNode transport = JSONUtils.createObjectNode();
        transport.set("channel", (JsonNode)channel);
        ObjectNode core = JSONUtils.createObjectNode();
        core.set("transport", (JsonNode)transport);
        return core;
    }

    private String buildShellCommandFile(String jobConfigFilePath, Map<String, Property> paramsMap) throws Exception {
        String fileName = String.format("%s/%s_node.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), OSUtils.isWindows() ? "bat" : "sh");
        Path path = new File(fileName).toPath();
        if (Files.exists(path, new LinkOption[0])) {
            return fileName;
        }
        StringBuilder sbr = new StringBuilder();
        sbr.append(this.getPythonCommand());
        sbr.append(" ");
        sbr.append(DATAX_PATH);
        sbr.append(" ");
        sbr.append(this.loadJvmEnv(this.dataXParameters));
        sbr.append(jobConfigFilePath);
        String dataxCommand = ParameterUtils.convertParameterPlaceholders((String)sbr.toString(), (Map)ParamUtils.convert(paramsMap));
        this.logger.debug("raw script : {}", (Object)dataxCommand);
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        if (OSUtils.isWindows()) {
            Files.createFile(path, new FileAttribute[0]);
        } else {
            Files.createFile(path, attr);
        }
        Files.write(path, dataxCommand.getBytes(), StandardOpenOption.APPEND);
        return fileName;
    }

    public String getPythonCommand() {
        String pythonHome = System.getenv("PYTHON_HOME");
        return this.getPythonCommand(pythonHome);
    }

    public String getPythonCommand(String pythonHome) {
        if (StringUtils.isEmpty((CharSequence)pythonHome)) {
            return DATAX_PYTHON;
        }
        String pythonBinPath = "/bin/python2.7";
        Matcher matcher = PYTHON_PATH_PATTERN.matcher(pythonHome);
        if (matcher.find()) {
            return matcher.replaceAll(pythonBinPath);
        }
        return Paths.get(pythonHome, pythonBinPath).toString();
    }

    public String loadJvmEnv(DataxParameters dataXParameters) {
        int xms = Math.max(dataXParameters.getXms(), 1);
        int xmx = Math.max(dataXParameters.getXmx(), 1);
        return String.format(JVM_PARAM, xms, xmx);
    }

    private String[] parsingSqlColumnNames(DbType sourceType, DbType targetType, BaseConnectionParam dataSourceCfg, String sql) {
        String[] columnNames = this.tryGrammaticalAnalysisSqlColumnNames(sourceType, sql);
        if (columnNames == null || columnNames.length == 0) {
            this.logger.info("try to execute sql analysis query column name");
            columnNames = this.tryExecuteSqlResolveColumnNames(sourceType, dataSourceCfg, sql);
        }
        this.notNull(columnNames, String.format("parsing sql columns failed : %s", sql));
        return DataxUtils.convertKeywordsColumns(targetType, columnNames);
    }

    private String[] tryGrammaticalAnalysisSqlColumnNames(DbType dbType, String sql) {
        String[] columnNames;
        try {
            SQLStatementParser parser = DataxUtils.getSqlStatementParser(dbType, sql);
            if (parser == null) {
                this.logger.warn("database driver [{}] is not support grammatical analysis sql", (Object)dbType);
                return new String[0];
            }
            SQLStatement sqlStatement = parser.parseStatement();
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
            SQLSelect sqlSelect = sqlSelectStatement.getSelect();
            List selectItemList = null;
            if (sqlSelect.getQuery() instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock block = (SQLSelectQueryBlock)sqlSelect.getQuery();
                selectItemList = block.getSelectList();
            } else if (sqlSelect.getQuery() instanceof SQLUnionQuery) {
                SQLUnionQuery unionQuery = (SQLUnionQuery)sqlSelect.getQuery();
                SQLSelectQueryBlock block = (SQLSelectQueryBlock)unionQuery.getRight();
                selectItemList = block.getSelectList();
            }
            this.notNull(selectItemList, String.format("select query type [%s] is not support", sqlSelect.getQuery().toString()));
            columnNames = new String[selectItemList.size()];
            for (int i = 0; i < selectItemList.size(); ++i) {
                SQLSelectItem item = (SQLSelectItem)selectItemList.get(i);
                String columnName = null;
                if (item.getAlias() != null) {
                    columnName = item.getAlias();
                } else if (item.getExpr() != null) {
                    SQLPropertyExpr expr;
                    if (item.getExpr() instanceof SQLPropertyExpr) {
                        expr = (SQLPropertyExpr)item.getExpr();
                        columnName = expr.getName();
                    } else if (item.getExpr() instanceof SQLIdentifierExpr) {
                        expr = (SQLIdentifierExpr)item.getExpr();
                        columnName = expr.getName();
                    }
                } else {
                    throw new RuntimeException(String.format("grammatical analysis sql column [ %s ] failed", item.toString()));
                }
                if (columnName == null) {
                    throw new RuntimeException(String.format("grammatical analysis sql column [ %s ] failed", item.toString()));
                }
                columnNames[i] = columnName;
            }
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return new String[0];
        }
        return columnNames;
    }

    public String[] tryExecuteSqlResolveColumnNames(DbType sourceType, BaseConnectionParam baseDataSource, String sql) {
        String[] columnNames;
        sql = String.format("SELECT t.* FROM ( %s ) t WHERE 0 = 1", sql);
        sql = sql.replace(";", "");
        try (Connection connection = DataSourceClientProvider.getInstance().getConnection(sourceType, (ConnectionParam)baseDataSource);
             PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet resultSet = stmt.executeQuery();){
            ResultSetMetaData md = resultSet.getMetaData();
            int num = md.getColumnCount();
            columnNames = new String[num];
            for (int i = 1; i <= num; ++i) {
                columnNames[i - 1] = md.getColumnName(i);
            }
        }
        catch (SQLException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        return columnNames;
    }

    public AbstractParameters getParameters() {
        return this.dataXParameters;
    }

    private void notNull(Object obj, String message) {
        if (obj == null) {
            throw new RuntimeException(message);
        }
    }
}

