/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.AbstractShell;

public class ShellExecutor
extends AbstractShell {
    private String[] command;
    private StringBuilder output;

    public ShellExecutor(String ... execString) {
        this(execString, (File)null);
    }

    public ShellExecutor(String[] execString, File dir) {
        this(execString, dir, null);
    }

    public ShellExecutor(String[] execString, File dir, Map<String, String> env) {
        this(execString, dir, env, 0L);
    }

    public ShellExecutor(String[] execString, File dir, Map<String, String> env, long timeout) {
        this.command = (String[])execString.clone();
        if (dir != null) {
            this.setWorkingDirectory(dir);
        }
        if (env != null) {
            this.setEnvironment(env);
        }
        this.timeOutInterval = timeout;
    }

    public static String execCommand(String ... cmd) throws IOException {
        return ShellExecutor.execCommand(null, cmd, 0L);
    }

    public static String execCommand(Map<String, String> env, String[] cmd, long timeout) throws IOException {
        ShellExecutor exec = new ShellExecutor(cmd, null, env, timeout);
        exec.execute();
        return exec.getOutput();
    }

    public static String execCommand(Map<String, String> env, String ... cmd) throws IOException {
        return ShellExecutor.execCommand(env, cmd, 0L);
    }

    public void execute() throws IOException {
        this.run();
    }

    @Override
    protected String[] getExecString() {
        return this.command;
    }

    @Override
    protected void parseExecResult(BufferedReader lines) throws IOException {
        int nRead;
        this.output = new StringBuilder();
        char[] buf = new char[1024];
        String line = "";
        while ((nRead = lines.read(buf, 0, buf.length)) > 0) {
            line = new String(buf, 0, nRead);
            this.output.append(line);
        }
    }

    public String getOutput() {
        return this.output == null ? "" : this.output.toString();
    }

    public String toString() {
        String[] args;
        StringBuilder builder = new StringBuilder();
        for (String s : args = this.getExecString()) {
            if (s.indexOf(32) >= 0) {
                builder.append('\"').append(s).append('\"');
            } else {
                builder.append(s);
            }
            builder.append(' ');
        }
        return builder.toString();
    }
}

