/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.flink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkArgsUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.plugin.task.util.MapUtils;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.ResourceInfo;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class FlinkTask
extends AbstractYarnTask {
    private static final String FLINK_COMMAND = "flink";
    private static final String FLINK_RUN = "run";
    private FlinkParameters flinkParameters;
    private TaskRequest taskExecutionContext;

    public FlinkTask(TaskRequest taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("flink task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.flinkParameters = (FlinkParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), FlinkParameters.class));
        if (this.flinkParameters == null || !this.flinkParameters.checkParameters()) {
            throw new RuntimeException("flink task params is not valid");
        }
        this.flinkParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        if (StringUtils.isNotEmpty((CharSequence)this.flinkParameters.getMainArgs())) {
            String args = this.flinkParameters.getMainArgs();
            HashMap paramsMap = ParamUtils.convert((TaskRequest)this.taskExecutionContext, (AbstractParameters)this.getParameters());
            if (MapUtils.isEmpty((Map)paramsMap)) {
                paramsMap = new HashMap();
            }
            if (MapUtils.isNotEmpty((Map)this.taskExecutionContext.getParamsMap())) {
                paramsMap.putAll(this.taskExecutionContext.getParamsMap());
            }
            this.logger.info("param Map : {}", paramsMap);
            args = ParameterUtils.convertParameterPlaceholders((String)args, (Map)ParamUtils.convert(paramsMap));
            this.logger.info("param args : {}", (Object)args);
            this.flinkParameters.setMainArgs(args);
        }
    }

    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(FLINK_COMMAND);
        args.add(FLINK_RUN);
        this.logger.info("flink task args : {}", args);
        args.addAll(FlinkArgsUtils.buildArgs(this.flinkParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)this.taskExecutionContext.getDefinedParams());
        this.logger.info("flink task command : {}", (Object)command);
        return command;
    }

    protected void setMainJarName() {
        ResourceInfo mainJar = this.flinkParameters.getMainJar();
        if (mainJar != null) {
            int resourceId = mainJar.getId();
            String resourceName = resourceId == 0 ? mainJar.getRes() : mainJar.getResourceName().replaceFirst("/", "");
            mainJar.setRes(resourceName);
            this.flinkParameters.setMainJar(mainJar);
        }
    }

    public AbstractParameters getParameters() {
        return this.flinkParameters;
    }
}

