/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.utils;

import java.io.Serializable;
import java.util.Objects;

public class Host
implements Serializable {
    private String address;
    private String ip;
    private int port;

    public Host() {
    }

    public Host(String ip, int port) {
        this.ip = ip;
        this.port = port;
        this.address = ip + ":" + port;
    }

    public Host(String address) {
        String[] parts = Host.splitAddress(address);
        this.ip = parts[0];
        this.port = Integer.parseInt(parts[1]);
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        String[] parts = Host.splitAddress(address);
        this.ip = parts[0];
        this.port = Integer.parseInt(parts[1]);
        this.address = address;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
        this.address = ip + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.address = this.ip + ":" + port;
    }

    public static Host of(String address) {
        String[] parts = Host.splitAddress(address);
        return new Host(parts[0], Integer.parseInt(parts[1]));
    }

    public static String[] splitAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("Host : address is null.");
        }
        String[] parts = address.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException(String.format("Host : %s illegal.", address));
        }
        return parts;
    }

    public static Boolean isOldVersion(String address) {
        String[] parts = address.split(":");
        return parts.length != 2;
    }

    public String toString() {
        return "Host{address='" + this.address + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        return this.port == host.port && Objects.equals(this.address, host.address) && Objects.equals(this.ip, host.ip);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.ip, this.port);
    }
}

