/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.dolphinscheduler.rpc.protocol.EventType;
import org.apache.dolphinscheduler.rpc.protocol.MessageHeader;
import org.apache.dolphinscheduler.rpc.protocol.RpcProtocol;
import org.apache.dolphinscheduler.rpc.serializer.RpcSerializer;
import org.apache.dolphinscheduler.rpc.serializer.Serializer;

public class NettyDecoder
extends ByteToMessageDecoder {
    private Class<?> genericClass;

    public NettyDecoder(Class<?> genericClass) {
        this.genericClass = genericClass;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() < 17) {
            return;
        }
        byteBuf.markReaderIndex();
        short magic = byteBuf.readShort();
        if (-17730 != magic) {
            throw new IllegalArgumentException("magic number is illegal, " + magic);
        }
        byte eventType = byteBuf.readByte();
        byte version = byteBuf.readByte();
        byte serialization = byteBuf.readByte();
        long requestId = byteBuf.readLong();
        int dataLength = byteBuf.readInt();
        byte[] data = new byte[dataLength];
        RpcProtocol rpcProtocol = new RpcProtocol();
        MessageHeader header = new MessageHeader();
        header.setVersion(version);
        header.setSerialization(serialization);
        header.setRequestId(requestId);
        header.setEventType(eventType);
        header.setMsgLength(dataLength);
        byteBuf.readBytes(data);
        rpcProtocol.setMsgHeader(header);
        if (eventType != EventType.HEARTBEAT.getType()) {
            Serializer serializer = RpcSerializer.getSerializerByType(serialization);
            Object obj = serializer.deserialize(data, this.genericClass);
            rpcProtocol.setBody(obj);
        }
        list.add(rpcProtocol);
    }
}

