/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.common.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.common.block.SingleRowBlock;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;

public class SingleRowBlockEncoding
implements BlockEncoding {
    public static final String NAME = "ROW_ELEMENT";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        SingleRowBlock singleRowBlock = (SingleRowBlock)block;
        int numFields = singleRowBlock.getNumFields();
        int rowIndex = singleRowBlock.getRowIndex();
        sliceOutput.appendInt(numFields);
        for (int i = 0; i < numFields; ++i) {
            blockEncodingSerde.writeBlock(sliceOutput, singleRowBlock.getRawFieldBlock(i).getRegion(rowIndex, 1));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int numFields = sliceInput.readInt();
        Block[] fieldBlocks = new Block[numFields];
        for (int i = 0; i < fieldBlocks.length; ++i) {
            fieldBlocks[i] = blockEncodingSerde.readBlock(sliceInput);
        }
        return new SingleRowBlock(0, fieldBlocks);
    }
}

