/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.ConstantProperty;
import com.facebook.presto.jdbc.internal.spi.LocalProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class GroupingProperty<E>
implements LocalProperty<E> {
    private final Set<E> columns;

    @JsonCreator
    public GroupingProperty(@JsonProperty(value="columns") Collection<E> columns) {
        Objects.requireNonNull(columns, "columns is null");
        this.columns = Collections.unmodifiableSet(new LinkedHashSet<E>(columns));
    }

    @Override
    public boolean isOrderSensitive() {
        return true;
    }

    @Override
    @JsonProperty
    public Set<E> getColumns() {
        return this.columns;
    }

    @Override
    public LocalProperty<E> constrain(Set<E> columns) {
        if (!this.columns.containsAll(columns)) {
            throw new IllegalArgumentException(String.format("Cannot constrain %s with %s", this, columns));
        }
        return new GroupingProperty<E>(columns);
    }

    @Override
    public boolean isSimplifiedBy(LocalProperty<E> known) {
        return known instanceof ConstantProperty || this.getColumns().containsAll(known.getColumns());
    }

    @Override
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> translator) {
        Set translated = this.columns.stream().map(translator).collect(Collectors.toCollection(LinkedHashSet::new));
        if (translated.stream().allMatch(Optional::isPresent)) {
            Set columns = translated.stream().map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
            return Optional.of(new GroupingProperty<E>(columns));
        }
        return Optional.empty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("G(");
        builder.append(this.columns.stream().map(Object::toString).collect(Collectors.joining(", ")));
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingProperty that = (GroupingProperty)o;
        return Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.columns);
    }
}

