/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.resources;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.spi.enums.ResourceType;

@JsonPropertyOrder(value={"id", "pid", "name", "fullName", "description", "isDirctory", "children", "type"})
public abstract class ResourceComponent {
    protected int id;
    protected int pid;
    protected String name;
    protected String currentDir;
    protected String fullName;
    protected String description;
    protected boolean isDirctory;
    protected String idValue;
    protected ResourceType type;
    protected List<ResourceComponent> children = new ArrayList<ResourceComponent>();

    public ResourceComponent() {
    }

    public ResourceComponent(int id, int pid, String name, String fullName, String description, boolean isDirctory) {
        this.id = id;
        this.pid = pid;
        this.name = name;
        this.fullName = fullName;
        this.description = description;
        this.isDirctory = isDirctory;
        int directoryFlag = isDirctory ? 1 : 0;
        this.idValue = String.format("%s_%s", id, directoryFlag);
    }

    public void add(ResourceComponent resourceComponent) {
        this.children.add(resourceComponent);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDirctory() {
        return this.isDirctory;
    }

    public void setDirctory(boolean dirctory) {
        this.isDirctory = dirctory;
    }

    public String getIdValue() {
        return this.idValue;
    }

    public void setIdValue(int id, boolean isDirctory) {
        int directoryFlag = isDirctory ? 1 : 0;
        this.idValue = String.format("%s_%s", id, directoryFlag);
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public List<ResourceComponent> getChildren() {
        return this.children;
    }

    public void setChildren(List<ResourceComponent> children) {
        this.children = children;
    }

    public String toString() {
        return "ResourceComponent{id=" + this.id + ", pid=" + this.pid + ", name='" + this.name + '\'' + ", currentDir='" + this.currentDir + '\'' + ", fullName='" + this.fullName + '\'' + ", description='" + this.description + '\'' + ", isDirctory=" + this.isDirctory + ", idValue='" + this.idValue + '\'' + ", type=" + this.type + ", children=" + this.children + '}';
    }
}

