/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.interceptor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.configuration.TrafficConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

public class RateLimitInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RateLimitInterceptor.class);
    private TrafficConfiguration trafficConfiguration;
    private RateLimiter globalRateLimiter;
    private LoadingCache<String, RateLimiter> tenantRateLimiterCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RateLimiter>(){

        public RateLimiter load(String token) {
            Map<String, Integer> customizeTenantQpsRate = RateLimitInterceptor.this.trafficConfiguration.getCustomizeTenantQpsRate();
            int tenantQuota = RateLimitInterceptor.this.trafficConfiguration.getDefaultTenantQpsRate();
            if (MapUtils.isNotEmpty(customizeTenantQpsRate)) {
                tenantQuota = customizeTenantQpsRate.getOrDefault(token, RateLimitInterceptor.this.trafficConfiguration.getDefaultTenantQpsRate());
            }
            return RateLimiter.create((double)tenantQuota, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    });

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ExecutionException {
        RateLimiter tenantRateLimiter;
        String token;
        if (this.trafficConfiguration.isTrafficTenantControlSwitch() && !StringUtils.isEmpty((String)(token = request.getHeader("token"))) && !(tenantRateLimiter = (RateLimiter)this.tenantRateLimiterCache.get((Object)token)).tryAcquire()) {
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            logger.warn("Too many request, reach tenant rate limit, current tenant:{} qps is {}", (Object)token, (Object)tenantRateLimiter.getRate());
            return false;
        }
        if (this.trafficConfiguration.isTrafficGlobalControlSwitch() && !this.globalRateLimiter.tryAcquire()) {
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            logger.warn("Too many request, reach global rate limit, current qps is {}", (Object)this.globalRateLimiter.getRate());
            return false;
        }
        return true;
    }

    public RateLimitInterceptor(TrafficConfiguration trafficConfiguration) {
        this.trafficConfiguration = trafficConfiguration;
        if (trafficConfiguration.isTrafficGlobalControlSwitch()) {
            this.globalRateLimiter = RateLimiter.create((double)trafficConfiguration.getMaxGlobalQpsRate().intValue(), (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

