/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.queue;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;

public class MasterPriorityQueue
implements TaskPriorityQueue<Server> {
    private static final Integer QUEUE_MAX_SIZE = 20;
    private PriorityBlockingQueue<Server> queue = new PriorityBlockingQueue<Server>(QUEUE_MAX_SIZE, new ServerComparator());
    private HashMap<String, Integer> hostIndexMap = new HashMap();

    @Override
    public void put(Server serverInfo) {
        this.queue.put(serverInfo);
        this.refreshMasterList();
    }

    @Override
    public Server take() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public Server poll(long timeout, TimeUnit unit) {
        return this.queue.poll();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public void putList(List<Server> serverList) {
        for (Server server : serverList) {
            this.queue.put(server);
        }
        this.refreshMasterList();
    }

    public void remove(Server server) {
        this.queue.remove(server);
    }

    public void clear() {
        this.queue.clear();
        this.refreshMasterList();
    }

    private void refreshMasterList() {
        this.hostIndexMap.clear();
        Iterator<Server> iterator = this.queue.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Server server = iterator.next();
            this.hostIndexMap.put(server.getHost(), index);
            ++index;
        }
    }

    public int getIndex(String host) {
        if (!this.hostIndexMap.containsKey(host)) {
            return -1;
        }
        return this.hostIndexMap.get(host);
    }

    private class ServerComparator
    implements Comparator<Server> {
        private ServerComparator() {
        }

        @Override
        public int compare(Server o1, Server o2) {
            return o1.getCreateTime().before(o2.getCreateTime()) ? 1 : 0;
        }
    }
}

