/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDao {
    public static final Logger logger = LoggerFactory.getLogger(ResourceDao.class);

    Map<String, Integer> listAllResources(Connection conn) {
        HashMap<String, Integer> resourceMap = new HashMap<String, Integer>();
        String sql = String.format("SELECT id,full_name FROM t_ds_resources", new Object[0]);
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String fullName = rs.getString(2);
                resourceMap.put(fullName, id);
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return resourceMap;
    }

    private Map<String, Long> listAllResourcesByFileType(Connection conn, int type) {
        HashMap<String, Long> resourceSizeMap = new HashMap<String, Long>();
        String sql = String.format("SELECT full_name, type, size, is_directory FROM t_ds_resources where type = %d", type);
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String fullName = rs.getString("full_name");
                Boolean isDirectory = rs.getBoolean("is_directory");
                long fileSize = rs.getLong("size");
                if (!StringUtils.isNotBlank((CharSequence)fullName) || isDirectory.booleanValue()) continue;
                String[] splits = fullName.split("/");
                for (int i = 1; i < splits.length; ++i) {
                    String parentFullName = Joiner.on((String)"/").join((Object[])Arrays.copyOfRange(splits, 0, splits.length - i));
                    if (!StringUtils.isNotEmpty((CharSequence)parentFullName)) continue;
                    long size = resourceSizeMap.getOrDefault(parentFullName, 0L);
                    resourceSizeMap.put(parentFullName, size + fileSize);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("sql: " + sql, e);
        }
        finally {
            if (Objects.nonNull(pstmt)) {
                try {
                    if (!pstmt.isClosed()) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return resourceSizeMap;
    }

    public void updateResourceFolderSizeByFileType(Connection conn, int type) {
        Map<String, Long> resourceSizeMap = this.listAllResourcesByFileType(conn, type);
        String sql = "UPDATE t_ds_resources SET size=? where type=? and full_name=? and is_directory = true";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Map.Entry<String, Long> entry : resourceSizeMap.entrySet()) {
                pstmt.setLong(1, entry.getValue());
                pstmt.setInt(2, type);
                pstmt.setString(3, entry.getKey());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(pstmt)) {
                    try {
                        if (!pstmt.isClosed()) {
                            pstmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                    }
                }
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        if (Objects.nonNull(pstmt)) {
            try {
                if (!pstmt.isClosed()) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
    }
}

