/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.feishu;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.plugin.alert.feishu.HttpRequestUtil;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeiShuSender {
    private static final Logger log = LoggerFactory.getLogger(FeiShuSender.class);
    private final String url;
    private final Boolean enableProxy;
    private String proxy;
    private Integer port;
    private String user;
    private String password;

    FeiShuSender(Map<String, String> config) {
        this.url = config.get("webHook");
        this.enableProxy = Boolean.valueOf(config.get("isEnableProxy"));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            this.port = Integer.parseInt(config.get("port"));
            this.proxy = config.get("proxy");
            this.user = config.get("user");
            this.password = config.get("password");
        }
    }

    private static String textToJsonString(AlertData alertData) {
        HashMap<String, Object> items = new HashMap<String, Object>(2);
        items.put("msg_type", "text");
        HashMap<String, String> textContent = new HashMap<String, String>();
        byte[] byt = org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)FeiShuSender.formatContent(alertData));
        String txt = org.apache.commons.codec.binary.StringUtils.newStringUtf8((byte[])byt);
        textContent.put("text", txt);
        items.put("content", textContent);
        return JSONUtils.toJsonString(items);
    }

    public static AlertResult checkSendFeiShuSendMsgResult(String result) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        if (StringUtils.isBlank((CharSequence)result)) {
            alertResult.setMessage("send fei shu msg error");
            log.info("send fei shu msg error,fei shu server resp is null");
            return alertResult;
        }
        FeiShuSendMsgResponse sendMsgResponse = (FeiShuSendMsgResponse)JSONUtils.parseObject((String)result, FeiShuSendMsgResponse.class);
        if (null == sendMsgResponse) {
            alertResult.setMessage("send fei shu msg fail");
            log.info("send fei shu msg error,resp error");
            return alertResult;
        }
        if (sendMsgResponse.statusCode == 0) {
            alertResult.setStatus("true");
            alertResult.setMessage("send fei shu msg success");
            return alertResult;
        }
        alertResult.setMessage(String.format("alert send fei shu msg error : %s", sendMsgResponse.getStatusMessage()));
        log.info("alert send fei shu msg error : {} ,Extra : {} ", (Object)sendMsgResponse.getStatusMessage(), (Object)sendMsgResponse.getExtra());
        return alertResult;
    }

    public static String formatContent(AlertData alertData) {
        if (alertData.getContent() != null) {
            List list = JSONUtils.toList((String)alertData.getContent(), Map.class);
            if (list.isEmpty()) {
                return alertData.getTitle() + alertData.getContent();
            }
            StringBuilder contents = new StringBuilder(100);
            contents.append(String.format("`%s`%n", alertData.getTitle()));
            for (Map map : list) {
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = entry.getValue().toString();
                    contents.append(key + ":" + value);
                    contents.append("\n");
                }
            }
            return contents.toString();
        }
        return null;
    }

    public AlertResult sendFeiShuMsg(AlertData alertData) {
        try {
            String resp = this.sendMsg(alertData);
            return FeiShuSender.checkSendFeiShuSendMsgResult(resp);
        }
        catch (Exception e) {
            log.info("send fei shu alert msg  exception : {}", (Object)e.getMessage());
            AlertResult alertResult = new AlertResult();
            alertResult.setStatus("false");
            alertResult.setMessage("send fei shu alert fail.");
            return alertResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMsg(AlertData alertData) throws IOException {
        String msgToJson = FeiShuSender.textToJsonString(alertData);
        HttpPost httpPost = HttpRequestUtil.constructHttpPost(this.url, msgToJson);
        try (CloseableHttpClient httpClient = HttpRequestUtil.getHttpClient(this.enableProxy, this.proxy, this.port, this.user, this.password);){
            String resp;
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("send feishu message error, return http status code: {} ", (Object)statusCode);
            }
            try {
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            finally {
                response.close();
            }
            log.info("Fei Shu send title :{} ,content :{}, resp: {}", new Object[]{alertData.getTitle(), alertData.getContent(), resp});
            String string = resp;
            return string;
        }
    }

    static final class FeiShuSendMsgResponse {
        @JsonProperty(value="Extra")
        private String extra;
        @JsonProperty(value="StatusCode")
        private Integer statusCode;
        @JsonProperty(value="StatusMessage")
        private String statusMessage;

        public String getExtra() {
            return this.extra;
        }

        @JsonProperty(value="Extra")
        public void setExtra(String extra) {
            this.extra = extra;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        @JsonProperty(value="StatusCode")
        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        @JsonProperty(value="StatusMessage")
        public void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeiShuSendMsgResponse)) {
                return false;
            }
            FeiShuSendMsgResponse other = (FeiShuSendMsgResponse)o;
            String this$extra = this.getExtra();
            String other$extra = other.getExtra();
            if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
                return false;
            }
            Integer this$statusCode = this.getStatusCode();
            Integer other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
                return false;
            }
            String this$statusMessage = this.getStatusMessage();
            String other$statusMessage = other.getStatusMessage();
            return !(this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $extra = this.getExtra();
            result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
            Integer $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
            String $statusMessage = this.getStatusMessage();
            result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
            return result;
        }

        public String toString() {
            return "FeiShuSender.FeiShuSendMsgResponse(extra=" + this.getExtra() + ", statusCode=" + this.getStatusCode() + ", statusMessage=" + this.getStatusMessage() + ")";
        }
    }
}

