/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.slack;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.plugin.alert.slack.SlackParamsConstants;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlackSender {
    private static final Logger log = LoggerFactory.getLogger(SlackSender.class);
    private final String webHookUrl;
    private final String botName;

    public SlackSender(Map<String, String> slackAlertParam) {
        this.webHookUrl = slackAlertParam.get("WebHook");
        this.botName = slackAlertParam.get("username");
        Preconditions.checkArgument((!Objects.isNull(this.webHookUrl) ? 1 : 0) != 0, (Object)"SlackWebHookURL can not be null");
        Preconditions.checkArgument((boolean)this.webHookUrl.startsWith("https://hooks.slack.com/services/"), (Object)"SlackWebHookURL invalidate");
        Preconditions.checkArgument((!Objects.isNull(this.botName) ? 1 : 0) != 0, (Object)"slack bot name can not be null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendMessage(String title, String content) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("username", this.botName);
            paramMap.put("text", title);
            if (StringUtils.isNotEmpty((CharSequence)content)) {
                HashMap<String, String> attachmentTable = new HashMap<String, String>();
                attachmentTable.put("text", this.generateMarkDownTable(content));
                ArrayList<HashMap<String, String>> attachments = new ArrayList<HashMap<String, String>>();
                attachments.add(attachmentTable);
                paramMap.put("attachments", attachments);
            }
            HttpPost httpPost = new HttpPost(this.webHookUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(JSONUtils.toJsonString(paramMap), "UTF-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            log.error("Send message to slack error.", (Throwable)e);
            return "System Exception";
        }
    }

    private String generateMarkDownTable(String content) {
        List linkedHashMaps = JSONUtils.toList((String)content, LinkedHashMap.class);
        if (linkedHashMaps.size() > SlackParamsConstants.MAX_SHOW_NUMBER) {
            linkedHashMaps = linkedHashMaps.subList(0, SlackParamsConstants.MAX_SHOW_NUMBER);
        }
        int maxLen = 0;
        LinkedList headers = new LinkedList();
        LinkedHashMap tmp = (LinkedHashMap)linkedHashMaps.get(0);
        for (Map.Entry entry : tmp.entrySet()) {
            maxLen = Math.max(maxLen, ((String)entry.getKey()).length());
            headers.add(entry.getKey());
        }
        ArrayList elements = new ArrayList(tmp.size());
        for (LinkedHashMap linkedHashMap : linkedHashMaps) {
            ArrayList<String> element = new ArrayList<String>(linkedHashMap.size());
            for (Object value : linkedHashMap.values()) {
                String valueStr = value.toString();
                maxLen = Math.max(maxLen, valueStr.length());
                element.add(valueStr);
            }
            elements.add(element);
        }
        int n = maxLen;
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(headers.stream().map(header -> this.generateString((String)header, elementLen, " ")).collect(Collectors.joining("|")));
        stringBuilder.append("\n");
        for (List list : elements) {
            stringBuilder.append(list.stream().map(lement -> this.generateString("", elementLen, "-")).collect(Collectors.joining("|")));
            stringBuilder.append("\n");
            stringBuilder.append(list.stream().map(e -> this.generateString((String)e, elementLen, " ")).collect(Collectors.joining("|")));
            stringBuilder.append("\n");
        }
        return String.format("```%s```", stringBuilder);
    }

    private String generateString(String value, int len, String supplement) {
        StringBuilder stringBuilder = new StringBuilder(len);
        stringBuilder.append(value);
        for (int i = 0; i < len - stringBuilder.length(); ++i) {
            stringBuilder.append(supplement);
        }
        return stringBuilder.toString();
    }
}

