/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
export default {
    'en-us': {
        sidemenu: [
            {
                title: 'About',
                children: [
                    {
                        title: 'Introduction',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/about/introduction.html',
                    },
                    {
                        title: 'Features',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/about/features.html',
                    },
                    {
                        title: 'Hardware Environment',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/about/hardware.html',
                    },
                    {
                        title: 'Glossary',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/about/glossary.html',
                    }
                ],
            },
            {
                title: 'Quick Start',
                children: [
                    {
                        title: 'Quick Start',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/start/quick-start.html',
                    },
                    {
                        title: 'Docker Deployment',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/start/docker.html',
                    },
                ],
            },
            {
                title: 'Introduction to Functions',
                children: [
                    {
                        title: 'Application Homepage',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/homepage.html',
                    },
                    {
                        title: 'Project',
                        children: [
                            {
                                title: 'Project List',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/project/project-list.html',
                            },
                            {
                                title: 'Workflow Definition',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/project/workflow-definition.html',
                            },
                            {
                                title: 'Workflow Instance',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/project/workflow-instance.html',
                            },
                            {
                                title: 'Task Instance',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/project/task-instance.html',
                            },
                            {
                                title: 'Task Definition',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/project/task-definition.html',
                            },
                        ]
                    },
                    {
                        title: 'Task',
                        children: [
                            {
                                title: 'Appendix',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/appendix.html',
                            },
                            {
                                title: 'Shell',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/shell.html',
                            },
                            {
                                title: 'SubWorkflow',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/sub-workflow.html',
                            },
                            {
                                title: 'Dependent',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/dependent.html',
                            },
                            {
                                title: 'Stored Procedure',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/stored-procedure.html',
                            },
                            {
                                title: 'SQL',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/sql.html',
                            },
                            {
                                title: 'Spark',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/spark.html',
                            },
                            {
                                title: 'MapReduce',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/map-reduce.html',
                            },
                            {
                                title: 'Python',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/python.html',
                            },
                            {
                                title: 'Flink',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/flink.html',
                            },
                            {
                                title: 'HTTP',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/http.html',
                            },
                            {
                                title: 'DataX',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/datax.html',
                            },
                            {
                                title: 'Sqoop',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/sqoop.html',
                            },
                            {
                                title: 'Conditions',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/conditions.html',
                            },
                            {
                                title: 'Switch',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/switch.html',
                            },
                            {
                                title: 'SeaTunnel',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/seatunnel.html',
                            },
                            {
                                title: 'Amazon EMR',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/emr.html',
                            },
                            {
                                title: 'Apache Zeppelin',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/zeppelin.html',
                            },
                            {
                                title: 'Jupyter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/jupyter.html',
                            },
                            {
                                title: 'Hive CLI',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/hive-cli.html',
                            },
                            {
                                title: 'Kubernetes',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/kubernetes.html',
                            },
                            {
                                title: 'MLflow',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/mlflow.html',
                            },
                            {
                                title: 'Openmldb',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/openmldb.html',
                            },
                            {
                                title: 'DVC',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/dvc.html',
                            },
                            {
                                title: 'Dinky',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/dinky.html',
                            },
                            {
                                title: 'Java',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/java.html',
                            },
                            {
                                title: 'SageMaker',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/sagemaker.html',
                            },
                            {
                                title: 'ChunJun',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/chunjun.html',
                            },
                            {
                                title: 'Pytorch',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/pytorch.html',
                            },
                            {
                                title: 'Amazon DMS',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/dms.html',
                            },
                            {
                                title: 'AWS Datasync',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/datasync.html',
                            },
                            {
                                title: 'Kubeflow',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/kubeflow.html',
                            },
                            {
                                title: 'Apache Linkis',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/linkis.html',
                            },
                            {
                                title: 'Remote Shell',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/task/remoteshell.html',
                            },
                        ],
                    },
                    {
                        title: 'Parameter',
                        children: [
                            {
                                title: 'Built-in Parameter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/built-in.html',
                            },
                            {
                                title: 'Global Parameter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/global.html',
                            },
                            {
                                title: 'Local Parameter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/local.html',
                            },
                            {
                                title: 'Project-level Parameter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/project-parameter.html',
                            },
                            {
                                title: 'Parameter Context',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/context.html',
                            },
                            {
                                title: 'Parameter Priority',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/priority.html',
                            },
                            {
                                title: 'File Parameter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/file-parameter.html',
                            },
                            {
                                title: 'StartUp Parameter',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/parameter/startup-parameter.html',
                            },
                        ],
                    },
                    {
                        title: 'Data Source',
                        children: [
                            {
                                title: 'MySQL',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/mysql.html',
                            },
                            {
                                title: 'PostgreSQL',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/postgresql.html',
                            },
                            {
                                title: 'HIVE',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/hive.html',
                            },
                            {
                                title: 'SNOWFLAKE',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/snowflake.html',
                            },
                            {
                                title: 'KYUUBI',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/kyuubi.html',
                            },
                            {
                                title: 'Spark',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/spark.html',
                            },
                            {
                                title: 'Presto',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/presto.html',
                            },
                            {
                                title: 'SQL SERVER',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/sqlserver.html',
                            },
                            {
                                title: 'Amazon Redshift',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/redshift.html',
                            },
                            {
                                title: 'ClickHouse',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/clickhouse.html',
                            },
                            {
                                title: 'IBM DB2',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/db2.html',
                            },
                            {
                                title: 'Oracle',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/oracle.html',
                            },
                            {
                                title: 'Amazon Athena',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/athena.html',
                            },
                            {
                                title: 'Azure SQL Database',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/azure-sql.html',
                            },
                            {
                                title: 'Trino',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/trino.html',
                            },
                            {
                                title: 'StarRocks',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/starrocks.html',
                            },
                            {
                                title: 'DAMENG',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/dameng.html',
                            },
                            {
                                title: 'OceanBase',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/oceanbase.html',
                            },
                            {
                                title: 'SSH',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/ssh.html',
                            },
                            {
                                title: 'Databend',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/databend.html',
                            },
                            {
                                title: 'HANA',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/hana.html',
                            },
                            {
                                title: 'doris',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/doris.html',
                            },
                            {
                                title: 'Vertica',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/datasource/vertica.html',
                            }
                        ],
                    },
                    {
                        title: 'Alert',
                        children: [
                            {
                                title: 'Alert Component User Guide ',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/alert_plugin_user_guide.html',
                            },
                            {
                                title: 'Email',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/email.html',
                            },
                            {
                                title: 'Telegram',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/telegram.html',
                            },
                            {
                                title: 'Ding Talk',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/dingtalk.html',
                            },
                            {
                                title: 'Enterprise Wechat',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/enterprise-wechat.html',
                            },
                            {
                                title: 'Enterprise Webexteams',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/enterprise-webexteams.html',
                            },
                            {
                                title: 'Script',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/script.html',
                            },
                            {
                                title: 'Http',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/http.html',
                            },
                            {
                                title: 'Feishu',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/feishu.html',
                            },
                            {
                                title: 'Slack',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/slack.html',
                            },{
                                title: 'Aliyun Voice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/alert/aliyun-voice.html',
                            },
                        ],
                    },
                    {
                        title: 'Resource',
                        children: [
                            {
                                title: 'Introduction',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/resource/intro.html'
                            },
                            {
                                title: 'Configuration',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/resource/configuration.html'
                            },
                            {
                                title: 'File Manage',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/resource/file-manage.html'
                            },
                            {
                                title: 'Task Group Manage',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/resource/task-group.html'
                            },
                        ],
                    },
                    {
                        title: 'Monitor',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/monitor.html',
                    },
                    {
                        title: 'Security',
                        children: [
                            {
                                title: 'Security (Authorization System)',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/security/security.html',
                            },
                            {
                                title: 'Authentication Type',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/security/authentication-type.html',
                            }
                        ],
                    },

                    {
                        title: 'Metrics',
                        children: [
                            {
                                title: 'Metrics',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/metrics/metrics.html',
                            }
                        ],
                    },
                    {
                        title: 'Remote Logging',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/remote-logging.html',
                    },
                    {
                        title: 'Upgrade',
                        children: [
                            {
                                title: 'Incompatible',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/upgrade/incompatible.html',
                            },
                            {
                                title: 'Upgrade',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/upgrade/upgrade.html',
                            },
                        ],
                    },
                    {
                        title: 'Expansion and Reduction',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/expansion-reduction.html',
                    },
                    {
                        title: 'Demo',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/demo.html',
                    },
                ],
            },
            {
                title: 'Installation',
                children: [
                    {
                        title: 'Standalone Deployment',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/installation/standalone.html',
                    },
                    {
                        title: 'Pseudo Cluster Deployment',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/installation/pseudo-cluster.html',
                    },
                    {
                        title: 'Cluster Deployment',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/installation/cluster.html',
                    },
                    {
                        title: 'Kubernetes Deployment',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/installation/kubernetes.html',
                    },
                    {
                        title: 'General Setting',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/installation/general-setting.html',
                    },
                    {
                        title: 'Datasource Setting',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/installation/datasource-setting.html',
                    },
                    {
                        title: 'integration',
                        children: [
                            {
                                title: 'Rainbond Deployment',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/guide/integration/rainbond.html',
                            },
                        ],
                    },
                ],
            },
            {
                title: 'Architecture Guide',
                children: [
                    {
                        title: 'Architecture Design',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/architecture/design.html',
                    },
                    {
                        title: 'Metadata',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/architecture/metadata.html',
                    },
                    {
                        title: 'Configuration File',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/architecture/configuration.html',
                    },
                    {
                        title: 'Task Structure',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/architecture/task-structure.html',
                    },
                    {
                        title: 'Load Balance',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/architecture/load-balance.html',
                    },
                    {
                        title: 'Cache',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/architecture/cache.html',
                    },
                ],
            },
            {
                title: 'API',
                children: [
                    {
                        title: 'Open API',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/api/open-api.html',
                    },
                    {
                        title: 'PyDolphinScheduler',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/api/pydolphinscheduler.html',
                    },
                    {
                        title: 'Health Check',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/guide/api/healthcheck.html',
                    },
                ],
            },
            {
                title: 'Contribution',
                children: [
                    {
                        title: 'Join',
                        children: [
                            {
                                title: 'Security model',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/security-model.html',
                            },
                            {
                                title: 'Security Report',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/security.html',
                            },
                            {
                                title: 'How to Become a Committer',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/become-a-committer.html',
                            },
                            {
                                title: 'Subscribe Mailing Lists',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/subscribe.html',
                            },
                            {
                                title: 'Participate in Contributing',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/contribute.html',
                            },
                            {
                                title: 'Code of Conduct',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/code-conduct.html',
                            },
                            {
                                title: 'Review Issue or Pull Requests',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/review.html',
                            },
                            {
                                title: 'E2E Contribution Guide',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/e2e-guide.html',
                            },
                            {
                                title: 'Submit Code',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/submit-code.html',
                            },
                            {
                                title: 'License Notice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/DS-License.html',
                            },
                            {
                                title: 'Document Notice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/document.html',
                            },
                            {
                                title: 'Issue Notice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/issue.html',
                            },
                            {
                                title: 'Pull Request Notice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/pull-request.html',
                            },
                            {
                                title: 'Commit Message Notice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/commit-message.html',
                            },
                            {
                                title: 'Micro BenchMark Notice',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/microbench.html',
                            },
                            {
                                title: 'Unit Test Writing Guide',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/join/unit-test.html',
                            },
                        ],
                    },
                    {
                        title: 'Development Environment Setup',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/development-environment-setup.html',
                    },
                    {
                        title: 'Design Document',
                        children: [
                            // TODO not support multiply level for now
                            // {
                            // title: 'SPI',
                            // children: [
                            {
                                title: 'Architecture Design',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/architecture-design.html',
                            },
                            {
                                title: 'Alert SPI',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/backend/spi/alert.html',
                            },
                            {
                                title: 'Registry SPI',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/backend/spi/registry.html',
                            },
                            {
                                title: 'Task SPI',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/backend/spi/task.html',
                            },
                            {
                                title: 'Datasource SPI',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/backend/spi/datasource.html',
                            },
                            {
                                title: 'Mechanism Design',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/backend/mechanism/overview.html',
                            },
                        ],
                    },
                    {
                        title: 'Guidelines',
                        children: [
                            {
                                title: 'Frontend Development',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/frontend-development.html',
                            },
                            {
                                title: 'API Standard',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/api-standard.html',
                            },
                            {
                                title: 'E2E Automation Test',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/e2e-test.html',
                            },
                            {
                                title: 'API Automation Test',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/api-test.html',
                            },
                            {
                                title: 'Log Specification',
                                link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/log-specification.html',
                            },
                        ],
                    },
                    {
                        title: 'Releasing',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/release.html',
                    },
                    {
                        title: 'Questions & Communications',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/contribute/have-questions.html',
                    },
                ],
            },
            {
                title: 'DSIP',
                children: [
                    {
                        title: 'DSIP',
                        link: '/en-us/docs/3.3.0-alpha/user_doc/DSIP.html',
                    },
                ],
            },
            {
                title: 'Older Versions',
                children: [
                    {
                        title: 'Older Versions',
                        link: '/en-us/docs/release/history-versions.html',
                    },
                ],
            },
        ],
        barText: 'Documentation',
    },
    'zh-cn': {
        sidemenu: [
            {
                title: '关于Apache DolphinScheduler',
                children: [
                    {
                        title: '简介',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/about/introduction.html',
                    },
                    {
                        title: '特性',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/about/features.html',
                    },
                    {
                        title: '建议配置',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/about/hardware.html',
                    },
                    {
                        title: '名词解释',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/about/glossary.html',
                    },
                ],
            },
            {
                title: '快速上手',
                children: [
                    {
                        title: '快速上手',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/start/quick-start.html',
                    },
                    {
                        title: 'Docker部署(Docker)',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/start/docker.html',
                    },
                ],
            },
            {
                title: '功能介绍',
                children: [
                    {
                        title: '应用首页',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/homepage.html',
                    },
                    {
                        title: '项目管理',
                        children: [
                            {
                                title: '项目列表',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/project/project-list.html',
                            },
                            {
                                title: '工作流定义',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/project/workflow-definition.html',
                            },
                            {
                                title: '工作流实例',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/project/workflow-instance.html',
                            },
                            {
                                title: '任务实例',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/project/task-instance.html',
                            },
                            {
                                title: '任务定义',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/project/task-definition.html',
                            },
                        ]
                    },
                    {
                        title: '任务类型',
                        children: [
                            {
                                title: 'Appendix',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/appendix.html',
                            },
                            {
                                title: 'Shell',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/shell.html',
                            },
                            {
                                title: 'SubWorkflow',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/sub-workflow.html',
                            },
                            {
                                title: 'Dependent',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/dependent.html',
                            },
                            {
                                title: 'Stored Procedure',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/stored-procedure.html',
                            },
                            {
                                title: 'SQL',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/sql.html',
                            },
                            {
                                title: 'Spark',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/spark.html',
                            },
                            {
                                title: 'MapReduce',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/map-reduce.html',
                            },
                            {
                                title: 'Python',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/python.html',
                            },
                            {
                                title: 'Flink',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/flink.html',
                            },
                            {
                                title: 'HTTP',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/http.html',
                            },
                            {
                                title: 'DataX',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/datax.html',
                            },
                            {
                                title: 'Sqoop',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/sqoop.html',
                            },
                            {
                                title: 'Conditions',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/conditions.html',
                            },
                            {
                                title: 'Switch',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/switch.html',
                            },
                            {
                                title: 'SeaTunnel',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/seatunnel.html',
                            },
                            {
                                title: 'Amazon EMR',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/emr.html',
                            },
                            {
                                title: 'Apache Zeppelin',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/zeppelin.html',
                            },
                            {
                                title: 'Jupyter',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/jupyter.html',
                            },
                            {
                                title: 'Hive CLI',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/hive-cli.html',
                            },
                            {
                                title: 'Kubernetes',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/kubernetes.html',
                            },
                            {
                                title: 'MLflow',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/mlflow.html',
                            },
                            {
                                title: 'Openmldb',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/openmldb.html',
                            },
                            {
                                title: 'DVC',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/dvc.html',
                            },
                            {
                                title: 'Dinky',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/dinky.html',
                            },
                            {
                                title: 'Java',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/java.html',
                            },
                            {
                                title: 'SageMaker',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/sagemaker.html',
                            },
                            {
                                title: 'ChunJun',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/chunjun.html',
                            },
                            {
                                title: 'Pytorch',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/pytorch.html',
                            },
                            {
                                title: 'Amazon DMS',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/dms.html',
                            },
                            {
                                title: 'AWS Datasync',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/datasync.html',
                            },
                            {
                                title: 'Kubeflow',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/kubeflow.html',
                            },
                            {
                                title: 'Apache Linkis',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/linkis.html',
                            },
                            {
                                title: 'Remote Shell',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/task/remoteshell.html',
                            },
                        ],
                    },
                    {
                        title: '参数',
                        children: [
                            {
                                title: '内置参数',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/built-in.html',
                            },
                            {
                                title: '全局参数',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/global.html',
                            },
                            {
                                title: '本地参数',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/local.html',
                            },
                            {
                                title: '项目级别参数',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/project-parameter.html',
                            },
                            {
                                title: '参数传递',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/context.html',
                            },
                            {
                                title: '参数优先级',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/priority.html',
                            },
                            {
                                title: '文件参数传递',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/file-parameter.html',
                            },
                            {
                                title: '启动参数',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/parameter/startup-parameter.html',
                            },
                        ],
                    },
                    {
                        title: '数据源中心',
                        children: [
                            {
                                title: 'MySQL',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/mysql.html',
                            },
                            {
                                title: 'PostgreSQL',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/postgresql.html',
                            },
                            {
                                title: 'HIVE',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/hive.html',
                            },
                            {
                                title: 'SNOWFLAKE',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/snowflake.html',
                            },
                            {
                                title: 'KYUUBI',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/kyuubi.html',
                            },
                            {
                                title: 'Spark',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/spark.html',
                            },
                            {
                                title: 'Amazon Athena',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/athena.html',
                            },
                            {
                                title: 'Azure SQL Database',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/azure-sql.html',
                            },
                            {
                                title: 'Redshift',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/redshift.html',
                            },
                            {
                                title: 'Oracle',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/oracle.html',
                            },
                            {
                                title: 'Trino',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/trino.html',
                            },
                            {
                                title: 'StarRocks',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/starrocks.html',
                            },
                            {
                                title: 'DAMENG',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/dameng.html',
                            },
                            {
                                title: 'OceanBase',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/oceanbase.html',
                            },
                            {
                                title: 'SSH',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/ssh.html',
                            },
                            {
                                title: 'Databend',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/databend.html',
                            },
                            {
                                title: 'HANA',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/hana.html',
                            },
                            {
                                title: 'Doris',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/doris.html',
                            },
                            {
                                title: 'Vertica',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/datasource/vertica.html',
                            },
                        ],
                    },
                    {
                        title: '告警',
                        children: [
                            {
                                title: '告警组件向导',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/alert_plugin_user_guide.html',
                            },
                            {
                                title: 'Email',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/email.html',
                            },
                            {
                                title: 'Telegram',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/telegram.html',
                            },
                            {
                                title: '钉钉告警',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/dingtalk.html',
                            },
                            {
                                title: '企业微信',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/enterprise-wechat.html',
                            },
                            {
                                title: 'Webexteams',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/enterprise-webexteams.html',
                            },
                            {
                                title: '脚本告警',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/script.html',
                            },
                            {
                                title: 'Http告警',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/http.html',
                            },
                            {
                                title: '飞书告警',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/feishu.html',
                            },
                            {
                                title: 'Slack告警',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/slack.html',
                            },
                            {
                                title: '阿里云语音告警',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/alert/aliyun-voice.html',
                            },
                        ],
                    },
                    {
                        title: '资源中心',
                        children: [
                            {
                                title: '简介',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/resource/intro.html'
                            },
                            {
                                title: '配置详情',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/resource/configuration.html'
                            },
                            {
                                title: '文件管理',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/resource/file-manage.html'
                            },
                            {
                                title: '任务组管理',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/resource/task-group.html'
                            },
                        ],
                    },
                    {
                        title: '监控中心',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/monitor.html',
                    },
                    {
                        title: '安全中心',
                        children: [
                            {
                                title: '安全中心（权限系统）',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/security/security.html',
                            },
                            {
                                title: '认证方式',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/security/authentication-type.html',
                            }
                        ],
                    },
                    {
                        title: '指标相关',
                        children: [
                            {
                                title: '指标',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/metrics/metrics.html',
                            }
                        ],
                    },
                    {
                        title: '远程日志存储',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/remote-logging.html',
                    },
                    {
                        title: '升级',
                        children: [
                            {
                                title: '不向前兼容的更新',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/upgrade/incompatible.html',
                            },
                            {
                                title: '升级步骤',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/upgrade/upgrade.html',
                            },
                        ],
                    },
                    {
                        title: '扩/缩容',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/expansion-reduction.html',
                    },
                    {
                        title: 'Demo',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/demo.html',
                    },
                ],
            },
            {
                title: '部署指南',
                children: [
                    {
                        title: '单机部署(Standalone)',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/installation/standalone.html',
                    },
                    {
                        title: '伪集群部署(Pseudo-Cluster)',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/installation/pseudo-cluster.html',
                    },
                    {
                        title: '集群部署(Cluster)',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/installation/cluster.html',
                    },
                    {
                        title: 'Kubernetes部署(Kubernetes)',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/installation/kubernetes.html',
                    },
                    {
                        title: '通用设置',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/installation/general-setting.html',
                    },
                    {
                        title: '数据源设置',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/installation/datasource-setting.html',
                    },
                    {
                        title: '集成',
                        children: [
                            {
                                title: '基于Rainbond部署(Cluster)',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/integration/rainbond.html',
                            },
                        ],
                    },
                ],
            },
            {
                title: '架构设计',
                children: [
                    {
                        title: '元数据文档',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/architecture/metadata.html',
                    },
                    {
                        title: '架构设计',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/architecture/design.html',
                    },
                    {
                        title: '配置文件',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/architecture/configuration.html',
                    },
                    {
                        title: '任务结构',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/architecture/task-structure.html',
                    },
                    {
                        title: '负载均衡',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/architecture/load-balance.html',
                    },
                    {
                        title: '缓存',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/architecture/cache.html',
                    },
                ],
            },
            {
                title: 'API',
                children: [
                    {
                        title: 'API调用',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/api/open-api.html',
                    },
                    {
                        title: 'PyDolphinScheduler',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/api/pydolphinscheduler.html',
                    },
                    {
                        title: '健康检查',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/guide/api/healthcheck.html',
                    },
                ],
            },
            {
                title: '贡献指南',
                children: [
                    {
                        title: '如何参与',
                        children: [
                            {
                                title: '安全模型',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/security-model.html',
                            },
                            {
                                title: '报告安全问题',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/security.html',
                            },
                            {
                                title: '如何成为 Committer',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/become-a-committer.html',
                            },
                            {
                                title: '订阅/取消订阅邮件列表',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/subscribe.html',
                            },
                            {
                                title: '参与贡献',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/contribute.html',
                            },
                            {
                                title: '行为准则',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/code-conduct.html',
                            },
                            {
                                title: 'Review Issue or Pull Requests',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/review.html',
                            },
                            {
                                title: 'E2E Contribution Guide',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/e2e-guide.html',
                            },
                            {
                                title: '提交代码',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/submit-code.html',
                            },
                            {
                                title: 'License须知',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/DS-License.html',
                            },
                            {
                                title: '文档须知',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/document.html',
                            },
                            {
                                title: 'Issue须知',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/issue.html',
                            },
                            {
                                title: 'Pull Request须知',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/pull-request.html',
                            },
                            {
                                title: 'Commit Message须知',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/commit-message.html',
                            },
                            {
                                title: '微基准测试须知',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/microbench.html',
                            },
                            {
                                title: '单元测试编写指南',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/join/unit-test.html',
                            },
                        ],
                    },
                    {
                        title: '环境搭建',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/development-environment-setup.html',
                    },
                    {
                        title: '设计文档',
                        children: [
                            {
                                title: '架构设计',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/architecture-design.html',
                            },
                            {
                                title: 'Alert SPI',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/backend/spi/alert.html',
                            },
                            {
                                title: 'Registry SPI',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/backend/spi/registry.html',
                            },
                            {
                                title: 'Task SPI',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/backend/spi/task.html',
                            },
                            {
                                title: 'Datasource SPI',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/backend/spi/datasource.html',
                            },
                            {
                                title: '组件设计',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/backend/mechanism/overview.html',
                            },
                        ],
                    },
                    {
                        title: '规范',
                        children: [
                            {
                                title: '前端开发',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/frontend-development.html',
                            },
                            {
                                title: 'API规范',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/api-standard.html',
                            },
                            {
                                title: 'E2E 自动化测试',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/e2e-test.html',
                            },
                            {
                                title: 'API 自动化测试',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/api-test.html',
                            },
                            {
                                title: '日志规范',
                                link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/log-specification.html',
                            },
                        ],
                    },
                    {
                        title: '发版',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/release.html',
                    },
                    {
                        title: '问题与交流',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/contribute/have-questions.html',
                    },
                ],
            },
            {
                title: 'DSIP',
                children: [
                    {
                        title: 'DSIP',
                        link: '/zh-cn/docs/3.3.0-alpha/user_doc/DSIP.html',
                    },
                ],
            },
            {
                title: '历史版本',
                children: [
                    {
                        title: '历史版本',
                        link: '/zh-cn/docs/release/history-versions.html',
                    },
                ],
            },
        ],
        barText: '文档',
    },
};
