/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.EnumValue;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.exceptions.InvalidValueException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueUtils {
    private static final Logger log = LoggerFactory.getLogger(ValueUtils.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd";
    protected static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static final ThreadLocal<SimpleDateFormat> dateOnlyFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ValueUtils.DATE_FORMAT);
        }
    };
    protected static final ThreadLocal<SimpleDateFormat> dateTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ValueUtils.DATETIME_FORMAT);
        }
    };
    public static final Integer INTEGER_ZERO = new Integer(0);
    public static final Long LONG_ZERO = new Long(0L);
    public static final Double DOUBLE_ZERO = new Double(0.0);

    protected ValueUtils() {
    }

    public boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o == ObjectUtils.NO_VALUE) {
            throw new InvalidValueException(o);
        }
        if (o instanceof String) {
            return ((String)o).length() == 0;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length == 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof DBValueExpr) {
            return this.isEmpty(((DBValueExpr)o).getValue());
        }
        if (o instanceof Enum) {
            return this.isEmpty(this.enumToString((Enum)o));
        }
        return false;
    }

    public boolean isZero(Number value) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
        }
        if (value instanceof Float) {
            return ((Float)value).compareTo(Float.valueOf(0.0f)) == 0;
        }
        if (value instanceof Double) {
            return ((Double)value).compareTo(0.0) == 0;
        }
        if (value instanceof Long) {
            return value.longValue() == 0L;
        }
        return value.intValue() == 0;
    }

    public boolean compareEqual(Object o1, Object o2) {
        String strVal;
        if (o1 == o2) {
            return true;
        }
        if (this.isEmpty(o1)) {
            return this.isEmpty(o2);
        }
        if (this.isEmpty(o2)) {
            return this.isEmpty(o1);
        }
        if (o1.getClass().equals(o2.getClass())) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                return this.compareEqual(o1, o2);
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2) == 0;
            }
            return o1.equals(o2);
        }
        if (o1.equals(o2) || o2.equals(o1)) {
            return true;
        }
        if (o1 instanceof DBExpr || o2 instanceof DBExpr) {
            return false;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            double d2;
            double d1 = ((Number)o1).doubleValue();
            return d1 == (d2 = ((Number)o2).doubleValue());
        }
        if (o1 instanceof Temporal && o2 instanceof java.util.Date) {
            Object tmp = o2;
            o2 = o1;
            o1 = tmp;
        }
        if (o1 instanceof java.util.Date && o2 instanceof LocalDate) {
            return o1.equals(DateUtils.toDate((LocalDate)o2));
        }
        if (o1 instanceof java.util.Date && o2 instanceof LocalDateTime) {
            return o1.equals(DateUtils.toDate((LocalDateTime)o2));
        }
        if (o1 instanceof Enum) {
            if (o2 instanceof Number) {
                return ((Enum)o1).ordinal() == ((Number)o2).intValue();
            }
            strVal = this.enumToString((Enum)o1);
            return StringUtils.compareEqual(strVal, this.toString(o2));
        }
        if (o2 instanceof Enum) {
            if (o1 instanceof Number) {
                return ((Enum)o2).ordinal() == ((Number)o1).intValue();
            }
            strVal = this.enumToString((Enum)o2);
            return StringUtils.compareEqual(strVal, this.toString(o1));
        }
        if (o1 instanceof String) {
            return ((String)o1).equals(o2.toString());
        }
        if (o2 instanceof String) {
            return ((String)o2).equals(o1.toString());
        }
        return false;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (this.isEmpty(o1)) {
            return this.isEmpty(o2) ? 0 : -1;
        }
        if (this.isEmpty(o2)) {
            return this.isEmpty(o1) ? 0 : 1;
        }
        if (o1.getClass().equals(o2.getClass())) {
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o2 instanceof Comparable) {
                return ((Comparable)o2).compareTo(o1);
            }
        }
        if (o1.equals(o2) || o2.equals(o1)) {
            return 0;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            double d2;
            double d1 = ((Number)o1).doubleValue();
            return d1 < (d2 = ((Number)o2).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        }
        if (o1 instanceof Temporal && o2 instanceof java.util.Date) {
            Object tmp = o2;
            o2 = o1;
            o1 = tmp;
        }
        if (o1 instanceof java.util.Date && o2 instanceof LocalDate) {
            return this.compare(o1, DateUtils.toDate((LocalDate)o2));
        }
        if (o1 instanceof java.util.Date && o2 instanceof LocalDateTime) {
            return this.compare(o1, DateUtils.toDate((LocalDateTime)o2));
        }
        return o1.toString().compareTo(o2.toString());
    }

    public Integer toInteger(Object v) {
        if (this.isEmpty(v)) {
            return 0;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof Enum) {
            return this.toInteger(this.enumToValue((Enum)v, true));
        }
        String str = v.toString();
        return Integer.parseInt(str);
    }

    public Long toLong(Object v) {
        if (this.isEmpty(v)) {
            return 0L;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof Enum) {
            return this.toLong(this.enumToValue((Enum)v, true));
        }
        String str = v.toString();
        return Long.parseLong(str);
    }

    public Double toDouble(Object v) {
        if (this.isEmpty(v)) {
            return 0.0;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof Enum) {
            return this.toDouble(this.enumToValue((Enum)v, true));
        }
        String val = v.toString();
        return Double.parseDouble(val);
    }

    public BigDecimal toDecimal(Object v) {
        if (this.isEmpty(v)) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof Number) {
            if (v instanceof BigInteger) {
                return new BigDecimal((BigInteger)v);
            }
            if (v instanceof Integer) {
                return BigDecimal.valueOf(((Number)v).intValue());
            }
            if (v instanceof Long) {
                return BigDecimal.valueOf(((Number)v).longValue());
            }
            return BigDecimal.valueOf(((Number)v).doubleValue());
        }
        if (v instanceof Enum) {
            return this.toDecimal(this.enumToValue((Enum)v, true));
        }
        return new BigDecimal(v.toString());
    }

    public Boolean toBoolean(Object v, boolean defValue) {
        if (this.isEmpty(v)) {
            return defValue;
        }
        if (v instanceof Boolean) {
            return (boolean)((Boolean)v);
        }
        if (v instanceof Number) {
            return ((Number)v).intValue() != 0;
        }
        if (v instanceof String) {
            String val = (String)v;
            if (StringUtils.isEmpty(val)) {
                return defValue;
            }
            return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("Y");
        }
        return defValue;
    }

    public <T extends Enum<?>> T toEnum(Class<T> enumType, Object value) {
        if (this.isEmpty(value)) {
            return null;
        }
        if (value instanceof Enum) {
            if (value.getClass().equals(enumType)) {
                return (T)((Enum)value);
            }
            value = ((Enum)value).name();
        }
        boolean numeric = value instanceof Number;
        Enum[] items = (Enum[])enumType.getEnumConstants();
        if (items.length > 0 && items[0] instanceof EnumValue) {
            for (Enum e : items) {
                Object eVal = ((EnumValue)((Object)e)).toValue(numeric);
                if (!this.compareEqual(eVal, value)) continue;
                return (T)e;
            }
            throw new ItemNotFoundException((Object)StringUtils.toString(value));
        }
        if (numeric) {
            int ordinal = ((Number)value).intValue();
            if (ordinal < 0 || ordinal >= items.length) {
                throw new ItemNotFoundException((Object)String.valueOf(ordinal));
            }
            return (T)items[ordinal];
        }
        String name = StringUtils.toString(value);
        for (Enum e : items) {
            if (!e.name().equals(name)) continue;
            return (T)e;
        }
        throw new ItemNotFoundException((Object)name);
    }

    public <T extends Enum<?>> T toEnumByName(Class<T> enumType, String name) {
        Enum[] items;
        if (this.isEmpty(name)) {
            return null;
        }
        for (Enum e : items = (Enum[])enumType.getEnumConstants()) {
            if (!e.name().equals(name)) continue;
            return (T)e;
        }
        throw new ItemNotFoundException((Object)name);
    }

    public Object enumToValue(Enum<?> enumValue, boolean isNumeric) {
        if (enumValue instanceof EnumValue) {
            return ((EnumValue)((Object)enumValue)).toValue(isNumeric);
        }
        return isNumeric ? Integer.valueOf(enumValue.ordinal()) : this.enumToString(enumValue);
    }

    public String enumToString(Enum<?> enumValue) {
        if (enumValue instanceof EnumValue) {
            return StringUtils.toString(((EnumValue)((Object)enumValue)).toValue(false));
        }
        if (enumValue == null || enumValue.name().equalsIgnoreCase("NULL")) {
            return "";
        }
        return enumValue.name();
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == ObjectUtils.NO_VALUE) {
            throw new InvalidValueException(value);
        }
        if (value instanceof Enum) {
            return this.enumToString((Enum)value);
        }
        if (value instanceof java.util.Date) {
            return this.formatDate((java.util.Date)value, true);
        }
        return value.toString();
    }

    public int lengthOf(Object o) {
        if (o == null || o == ObjectUtils.NO_VALUE) {
            return 0;
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        return o.toString().length();
    }

    public java.util.Date toDate(Object v) throws ParseException {
        if (this.isEmpty(v)) {
            return null;
        }
        if (v instanceof java.util.Date) {
            return (java.util.Date)v;
        }
        if (v instanceof LocalDate) {
            return DateUtils.toDate((LocalDate)v);
        }
        if (v instanceof LocalDateTime) {
            return DateUtils.toDate((LocalDateTime)v);
        }
        if (v instanceof Number) {
            long l = ((Number)v).longValue();
            return l == 0L ? null : new java.util.Date(l);
        }
        String str = v.toString();
        if (str.length() > 20) {
            return Timestamp.valueOf(str);
        }
        if (str.length() > 10) {
            return dateTimeFormatter.get().parse(str);
        }
        return dateOnlyFormatter.get().parse(str);
    }

    public LocalDate toLocalDate(Object v) {
        if (this.isEmpty(v)) {
            return null;
        }
        if (v instanceof LocalDate) {
            return (LocalDate)v;
        }
        if (v instanceof LocalDateTime) {
            return ((LocalDateTime)v).toLocalDate();
        }
        if (v instanceof Timestamp) {
            return ((Timestamp)v).toLocalDateTime().toLocalDate();
        }
        if (v instanceof Date) {
            return ((Date)v).toLocalDate();
        }
        if (v instanceof java.util.Date) {
            return DateUtils.toLocalDate((java.util.Date)v);
        }
        String str = v.toString();
        return LocalDate.parse(str);
    }

    public LocalDateTime toLocalDateTime(Object v) {
        if (this.isEmpty(v)) {
            return null;
        }
        if (v instanceof LocalDate) {
            return ((LocalDate)v).atStartOfDay();
        }
        if (v instanceof LocalDateTime) {
            return (LocalDateTime)v;
        }
        if (v instanceof Timestamp) {
            return ((Timestamp)v).toLocalDateTime();
        }
        if (v instanceof Date) {
            return ((Date)v).toLocalDate().atStartOfDay();
        }
        if (v instanceof java.util.Date) {
            return DateUtils.toLocalDateTime((java.util.Date)v);
        }
        String str = v.toString();
        return LocalDateTime.parse(str);
    }

    public Timestamp toTimestamp(Object v) {
        if (this.isEmpty(v)) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        if (v instanceof LocalDate) {
            return Timestamp.valueOf(((LocalDate)v).atStartOfDay());
        }
        if (v instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)v);
        }
        if (v instanceof Date) {
            return Timestamp.valueOf(((Date)v).toLocalDate().atStartOfDay());
        }
        if (v instanceof java.util.Date) {
            return Timestamp.valueOf(DateUtils.toLocalDateTime((java.util.Date)v));
        }
        String str = v.toString();
        return Timestamp.valueOf(str);
    }

    public String formatDate(java.util.Date date, boolean withTime) {
        if (date == null) {
            return null;
        }
        if (withTime) {
            return dateTimeFormatter.get().format(date);
        }
        return dateOnlyFormatter.get().format(date);
    }

    public String formatColumnValue(ColumnExpr column, Object value, Locale locale) {
        Options options = column.getOptions();
        if (options != null && options.has(value)) {
            return options.get(value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (ObjectUtils.isEmpty(value)) {
            value = column.getAttribute("nullText");
            return value != null ? value.toString() : "";
        }
        if (value instanceof java.util.Date || value instanceof LocalDate || value instanceof LocalDateTime) {
            boolean dateOnly = column.getDataType().equals((Object)DataType.DATE);
            if (locale == null) {
                try {
                    return this.formatDate(this.toDate(value), !dateOnly);
                }
                catch (ParseException e) {
                    return value.toString();
                }
            }
            if (dateOnly) {
                return DateUtils.formatDate(this.toLocalDate(value), locale);
            }
            return DateUtils.formatDate(this.toLocalDateTime(value), locale);
        }
        if (value instanceof Enum) {
            return this.enumToString((Enum)value);
        }
        return StringUtils.valueOf(value);
    }

    public <T> T convertToJava(Class<T> c, Object v) throws ClassCastException {
        if (v == null || c.isInstance(v)) {
            return (T)v;
        }
        if (v == ObjectUtils.NO_VALUE) {
            throw new InvalidValueException(v);
        }
        if (c.isPrimitive()) {
            c = MethodUtils.getPrimitiveWrapper(c);
        }
        if (c.isEnum()) {
            T ev = this.toEnum(c, v);
            return ev;
        }
        if (c.isAssignableFrom(Boolean.class)) {
            return c.cast(this.toBoolean(v, false));
        }
        if (c.isAssignableFrom(Integer.class)) {
            return c.cast(this.isEmpty(v) ? 0 : this.toInteger(v));
        }
        if (c.isAssignableFrom(Long.class)) {
            return c.cast(this.isEmpty(v) ? 0L : this.toLong(v));
        }
        if (c.isAssignableFrom(Double.class)) {
            return c.cast(this.isEmpty(v) ? 0.0 : this.toDouble(v));
        }
        if (c.isAssignableFrom(BigDecimal.class)) {
            return c.cast(this.isEmpty(v) ? BigDecimal.ZERO : this.toDecimal(v));
        }
        if (c.isAssignableFrom(String.class)) {
            return c.cast(this.toString(v));
        }
        return c.cast(v);
    }

    public <T> T convertColumnValue(ColumnExpr column, Object value, Class<T> vt) throws ClassCastException {
        if (value == ObjectUtils.NO_VALUE) {
            throw new InvalidValueException(value);
        }
        if (vt == Object.class) {
            return (T)value;
        }
        if (vt == String.class) {
            return (T)this.toString(value);
        }
        if (vt == Integer.class) {
            return (T)(value != null ? this.toInteger(value) : INTEGER_ZERO);
        }
        if (vt == Long.class) {
            return (T)(value != null ? this.toLong(value) : LONG_ZERO);
        }
        if (vt == Double.class) {
            return (T)(value != null ? this.toDouble(value) : DOUBLE_ZERO);
        }
        if (vt == BigDecimal.class) {
            return (T)(value != null ? this.toDecimal(value) : BigDecimal.ZERO);
        }
        if (vt == Boolean.class) {
            return (T)(value != null ? this.toBoolean(value, false) : Boolean.FALSE);
        }
        if (value == null) {
            return null;
        }
        if (vt.isEnum()) {
            Class<T> enumType = vt;
            try {
                boolean numeric = column.getDataType().isNumeric();
                return this.toEnum(enumType, numeric ? this.toInteger(value) : value);
            }
            catch (Exception e) {
                log.error("Unable to resolve enum value of '{}' for type {}", value, (Object)enumType.getName());
                throw new FieldIllegalValueException(column.getUpdateColumn(), String.valueOf(value), (Throwable)e);
            }
        }
        try {
            if (vt == java.util.Date.class) {
                return (T)this.toDate(value);
            }
            if (vt == Timestamp.class) {
                return (T)this.toTimestamp(value);
            }
            if (vt == LocalDate.class) {
                return (T)this.toLocalDate(value);
            }
            if (vt == LocalDateTime.class) {
                return (T)this.toLocalDateTime(value);
            }
        }
        catch (ParseException | DateTimeParseException e) {
            throw new ValueConversionException(Timestamp.class, value, e);
        }
        return this.convertToJava(vt, value);
    }

    public Object convertToData(DataType dataType, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof DBExpr) {
            return value;
        }
        if (value instanceof String && ((String)value).length() == 0) {
            return null;
        }
        if (value instanceof OptionEntry) {
            value = ((OptionEntry)value).getValue();
        }
        if (value instanceof Enum) {
            return value;
        }
        switch (dataType) {
            case BLOB: {
                return value;
            }
            case BOOL: {
                return this.toBoolean(value, false);
            }
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                if (value instanceof java.util.Date || value instanceof Temporal) {
                    return value;
                }
                if (DBDatabase.SYSDATE.equals(value)) {
                    return value;
                }
                try {
                    return this.toDate(value);
                }
                catch (ParseException e) {
                    throw new ValueConversionException(java.util.Date.class, value, e);
                }
            }
            case INTEGER: {
                return value instanceof Number ? value : this.toLong(value);
            }
            case FLOAT: {
                return value instanceof Number ? value : this.toDouble(value);
            }
            case DECIMAL: {
                return value instanceof Number ? value : this.toDecimal(value);
            }
            case CHAR: 
            case CLOB: 
            case VARCHAR: {
                return value instanceof String ? value : value.toString();
            }
        }
        return value;
    }
}

