/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.set;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;

public class DBSetExpr
extends DBExpr {
    public final DBColumn column;
    public Object value;

    public DBSetExpr(DBColumn expr, Object value) {
        this.column = expr;
        this.value = value;
    }

    public final DBDatabase getDatabase() {
        return this.column.getDatabase();
    }

    public DBRowSet getTable() {
        return this.column.getRowSet();
    }

    public DBColumn getColumn() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        list.add(this.column);
    }

    public DBSetExpr copy(DBCommand newCmd) {
        Object valueCopy = this.value;
        if (this.value instanceof DBCmdParam) {
            valueCopy = newCmd.addParam(DataType.UNKNOWN, ((DBCmdParam)this.value).getValue());
        }
        return new DBSetExpr(this.column, valueCopy);
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 1L) != 0L) {
            this.column.addSQL(sql, 1L);
        }
        if ((context & 1L) != 0L && (context & 4L) != 0L) {
            sql.append("=");
        }
        if ((context & 4L) != 0L) {
            sql.appendValue(this.column.getDataType(), this.value, context, "+");
        }
    }
}

