/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

public class Hex {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static class Encoder {
        private StringBuffer output;

        public Encoder(int size) {
            this.output = new StringBuffer(size * 2);
        }

        private void encodeBlock(byte work) {
            this.output.append(digits[(work & 0xF0) >>> 4]);
            this.output.append(digits[work & 0xF]);
        }

        public void encode(byte[] data) {
            this.encode(data, 0, data.length);
        }

        public void encode(byte[] data, int offset, int length) {
            for (int plainIndex = offset; plainIndex < offset + length; ++plainIndex) {
                this.encodeBlock(data[plainIndex]);
            }
        }

        public String drain() {
            String r = this.output.toString();
            this.output.setLength(0);
            return r;
        }

        public String flush() {
            return this.drain();
        }
    }

    public static class Decoder {
        private int filled = 0;
        private byte[] data;
        private int[] work = new int[]{0, 0};

        public Decoder() {
            this.data = new byte[256];
        }

        public void decode(String encoded) {
            int estimate = 1 + encoded.length() / 2;
            if (this.filled + estimate > this.data.length) {
                int length;
                for (length = this.data.length * 2; length < this.filled + estimate; length *= 2) {
                }
                byte[] newdata = new byte[length];
                System.arraycopy(this.data, 0, newdata, 0, this.filled);
                this.data = newdata;
            }
            for (int i = 0; i < encoded.length(); ++i) {
                this.work[0] = Character.digit(encoded.charAt(i), 16);
                this.work[1] = Character.digit(encoded.charAt(++i), 16);
                this.data[this.filled++] = (byte)((this.work[0] << 4 | this.work[1]) & 0xFF);
            }
        }

        public byte[] drain() {
            byte[] r = new byte[this.filled];
            System.arraycopy(this.data, 0, r, 0, this.filled);
            this.filled = 0;
            return r;
        }

        public byte[] flush() throws IllegalStateException {
            return this.drain();
        }

        public void reset() {
            this.filled = 0;
        }
    }
}

