/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.functions.casting.AbstractCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.ExpressionCodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

class IdentityCastRule
extends AbstractCodeGeneratorCastRule<Object, Object>
implements ExpressionCodeGeneratorCastRule<Object, Object> {
    static final IdentityCastRule INSTANCE = new IdentityCastRule();

    private IdentityCastRule() {
        super(CastRulePredicate.builder().predicate(IdentityCastRule::isIdentityCast).build());
    }

    private static boolean isIdentityCast(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (inputLogicalType.is(LogicalTypeRoot.INTERVAL_YEAR_MONTH) && targetLogicalType.is(LogicalTypeRoot.INTEGER) || inputLogicalType.is(LogicalTypeRoot.INTEGER) && targetLogicalType.is(LogicalTypeRoot.INTERVAL_YEAR_MONTH)) {
            return true;
        }
        if (inputLogicalType.is(LogicalTypeRoot.INTERVAL_DAY_TIME) && targetLogicalType.is(LogicalTypeRoot.BIGINT) || inputLogicalType.is(LogicalTypeRoot.BIGINT) && targetLogicalType.is(LogicalTypeRoot.INTERVAL_DAY_TIME)) {
            return true;
        }
        return LogicalTypeCasts.supportsAvoidingCast((LogicalType)inputLogicalType, (LogicalType)targetLogicalType);
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return inputTerm;
    }

    @Override
    public CastCodeBlock generateCodeBlock(CodeGeneratorCastRule.Context context, String inputTerm, String inputIsNullTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return CastCodeBlock.withoutCode(inputTerm, inputIsNullTerm);
    }
}

