/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.hint.QueryHintsRelShuttle;
import org.apache.flink.table.planner.hint.StateTtlHint;

public class CapitalizeQueryHintsShuttle
extends QueryHintsRelShuttle {
    @Override
    protected RelNode doVisit(RelNode node) {
        Hintable hNode = (Hintable)((Object)node);
        AtomicBoolean changed = new AtomicBoolean(false);
        List<RelHint> hintsWithCapitalJoinHints = hNode.getHints().stream().map(hint -> {
            String capitalHintName = hint.hintName.toUpperCase(Locale.ROOT);
            if (!FlinkHints.isQueryHint(capitalHintName) || hint.hintName.equals(capitalHintName)) {
                return hint;
            }
            changed.set(true);
            if (JoinStrategy.isJoinStrategy(capitalHintName)) {
                if (JoinStrategy.isLookupHint(hint.hintName)) {
                    return RelHint.builder(capitalHintName).hintOptions(hint.kvOptions).inheritPath(hint.inheritPath).build();
                }
                return RelHint.builder(capitalHintName).hintOptions(hint.listOptions).inheritPath(hint.inheritPath).build();
            }
            if (StateTtlHint.isStateTtlHint(hint.hintName)) {
                return RelHint.builder(capitalHintName).hintOptions(hint.kvOptions).inheritPath(hint.inheritPath).build();
            }
            throw new IllegalStateException("Unknown hint: " + hint.hintName);
        }).collect(Collectors.toList());
        if (changed.get()) {
            return super.visit(hNode.withHints(hintsWithCapitalJoinHints));
        }
        return super.visit(node);
    }
}

